/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs.patches;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.TCLineReader;
import jetbrains.buildServer.util.TCStreamUtil;
import jetbrains.buildServer.vcs.patches.AbstractFSPatcherCallback;
import jetbrains.buildServer.vcs.patches.LowLevelPatcherListener;
import jetbrains.buildServer.vcs.patches.PatcherErrorHandler;
import org.jetbrains.annotations.NotNull;

public abstract class FSPatcherCallbackImpl
implements AbstractFSPatcherCallback {
    private static final Logger LOG = Logger.getInstance((String)FSPatcherCallbackImpl.class.getName());

    @NotNull
    protected AbstractFSPatcherCallback getThis() {
        FSPatcherCallbackImpl fSPatcherCallbackImpl = this;
        if (fSPatcherCallbackImpl == null) {
            FSPatcherCallbackImpl.$$$reportNull$$$0(0);
        }
        return fSPatcherCallbackImpl;
    }

    @Override
    public void addDirectory(@NotNull File file) throws IOException {
        if (file == null) {
            FSPatcherCallbackImpl.$$$reportNull$$$0(1);
        }
        if (file.isDirectory() && file.exists()) {
            return;
        }
        this.ensureParentFolder(file);
        File parent = file.getParentFile();
        if (parent == null) {
            this.getErrorHandler().addDirectoryFailed(file);
            return;
        }
        if (!parent.isDirectory() || !parent.exists()) {
            this.getThis().addDirectory(parent);
        }
        if (parent.exists()) {
            file.mkdir();
        }
        if (!file.exists()) {
            this.getErrorHandler().addDirectoryFailed(file);
        }
    }

    @Override
    public void deleteFile(@NotNull File file, boolean deleteParentDirectoryIfEmpty, boolean isFile) throws IOException {
        File parent;
        File[] siblings;
        File[] files;
        if (file == null) {
            FSPatcherCallbackImpl.$$$reportNull$$$0(2);
        }
        if ((files = file.listFiles()) != null) {
            for (File childFile : files) {
                this.deleteFile(childFile, false, childFile.isFile());
            }
        }
        for (int i = 0; i < 10 && !file.delete() && file.exists(); ++i) {
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (file.exists()) {
            this.getErrorHandler().deleteFailed(file);
        } else if (deleteParentDirectoryIfEmpty && ((siblings = (parent = file.getParentFile()).listFiles()) == null || siblings.length == 0)) {
            this.deleteFile(parent, true, false);
        }
    }

    @Override
    public void renameFile(@NotNull File oldFile, @NotNull File newPath, boolean deleteParentDirectoryIfEmpty, boolean isFile) throws IOException {
        File file;
        if (oldFile == null) {
            FSPatcherCallbackImpl.$$$reportNull$$$0(3);
        }
        if (newPath == null) {
            FSPatcherCallbackImpl.$$$reportNull$$$0(4);
        }
        if (!(file = oldFile).exists()) {
            this.getErrorHandler().renameFileFailedNoSourceFile(file);
        }
        this.ensureParentFolder(newPath);
        if ((SystemInfo.isWindows || SystemInfo.isMac) && file.getAbsolutePath().equalsIgnoreCase(newPath.getAbsolutePath())) {
            file = this.getTemporaryFile(file, isFile);
        }
        this.deleteFile(newPath, false, isFile);
        if (!file.renameTo(newPath)) {
            this.getErrorHandler().renameFileFailed(file, newPath);
        }
        this.deleteFile(file, false, isFile);
        if (deleteParentDirectoryIfEmpty) {
            this.getThis().deleteFile(file, true, isFile);
        }
    }

    @NotNull
    private File getTemporaryFile(File file, boolean isFile) throws IOException {
        String prefix = String.format("TeamCity-%s-", file.getName());
        File tempFile = File.createTempFile(prefix, "-tmp", file.getParentFile());
        this.deleteFile(tempFile, false, isFile);
        if (file.renameTo(tempFile)) {
            File file2 = tempFile;
            if (file2 == null) {
                FSPatcherCallbackImpl.$$$reportNull$$$0(5);
            }
            return file2;
        }
        this.getErrorHandler().renameFileFailed(file, tempFile);
        File file3 = file;
        if (file3 == null) {
            FSPatcherCallbackImpl.$$$reportNull$$$0(6);
        }
        return file3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void replaceBinary(@NotNull File file, long length, boolean newFile, @NotNull LowLevelPatcherListener.ReadFileContent readFileContent) throws IOException {
        if (file == null) {
            FSPatcherCallbackImpl.$$$reportNull$$$0(7);
        }
        if (readFileContent == null) {
            FSPatcherCallbackImpl.$$$reportNull$$$0(8);
        }
        this.ensureWriteOrDelete(file);
        this.ensureParentFolder(file);
        try {
            void content;
            BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));
            InputStream is = content.getInputStream();
            try {
                FileUtil.copyStreams((InputStream)is, (OutputStream)fos);
                ((OutputStream)fos).flush();
            }
            finally {
                ((OutputStream)fos).close();
                FSPatcherCallbackImpl.close(is);
            }
        }
        catch (IOException e) {
            this.getErrorHandler().changeBinaryFailed(file, e);
        }
    }

    private void ensureWriteOrDelete(File file) throws IOException {
        if (file.exists() && !file.canWrite()) {
            FileUtil.delete((File)file);
            if (file.exists()) {
                this.getErrorHandler().failedToAccessFile(file);
            }
        }
    }

    private void ensureParentFolder(File file) throws IOException {
        File parentFile = file.getParentFile();
        if (parentFile == null) {
            this.getErrorHandler().failedToCreateOrFindParentDirectory(file);
            return;
        }
        if (!parentFile.exists()) {
            this.getThis().addDirectory(parentFile);
        }
        if (!parentFile.exists()) {
            this.getErrorHandler().failedToCreateOrFindParentDirectory(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void replaceTextUsingBytes(@NotNull File file, long size, @NotNull byte[] sep, boolean newFile, @NotNull LowLevelPatcherListener.ReadFileContent readFileContent) throws IOException {
        if (file == null) {
            FSPatcherCallbackImpl.$$$reportNull$$$0(9);
        }
        if (sep == null) {
            FSPatcherCallbackImpl.$$$reportNull$$$0(10);
        }
        if (readFileContent == null) {
            FSPatcherCallbackImpl.$$$reportNull$$$0(11);
        }
        this.ensureWriteOrDelete(file);
        this.ensureParentFolder(file);
        byte[] usingSeparator = sep.length == 0 ? System.getProperty("line.separator").getBytes() : sep;
        try {
            void content;
            BufferedOutputStream fileOutput = new BufferedOutputStream(new FileOutputStream(file));
            InputStream in = content.getInputStream();
            TCLineReader reader = new TCLineReader(in, size, (OutputStream)fileOutput, usingSeparator);
            try {
                reader.writeUsingNewSeparator();
                ((OutputStream)fileOutput).flush();
            }
            finally {
                ((OutputStream)fileOutput).close();
                FSPatcherCallbackImpl.close(in);
            }
        }
        catch (IOException e) {
            this.getErrorHandler().changeTextFailed(file, e);
        }
    }

    private static void close(Closeable close) {
        try {
            close.close();
        }
        catch (IOException e) {
            LOG.warn("ReplaceTextUsingBytes stream close()", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFileMode(@NotNull File filePath, @NotNull String fileMode) throws IOException {
        if (filePath == null) {
            FSPatcherCallbackImpl.$$$reportNull$$$0(12);
        }
        if (fileMode == null) {
            FSPatcherCallbackImpl.$$$reportNull$$$0(13);
        }
        boolean isReadonly = FileUtil.isReadonly((File)filePath);
        try {
            this.clearReadonlyAttribute(filePath);
            if (!TCStreamUtil.setFileMode((File)filePath, (String)fileMode)) {
                this.getErrorHandler().chmodFailed(filePath);
            }
        }
        finally {
            this.setReadonlyAttribute(filePath, isReadonly);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimeStamp(@NotNull File filePath, long timeStamp) throws IOException {
        if (filePath == null) {
            FSPatcherCallbackImpl.$$$reportNull$$$0(14);
        }
        boolean isReadonly = FileUtil.isReadonly((File)filePath);
        try {
            this.clearReadonlyAttribute(filePath);
            if (!filePath.setLastModified(timeStamp)) {
                this.getErrorHandler().setLastModifiedFailed(filePath, timeStamp);
            }
        }
        finally {
            this.setReadonlyAttribute(filePath, isReadonly);
        }
    }

    @Override
    public void setReadonlyAttribute(@NotNull File filePath, boolean isReadonly) throws IOException {
        if (filePath == null) {
            FSPatcherCallbackImpl.$$$reportNull$$$0(15);
        }
        if (isReadonly && !filePath.setReadOnly()) {
            this.getErrorHandler().setReadonlyAttributeFailed(filePath);
        }
    }

    private void clearReadonlyAttribute(@NotNull File filePath) throws IOException {
        if (filePath == null) {
            FSPatcherCallbackImpl.$$$reportNull$$$0(16);
        }
        if (FileUtil.isReadonly((File)filePath)) {
            filePath.setWritable(true);
        }
    }

    public abstract PatcherErrorHandler getErrorHandler();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/vcs/patches/FSPatcherCallbackImpl";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPath";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sep";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getThis";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/vcs/patches/FSPatcherCallbackImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemporaryFile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addDirectory";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replaceBinary";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replaceTextUsingBytes";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setFileMode";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setTimeStamp";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setReadonlyAttribute";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "clearReadonlyAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

