/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs.patches;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import jetbrains.buildServer.vcs.patches.PatchStreamUtil;
import org.jetbrains.annotations.NotNull;

public class InputStreamPart
extends InputStream
implements Closeable {
    private final InputStream myStream;
    private long myReadSize;

    public InputStreamPart(@NotNull InputStream stream, long readSize) {
        if (stream == null) {
            InputStreamPart.$$$reportNull$$$0(0);
        }
        this.myStream = stream;
        this.myReadSize = readSize;
    }

    @Override
    public int read() throws IOException {
        if (this.myReadSize <= 0L) {
            return -1;
        }
        int read = this.myStream.read();
        if (read != -1) {
            --this.myReadSize;
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.myReadSize <= 0L) {
            return -1;
        }
        int sz = this.myStream.read(b, off, (int)Math.min((long)len, this.myReadSize));
        this.myReadSize -= (long)sz;
        return sz;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.myReadSize <= 0L || n <= 0L) {
            return 0L;
        }
        long skipped = this.myStream.skip(Math.min(this.myReadSize, n));
        this.myReadSize -= skipped;
        return skipped;
    }

    @Override
    public void close() throws IOException {
        if (this.myReadSize > 0L) {
            PatchStreamUtil.skip((InputStream)this.myStream, (long)this.myReadSize);
            this.myReadSize = 0L;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "jetbrains/buildServer/vcs/patches/InputStreamPart", "<init>"));
    }
}

