/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs.patches;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import jetbrains.buildServer.vcs.patches.LowLevelPatchBuilder;
import jetbrains.buildServer.vcs.patches.OutputStreamPart;
import jetbrains.buildServer.vcs.patches.PatcherConstants;
import org.jetbrains.annotations.NotNull;

public class LowLevelPatchBuilderImpl
implements LowLevelPatchBuilder {
    private final AtomicBoolean myIsClosed;
    private final DataOutputStream myOutputStream;

    public LowLevelPatchBuilderImpl(@NotNull OutputStream outputStream) {
        if (outputStream == null) {
            LowLevelPatchBuilderImpl.$$$reportNull$$$0(0);
        }
        this(new DataOutputStream(new BufferedOutputStream(outputStream)));
    }

    public LowLevelPatchBuilderImpl(@NotNull DataOutputStream outputStream) {
        if (outputStream == null) {
            LowLevelPatchBuilderImpl.$$$reportNull$$$0(1);
        }
        this.myIsClosed = new AtomicBoolean();
        this.myOutputStream = outputStream;
    }

    private void writePair(@NotNull PatcherConstants value, @NotNull String utf) throws IOException {
        if (value == null) {
            LowLevelPatchBuilderImpl.$$$reportNull$$$0(2);
        }
        if (utf == null) {
            LowLevelPatchBuilderImpl.$$$reportNull$$$0(3);
        }
        this.assertClosed();
        this.myOutputStream.writeByte(value.getValue());
        this.myOutputStream.writeUTF(utf);
    }

    @Override
    public void exit(@NotNull String message) throws IOException {
        if (message == null) {
            LowLevelPatchBuilderImpl.$$$reportNull$$$0(4);
        }
        this.writePair(PatcherConstants.EXIT, message);
    }

    @Override
    public void fail(@NotNull String message) throws IOException {
        if (message == null) {
            LowLevelPatchBuilderImpl.$$$reportNull$$$0(5);
        }
        if (!this.myIsClosed.get()) {
            this.myOutputStream.writeByte(PatcherConstants.FAIL.getValue());
            this.myOutputStream.writeUTF(message);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void changeBinary(@NotNull String file, long length, @NotNull LowLevelPatchBuilder.WriteFileContent writer, boolean bl) throws IOException {
        void create;
        if (file == null) {
            LowLevelPatchBuilderImpl.$$$reportNull$$$0(6);
        }
        if (writer == null) {
            LowLevelPatchBuilderImpl.$$$reportNull$$$0(7);
        }
        this.writePair(create != false ? PatcherConstants.CREATE_BINARY : PatcherConstants.REPLACE_BINARY, file);
        this.myOutputStream.writeLong(length);
        OutputStreamPart sls = new OutputStreamPart(this.myOutputStream, length);
        writer.write(sls);
        sls.close();
    }

    @Override
    public void setTimeStamp(@NotNull String file, long timestamp) throws IOException {
        if (file == null) {
            LowLevelPatchBuilderImpl.$$$reportNull$$$0(8);
        }
        this.writePair(PatcherConstants.SET_TIME_STAMP, file);
        this.myOutputStream.writeLong(timestamp);
    }

    @Override
    public void setFileMode(@NotNull String file, @NotNull String mode) throws IOException {
        if (file == null) {
            LowLevelPatchBuilderImpl.$$$reportNull$$$0(9);
        }
        if (mode == null) {
            LowLevelPatchBuilderImpl.$$$reportNull$$$0(10);
        }
        this.writePair(PatcherConstants.SET_FILE_MODE, file);
        this.myOutputStream.writeUTF(mode);
    }

    @Override
    public void addDirectory(@NotNull String file) throws IOException {
        if (file == null) {
            LowLevelPatchBuilderImpl.$$$reportNull$$$0(11);
        }
        this.writePair(PatcherConstants.ADD_DIRECTORY, file);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void changeTextUsingBytes(@NotNull String file, @NotNull byte[] lineSeparator, long length, @NotNull LowLevelPatchBuilder.WriteFileContent writer, boolean bl) throws IOException {
        void create;
        if (file == null) {
            LowLevelPatchBuilderImpl.$$$reportNull$$$0(12);
        }
        if (lineSeparator == null) {
            LowLevelPatchBuilderImpl.$$$reportNull$$$0(13);
        }
        if (writer == null) {
            LowLevelPatchBuilderImpl.$$$reportNull$$$0(14);
        }
        this.writePair(create != false ? PatcherConstants.CREATE_TEXT_USING_BYTES : PatcherConstants.REPLACE_TEXT_USING_BYTES, file);
        this.myOutputStream.writeInt(lineSeparator.length);
        for (byte b : lineSeparator) {
            this.myOutputStream.writeByte(b);
        }
        this.myOutputStream.writeLong(length);
        OutputStreamPart sls = new OutputStreamPart(this.myOutputStream, length);
        writer.write(sls);
        sls.close();
    }

    @Override
    public void delete(@NotNull String file, boolean isFile, boolean emptyParent) throws IOException {
        if (file == null) {
            LowLevelPatchBuilderImpl.$$$reportNull$$$0(15);
        }
        PatcherConstants action = isFile ? (emptyParent ? PatcherConstants.DELETE_WITH_EMPTY_PARENT : PatcherConstants.DELETE) : (emptyParent ? PatcherConstants.DELETE_DIR_WITH_EMPTY_PARENT : PatcherConstants.DELETE_DIR);
        this.writePair(action, file);
    }

    @Override
    public void rename(@NotNull String oldName, @NotNull String newName, boolean isFile, boolean emptyParent) throws IOException {
        if (oldName == null) {
            LowLevelPatchBuilderImpl.$$$reportNull$$$0(16);
        }
        if (newName == null) {
            LowLevelPatchBuilderImpl.$$$reportNull$$$0(17);
        }
        PatcherConstants action = isFile ? (emptyParent ? PatcherConstants.RENAME_WITH_EMPTY_PARENT : PatcherConstants.RENAME) : (emptyParent ? PatcherConstants.RENAME_DIR_WITH_EMPTY_PARENT : PatcherConstants.RENAME_DIR);
        this.writePair(action, oldName);
        this.myOutputStream.writeUTF(newName);
    }

    @Override
    public void close() throws IOException {
        if (!this.myIsClosed.compareAndSet(false, true)) {
            return;
        }
        this.myOutputStream.close();
    }

    @Override
    public void interrupt() throws IOException {
        this.fail("interrupted");
    }

    @Override
    public void flush() throws IOException {
        this.assertClosed();
        this.myOutputStream.flush();
    }

    @Override
    public void noOp() throws IOException {
        this.assertClosed();
        this.myOutputStream.writeByte(PatcherConstants.NO_OP.getValue());
    }

    private void assertClosed() throws IOException {
        if (this.myIsClosed.get()) {
            throw new IOException("Low-level patch stream is closed");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "utf";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineSeparator";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/vcs/patches/LowLevelPatchBuilderImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "writePair";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "exit";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "fail";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "changeBinary";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "setTimeStamp";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "setFileMode";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "addDirectory";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "changeTextUsingBytes";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "delete";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "rename";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

