/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs.patches;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import jetbrains.buildServer.vcs.patches.InputStreamPart;
import jetbrains.buildServer.vcs.patches.InterruptablePatcherBase;
import jetbrains.buildServer.vcs.patches.LowLevelPatcherListener;
import jetbrains.buildServer.vcs.patches.PatcherConstants;
import jetbrains.buildServer.vcs.patches.UnsuccessfulPatchException;
import org.jetbrains.annotations.NotNull;

public class LowLevelPatcher
extends InterruptablePatcherBase {
    private final DataInputStream myInputStream;
    private boolean myIsClosed;

    public LowLevelPatcher(@NotNull InputStream inputStream) {
        if (inputStream == null) {
            LowLevelPatcher.$$$reportNull$$$0(0);
        }
        this(new DataInputStream(new BufferedInputStream(inputStream)));
    }

    public LowLevelPatcher(@NotNull DataInputStream inputStream) {
        if (inputStream == null) {
            LowLevelPatcher.$$$reportNull$$$0(1);
        }
        this.myInputStream = inputStream;
    }

    @NotNull
    private PatcherConstants readAction() throws IOException {
        PatcherConstants action = PatcherConstants.fromByte(this.myInputStream.readByte());
        if (action == null) {
            throw new UnsuccessfulPatchException("Patch file is corrupted");
        }
        PatcherConstants patcherConstants = action;
        if (patcherConstants == null) {
            LowLevelPatcher.$$$reportNull$$$0(2);
        }
        return patcherConstants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void withContentRead(long length, @NotNull Action action) throws IOException {
        if (action == null) {
            LowLevelPatcher.$$$reportNull$$$0(3);
        }
        try (final InputStreamPart sis = new InputStreamPart(this.myInputStream, length);){
            void action2;
            action2.apply(length, new LowLevelPatcherListener.ReadFileContent(){

                @Override
                @NotNull
                public InputStream getInputStream() {
                    InputStreamPart inputStreamPart = sis;
                    if (inputStreamPart == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return inputStreamPart;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/patches/LowLevelPatcher$1", "getInputStream"));
                }
            });
        }
    }

    public void close() {
        if (!this.myIsClosed) {
            this.myIsClosed = true;
            try {
                this.myInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private long readFileLength(@NotNull PatcherConstants constant) throws IOException {
        if (constant == null) {
            LowLevelPatcher.$$$reportNull$$$0(4);
        }
        switch (constant) {
            case CREATE_BINARY_INT: 
            case REPLACE_BINARY_INT: 
            case CREATE_TEXT_USING_BYTES_INT: 
            case REPLACE_TEXT_USING_BYTES_INT: {
                return this.myInputStream.readInt();
            }
            case CREATE_BINARY: 
            case REPLACE_BINARY: 
            case CREATE_TEXT_USING_BYTES: 
            case REPLACE_TEXT_USING_BYTES: {
                return this.myInputStream.readLong();
            }
        }
        throw new IllegalStateException("Unsupported patched command to read content length: " + (Object)((Object)constant));
    }

    public void applyPatch(@NotNull LowLevelPatcherListener builder) throws IOException {
        if (builder == null) {
            LowLevelPatcher.$$$reportNull$$$0(5);
        }
        if (this.myIsClosed) {
            throw new IOException("Patch has already been applied.");
        }
        try {
            this.readPatchStream(builder);
        }
        finally {
            this.close();
        }
    }

    private void readPatchStream(final @NotNull LowLevelPatcherListener builder) throws IOException {
        PatcherConstants action;
        if (builder == null) {
            LowLevelPatcher.$$$reportNull$$$0(6);
        }
        block11: while (true) {
            this.checkInterrupted();
            action = this.readAction();
            if (action == PatcherConstants.NO_OP) continue;
            final String utf = this.myInputStream.readUTF();
            switch (action) {
                case ADD_DIRECTORY: {
                    builder.addDirectory(utf);
                    continue block11;
                }
                case CREATE_BINARY_INT: 
                case REPLACE_BINARY_INT: 
                case CREATE_BINARY: 
                case REPLACE_BINARY: {
                    final boolean create = action == PatcherConstants.CREATE_BINARY || action == PatcherConstants.CREATE_BINARY_INT;
                    this.withContentRead(this.readFileLength(action), new Action(){

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        public void apply(long length, @NotNull LowLevelPatcherListener.ReadFileContent readFileContent) throws IOException {
                            void readFileContent2;
                            if (readFileContent == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            builder.changeBinary(utf, length, readFileContent2, create);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readFileContent", "jetbrains/buildServer/vcs/patches/LowLevelPatcher$2", "apply"));
                        }
                    });
                    continue block11;
                }
                case CREATE_TEXT_USING_BYTES_INT: 
                case REPLACE_TEXT_USING_BYTES_INT: 
                case CREATE_TEXT_USING_BYTES: 
                case REPLACE_TEXT_USING_BYTES: {
                    int sps = this.myInputStream.readInt();
                    final byte[] arr = new byte[sps];
                    for (int i = 0; i < arr.length; ++i) {
                        arr[i] = this.myInputStream.readByte();
                    }
                    final boolean create = action == PatcherConstants.CREATE_TEXT_USING_BYTES || action == PatcherConstants.CREATE_TEXT_USING_BYTES_INT;
                    this.withContentRead(this.readFileLength(action), new Action(){

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        public void apply(long length, @NotNull LowLevelPatcherListener.ReadFileContent readFileContent) throws IOException {
                            void readFileContent2;
                            if (readFileContent == null) {
                                3.$$$reportNull$$$0(0);
                            }
                            builder.changeTextUsingBytes(utf, arr, length, readFileContent2, create);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readFileContent", "jetbrains/buildServer/vcs/patches/LowLevelPatcher$3", "apply"));
                        }
                    });
                    continue block11;
                }
                case DELETE: 
                case DELETE_DIR: 
                case DELETE_DIR_WITH_EMPTY_PARENT: 
                case DELETE_WITH_EMPTY_PARENT: {
                    boolean isFile = action == PatcherConstants.DELETE || action == PatcherConstants.DELETE_WITH_EMPTY_PARENT;
                    boolean emptyParent = action == PatcherConstants.DELETE_WITH_EMPTY_PARENT || action == PatcherConstants.DELETE_DIR_WITH_EMPTY_PARENT;
                    builder.delete(utf, isFile, emptyParent);
                    continue block11;
                }
                case RENAME: 
                case RENAME_DIR: 
                case RENAME_DIR_WITH_EMPTY_PARENT: 
                case RENAME_WITH_EMPTY_PARENT: {
                    boolean isFile = action == PatcherConstants.RENAME || action == PatcherConstants.RENAME_WITH_EMPTY_PARENT;
                    boolean emptyParent = action == PatcherConstants.RENAME_WITH_EMPTY_PARENT || action == PatcherConstants.RENAME_DIR_WITH_EMPTY_PARENT;
                    builder.rename(utf, this.myInputStream.readUTF(), isFile, emptyParent);
                    continue block11;
                }
                case EXIT: {
                    builder.exit(utf);
                    return;
                }
                case FAIL: {
                    builder.fail(utf);
                    return;
                }
                case SET_FILE_MODE: {
                    builder.setFileMode(utf, this.myInputStream.readUTF());
                    continue block11;
                }
                case SET_TIME_STAMP: {
                    builder.setTimeStamp(utf, this.myInputStream.readLong());
                    continue block11;
                }
            }
            break;
        }
        throw new IOException("Unexpected patcher constant:" + (Object)((Object)action));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/vcs/patches/LowLevelPatcher";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/vcs/patches/LowLevelPatcher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "readAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withContentRead";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readFileLength";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyPatch";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readPatchStream";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface Action {
        public void apply(long var1, @NotNull LowLevelPatcherListener.ReadFileContent var3) throws IOException;
    }
}

