/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs.patches;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public class OutputStreamPart
extends OutputStream
implements Closeable {
    private final OutputStream myStream;
    private long myToWrite;

    public OutputStreamPart(@NotNull OutputStream stream, long toWrite) {
        if (stream == null) {
            OutputStreamPart.$$$reportNull$$$0(0);
        }
        this.myStream = stream;
        this.myToWrite = toWrite;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.myToWrite-- <= 0L) {
            throw new IOException("Attempt to write more bytes than allowed");
        }
        this.myStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if ((long)len > this.myToWrite) {
            throw new IOException("Attempt to write more bytes than allowed");
        }
        this.myToWrite -= (long)len;
        this.myStream.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this.myToWrite > 0L) {
            throw new IOException("It was expected to write more " + this.myToWrite + " bytes");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "jetbrains/buildServer/vcs/patches/OutputStreamPart", "<init>"));
    }
}

