/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs.patches;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public enum PatcherConstants {
    EXIT(10),
    FAIL(24),
    DELETE(3),
    DELETE_DIR_WITH_EMPTY_PARENT(22),
    DELETE_WITH_EMPTY_PARENT(15),
    DELETE_DIR(23),
    RENAME_WITH_EMPTY_PARENT(18),
    RENAME(19),
    RENAME_DIR_WITH_EMPTY_PARENT(20),
    RENAME_DIR(21),
    REPLACE_BINARY(25),
    CREATE_BINARY(26),
    REPLACE_TEXT_USING_BYTES(27),
    CREATE_TEXT_USING_BYTES(28),
    SET_TIME_STAMP(12),
    SET_FILE_MODE(13),
    ADD_DIRECTORY(14),
    NO_OP(0),
    REPLACE_BINARY_INT(1),
    REPLACE_TEXT_USING_BYTES_INT(11),
    CREATE_BINARY_INT(16),
    CREATE_TEXT_USING_BYTES_INT(17);

    private final byte myValue;
    private static final Map<Byte, PatcherConstants> ourCache;

    private PatcherConstants(int value) {
        this.myValue = (byte)value;
    }

    public byte getValue() {
        return this.myValue;
    }

    @Nullable
    public static PatcherConstants fromByte(byte b) {
        return ourCache.get(b);
    }

    static {
        ourCache = new HashMap<Byte, PatcherConstants>();
        for (PatcherConstants val : PatcherConstants.values()) {
            ourCache.put(val.getValue(), val);
        }
    }
}

