/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs.patches;

import java.io.File;
import java.io.IOException;
import jetbrains.buildServer.vcs.patches.PatchException;
import jetbrains.buildServer.vcs.patches.PatcherErrorHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PatcherErrorHandlerBase
implements PatcherErrorHandler {
    @NotNull
    private String getPath(@NotNull File f) {
        if (f == null) {
            PatcherErrorHandlerBase.$$$reportNull$$$0(0);
        }
        String string = f.getAbsolutePath();
        if (string == null) {
            PatcherErrorHandlerBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public void addDirectoryFailed(@NotNull File file) throws PatchException {
        if (file == null) {
            PatcherErrorHandlerBase.$$$reportNull$$$0(2);
        }
        this.error("Failed to create directory: " + this.getPath(file));
    }

    @Override
    public void deleteFailed(@NotNull File file) throws PatchException {
        if (file == null) {
            PatcherErrorHandlerBase.$$$reportNull$$$0(3);
        }
        this.error("Failed to delete: " + this.getPath(file));
    }

    @Override
    public void renameFileFailed(@NotNull File fromFile, @NotNull File toFile) throws PatchException {
        if (fromFile == null) {
            PatcherErrorHandlerBase.$$$reportNull$$$0(4);
        }
        if (toFile == null) {
            PatcherErrorHandlerBase.$$$reportNull$$$0(5);
        }
        this.error("Failed to rename " + this.getPath(fromFile) + " to " + this.getPath(toFile));
    }

    @Override
    public void renameFileFailedNoSourceFile(@NotNull File file) throws PatchException {
        if (file == null) {
            PatcherErrorHandlerBase.$$$reportNull$$$0(6);
        }
        this.error("Nothing to rename: " + this.getPath(file));
    }

    @Override
    public void chmodFailed(@NotNull File file) throws PatchException {
        if (file == null) {
            PatcherErrorHandlerBase.$$$reportNull$$$0(7);
        }
        this.error("Failed to chmod: " + this.getPath(file));
    }

    @Override
    public void setLastModifiedFailed(@NotNull File file, long timeStamp) throws PatchException {
        if (file == null) {
            PatcherErrorHandlerBase.$$$reportNull$$$0(8);
        }
        this.error("Failed to set last modified: " + this.getPath(file));
    }

    @Override
    public void setReadonlyAttributeFailed(@NotNull File file) throws PatchException {
        if (file == null) {
            PatcherErrorHandlerBase.$$$reportNull$$$0(9);
        }
        this.error("Failed to set file attributes: " + this.getPath(file));
    }

    @Override
    public void changeBinaryFailed(@NotNull File file, @NotNull IOException e) throws PatchException {
        if (file == null) {
            PatcherErrorHandlerBase.$$$reportNull$$$0(10);
        }
        if (e == null) {
            PatcherErrorHandlerBase.$$$reportNull$$$0(11);
        }
        this.error("Failed to change binary file: " + this.getPath(file) + ". " + e.getMessage(), e);
    }

    @Override
    public void changeTextFailed(@NotNull File file, @NotNull IOException e) throws PatchException {
        if (file == null) {
            PatcherErrorHandlerBase.$$$reportNull$$$0(12);
        }
        if (e == null) {
            PatcherErrorHandlerBase.$$$reportNull$$$0(13);
        }
        this.error("Failed to change text file: " + this.getPath(file) + ". " + e.getMessage(), e);
    }

    @Override
    public void failedToAccessFile(@NotNull File file) throws PatchException {
        if (file == null) {
            PatcherErrorHandlerBase.$$$reportNull$$$0(14);
        }
        this.error("Access denied: " + this.getPath(file));
    }

    @Override
    public void failedToCreateOrFindParentDirectory(@NotNull File file) throws PatchException {
        if (file == null) {
            PatcherErrorHandlerBase.$$$reportNull$$$0(15);
        }
        this.error("Failed to create directory: " + this.getPath(file));
    }

    private void error(@NotNull String message) throws PatchException {
        if (message == null) {
            PatcherErrorHandlerBase.$$$reportNull$$$0(16);
        }
        this.error(message, null);
    }

    protected abstract void error(@NotNull String var1, @Nullable IOException var2) throws PatchException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/vcs/patches/PatcherErrorHandlerBase";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFile";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/vcs/patches/PatcherErrorHandlerBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addDirectoryFailed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deleteFailed";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "renameFileFailed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renameFileFailedNoSourceFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "chmodFailed";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setLastModifiedFailed";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setReadonlyAttributeFailed";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "changeBinaryFailed";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "changeTextFailed";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "failedToAccessFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "failedToCreateOrFindParentDirectory";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

