/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs.patches.diff;

import java.util.Arrays;

public class Base85x {
    private static final int ASCII_LEFT_SHIFT = 33;
    private static final int ASCII_RIGHT_SHIFT = 127;
    private static final char[] ALPHABET_85 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '!', '#', '$', '%', '&', '(', ')', '*', '+', '-', ';', '<', '=', '>', '?', '@', '^', '_', '`', '{', '|', '}', '~'};
    private static final int[] INDEX_OF = Base85x.initIndexOfChar();

    private static int[] initIndexOfChar() {
        int[] result = new int[256];
        Arrays.fill(result, -1);
        for (int i = 0; i < ALPHABET_85.length; ++i) {
            result[Base85x.ALPHABET_85[i]] = i;
        }
        return result;
    }

    public static char encodeChar(int i) throws Base85FormatException {
        if (i < 0 || i >= ALPHABET_85.length) {
            throw new Base85FormatException("Wrong index to encode as char " + i);
        }
        return ALPHABET_85[i];
    }

    public static int decodeChar(char c) throws Base85FormatException {
        if (c < '!' || c > '\u007f') {
            throw new Base85FormatException("Illegal char " + c);
        }
        int result = INDEX_OF[c];
        if (result == -1) {
            throw new Base85FormatException("Illegal char " + c);
        }
        return result;
    }

    public static byte[] decode(String data) throws Base85FormatException {
        return Base85x.decode(data.toCharArray());
    }

    public static char[] encode(byte[] data, int length) throws Base85FormatException {
        char[] out = new char[length / 4 * 5 + (length % 4 != 0 ? length % 4 + 1 : 0)];
        int k = 0;
        int i = 0;
        while (i + 4 <= length) {
            long b = 0L;
            b |= (long)(data[i] & 0xFF);
            b <<= 8;
            b |= (long)(data[i + 1] & 0xFF);
            b <<= 8;
            b |= (long)(data[i + 2] & 0xFF);
            b <<= 8;
            int c5 = (int)((b |= (long)(data[i + 3] & 0xFF)) % 85L);
            int c4 = (int)((b /= 85L) % 85L);
            int c3 = (int)((b /= 85L) % 85L);
            int c2 = (int)((b /= 85L) % 85L);
            int c1 = (int)((b /= 85L) % 85L);
            out[k] = Base85x.encodeChar(c1);
            out[++k] = Base85x.encodeChar(c2);
            out[++k] = Base85x.encodeChar(c3);
            out[++k] = Base85x.encodeChar(c4);
            out[++k] = Base85x.encodeChar(c5);
            ++k;
            i += 4;
        }
        int rest = length % 4;
        if (rest != 0) {
            int j;
            byte[] block = new byte[]{126, 126, 126, 126};
            for (j = 0; j < rest; ++j) {
                block[j] = data[i + j];
            }
            char[] out_rest = Base85x.encode(block, block.length);
            for (j = 0; j < rest + 1; ++j) {
                out[k] = out_rest[j];
                ++k;
            }
        }
        return out;
    }

    public static byte[] decode(char[] data) throws Base85FormatException {
        int length = data.length;
        byte[] out = new byte[length / 5 * 4 + (length % 5 != 0 ? length % 5 - 1 : 0)];
        int k = 0;
        int i = 0;
        while (i + 5 <= length) {
            int b1 = Base85x.decodeChar(data[i]);
            int b2 = Base85x.decodeChar(data[i + 1]);
            int b3 = Base85x.decodeChar(data[i + 2]);
            int b4 = Base85x.decodeChar(data[i + 3]);
            int b5 = Base85x.decodeChar(data[i + 4]);
            int b = b1 * 52200625 + b2 * 614125 + b3 * 7225 + b4 * 85 + b5;
            out[k] = (byte)(b >>> 24 & 0xFF);
            out[++k] = (byte)(b >>> 16 & 0xFF);
            out[++k] = (byte)(b >>> 8 & 0xFF);
            out[++k] = (byte)(b & 0xFF);
            ++k;
            i += 5;
        }
        int rest = length % 5;
        if (rest != 0) {
            int j;
            char[] block = new char[]{'~', '~', '~', '~', '~'};
            for (j = 0; j < rest; ++j) {
                block[j] = data[i + j];
            }
            byte[] out_rest = Base85x.decode(block);
            for (j = 0; j < rest - 1; ++j) {
                out[k] = out_rest[j];
                ++k;
            }
        }
        return out;
    }

    public static class Base85FormatException
    extends Exception {
        Base85FormatException(String s) {
            super(s);
        }
    }
}

