/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs.patches.diff;

import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public abstract class FilePatch {
    private static final Pattern REVISION_PATTERN = Pattern.compile("\\(\\s*revision\\s*([a-f0-9]{40})\\)");
    private String myBeforeName;
    private String myAfterName;
    private String myBeforeVersionId;
    private String myAfterVersionId;
    private String myBaseRevisionText;
    private int myNewFileMode = -1;
    private boolean myIsGit;

    public String getBeforeName() {
        return this.myBeforeName;
    }

    public String getAfterName() {
        return this.myAfterName;
    }

    public String getBeforeFileName() {
        String[] pathNameComponents = this.myBeforeName.split("/");
        return pathNameComponents[pathNameComponents.length - 1];
    }

    public String getAfterFileName() {
        String[] pathNameComponents = this.myAfterName.split("/");
        return pathNameComponents[pathNameComponents.length - 1];
    }

    public void setBeforeName(String fileName) {
        this.myBeforeName = fileName;
    }

    public void setAfterName(String fileName) {
        this.myAfterName = fileName;
    }

    public String getBeforeVersionId() {
        return this.myBeforeVersionId;
    }

    public void setBeforeVersionId(String beforeVersionId) {
        this.myBeforeVersionId = beforeVersionId;
    }

    public String getAfterVersionId() {
        return this.myAfterVersionId;
    }

    public String getBeforeRevision() {
        return this.parseRevision(this.myBeforeVersionId);
    }

    public String getAfterRevision() {
        return this.parseRevision(this.myAfterVersionId);
    }

    @Nullable
    private String parseRevision(@Nullable String str) {
        if (str == null) {
            return null;
        }
        Matcher matcher = REVISION_PATTERN.matcher(str);
        return matcher.find() ? matcher.group(1) : null;
    }

    public void setAfterVersionId(String afterVersionId) {
        this.myAfterVersionId = afterVersionId;
    }

    public String getAfterNameRelative(int skipDirs) {
        String[] components = this.myAfterName.split("/");
        return StringUtil.join((String[])components, (int)skipDirs, (int)components.length, (String)"/");
    }

    public String getBaseRevisionText() {
        return this.myBaseRevisionText;
    }

    public void setBaseRevisionText(String baseRevisionText) {
        this.myBaseRevisionText = baseRevisionText;
    }

    public abstract boolean isNewFile();

    public abstract boolean isDeletedFile();

    public int getNewFileMode() {
        return this.myNewFileMode;
    }

    public void setNewFileMode(int newFileMode) {
        this.myNewFileMode = newFileMode;
    }

    public boolean isGit() {
        return this.myIsGit;
    }

    public void setGit(boolean git) {
        this.myIsGit = git;
    }
}

