/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs.patches.diff.apply;

import com.intellij.util.BeforeAfter;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import jetbrains.buildServer.vcs.patches.diff.apply.GenericPatchApplier;
import jetbrains.buildServer.vcs.patches.diff.apply.LineRange;
import org.jetbrains.annotations.NotNull;

public class AppliedTextPatch {
    @NotNull
    private final List<AppliedSplitPatchHunk> mySplitPatchHunkList;

    public static AppliedTextPatch create(@NotNull List<AppliedSplitPatchHunk> splitPatchHunkList) {
        if (splitPatchHunkList == null) {
            AppliedTextPatch.$$$reportNull$$$0(0);
        }
        ArrayList<AppliedSplitPatchHunk> hunks = new ArrayList<AppliedSplitPatchHunk>(splitPatchHunkList);
        BitSet appliedLines = new BitSet();
        for (int i = 0; i < hunks.size(); ++i) {
            AppliedSplitPatchHunk hunk = (AppliedSplitPatchHunk)hunks.get(i);
            LineRange appliedTo = hunk.getAppliedTo();
            if (appliedTo == null) continue;
            int nextAppliedLine = appliedLines.nextSetBit(appliedTo.start);
            if (nextAppliedLine != -1 && nextAppliedLine < appliedTo.end) {
                hunks.set(i, new AppliedSplitPatchHunk(hunk, -1, -1, HunkStatus.NOT_APPLIED));
                continue;
            }
            appliedLines.set(appliedTo.start, appliedTo.end, true);
        }
        ContainerUtil.sort(hunks, (Comparator)new Comparator<AppliedSplitPatchHunk>(){

            @Override
            public int compare(AppliedSplitPatchHunk o1, AppliedSplitPatchHunk o2) {
                int x = o1.getLineRangeBefore().start;
                int y = o2.getLineRangeBefore().start;
                return x < y ? -1 : (x == y ? 0 : 1);
            }
        });
        return new AppliedTextPatch(hunks);
    }

    private AppliedTextPatch(@NotNull List<AppliedSplitPatchHunk> hunks) {
        if (hunks == null) {
            AppliedTextPatch.$$$reportNull$$$0(1);
        }
        this.mySplitPatchHunkList = hunks;
    }

    @NotNull
    public List<AppliedSplitPatchHunk> getHunks() {
        List<AppliedSplitPatchHunk> list = this.mySplitPatchHunkList;
        if (list == null) {
            AppliedTextPatch.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitPatchHunkList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hunks";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/vcs/patches/diff/apply/AppliedTextPatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/vcs/patches/diff/apply/AppliedTextPatch";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHunks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class AppliedSplitPatchHunk {
        @NotNull
        private final HunkStatus myStatus;
        @NotNull
        private final List<String> myContextBefore;
        @NotNull
        private final List<String> myContextAfter;
        @NotNull
        private final List<String> myDeletedLines;
        @NotNull
        private final List<String> myInsertedLines;
        private final int myAppliedToLinesStart;
        private final int myAppliedToLinesEnd;
        private final int myStartLineBefore;
        private final int myStartLineAfter;

        public AppliedSplitPatchHunk(@NotNull GenericPatchApplier.SplitHunk splitHunk, int startLineApplied, int endLineApplied, @NotNull HunkStatus status) {
            if (splitHunk == null) {
                AppliedSplitPatchHunk.$$$reportNull$$$0(0);
            }
            if (status == null) {
                AppliedSplitPatchHunk.$$$reportNull$$$0(1);
            }
            this.myStatus = status;
            this.myAppliedToLinesStart = startLineApplied;
            this.myAppliedToLinesEnd = endLineApplied;
            this.myStartLineBefore = splitHunk.getStartLineBefore();
            this.myStartLineAfter = splitHunk.getStartLineAfter();
            this.myContextBefore = splitHunk.getContextBefore();
            this.myContextAfter = splitHunk.getContextAfter();
            this.myDeletedLines = new ArrayList<String>();
            this.myInsertedLines = new ArrayList<String>();
            for (BeforeAfter<List<String>> step : splitHunk.getPatchSteps()) {
                this.myDeletedLines.addAll((Collection)step.getBefore());
                this.myInsertedLines.addAll((Collection)step.getAfter());
            }
        }

        private AppliedSplitPatchHunk(@NotNull AppliedSplitPatchHunk hunk, int appliedToLinesStart, int appliedToLinesEnd, @NotNull HunkStatus status) {
            if (hunk == null) {
                AppliedSplitPatchHunk.$$$reportNull$$$0(2);
            }
            if (status == null) {
                AppliedSplitPatchHunk.$$$reportNull$$$0(3);
            }
            this.myStatus = status;
            this.myAppliedToLinesStart = appliedToLinesStart;
            this.myAppliedToLinesEnd = appliedToLinesEnd;
            this.myContextBefore = hunk.myContextBefore;
            this.myContextAfter = hunk.myContextAfter;
            this.myDeletedLines = hunk.myDeletedLines;
            this.myInsertedLines = hunk.myInsertedLines;
            this.myStartLineBefore = hunk.myStartLineBefore;
            this.myStartLineAfter = hunk.myStartLineAfter;
        }

        public LineRange getAppliedTo() {
            if (this.myStatus == HunkStatus.NOT_APPLIED) {
                return null;
            }
            return new LineRange(this.myAppliedToLinesStart, this.myAppliedToLinesEnd);
        }

        @NotNull
        public LineRange getLineRangeBefore() {
            int start = this.myStartLineBefore;
            LineRange lineRange = new LineRange(start, start + this.myContextBefore.size() + this.myDeletedLines.size() + this.myContextAfter.size());
            if (lineRange == null) {
                AppliedSplitPatchHunk.$$$reportNull$$$0(4);
            }
            return lineRange;
        }

        @NotNull
        public LineRange getLineRangeAfter() {
            int start = this.myStartLineAfter;
            LineRange lineRange = new LineRange(start, start + this.myContextBefore.size() + this.myInsertedLines.size() + this.myContextAfter.size());
            if (lineRange == null) {
                AppliedSplitPatchHunk.$$$reportNull$$$0(5);
            }
            return lineRange;
        }

        @NotNull
        public HunkStatus getStatus() {
            HunkStatus hunkStatus = this.myStatus;
            if (hunkStatus == null) {
                AppliedSplitPatchHunk.$$$reportNull$$$0(6);
            }
            return hunkStatus;
        }

        @NotNull
        public List<String> getContextBefore() {
            List<String> list = this.myContextBefore;
            if (list == null) {
                AppliedSplitPatchHunk.$$$reportNull$$$0(7);
            }
            return list;
        }

        @NotNull
        public List<String> getContextAfter() {
            List<String> list = this.myContextAfter;
            if (list == null) {
                AppliedSplitPatchHunk.$$$reportNull$$$0(8);
            }
            return list;
        }

        @NotNull
        public List<String> getDeletedLines() {
            List<String> list = this.myDeletedLines;
            if (list == null) {
                AppliedSplitPatchHunk.$$$reportNull$$$0(9);
            }
            return list;
        }

        @NotNull
        public List<String> getInsertedLines() {
            List<String> list = this.myInsertedLines;
            if (list == null) {
                AppliedSplitPatchHunk.$$$reportNull$$$0(10);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "splitHunk";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hunk";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/vcs/patches/diff/apply/AppliedTextPatch$AppliedSplitPatchHunk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/vcs/patches/diff/apply/AppliedTextPatch$AppliedSplitPatchHunk";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLineRangeBefore";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLineRangeAfter";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatus";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContextBefore";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContextAfter";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDeletedLines";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInsertedLines";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum HunkStatus {
        ALREADY_APPLIED,
        EXACTLY_APPLIED,
        NOT_APPLIED;

    }
}

