/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs.patches.diff.apply;

import gnu.trove.TIntArrayList;
import java.util.Arrays;
import jetbrains.buildServer.vcs.patches.diff.apply.LineOffsets;
import org.jetbrains.annotations.NotNull;

public class LineOffsetsUtil {
    @NotNull
    public static LineOffsets create(@NotNull CharSequence text) {
        int lineEnd;
        if (text == null) {
            LineOffsetsUtil.$$$reportNull$$$0(0);
        }
        TIntArrayList ends = new TIntArrayList();
        int index = 0;
        while ((lineEnd = LineOffsetsUtil.indexOf(text, '\n', index)) != -1) {
            ends.add(lineEnd);
            index = lineEnd + 1;
        }
        ends.add(text.length());
        LineOffsetsImpl lineOffsetsImpl = new LineOffsetsImpl(ends.toNativeArray(), text.length());
        if (lineOffsetsImpl == null) {
            LineOffsetsUtil.$$$reportNull$$$0(1);
        }
        return lineOffsetsImpl;
    }

    private static int indexOf(@NotNull CharSequence s, char c, int start) {
        if (s == null) {
            LineOffsetsUtil.$$$reportNull$$$0(2);
        }
        return LineOffsetsUtil.indexOf(s, c, start, s.length());
    }

    private static int indexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            LineOffsetsUtil.$$$reportNull$$$0(3);
        }
        end = Math.min(end, s.length());
        for (int i = Math.max(start, 0); i < end; ++i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/vcs/patches/diff/apply/LineOffsetsUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/vcs/patches/diff/apply/LineOffsetsUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LineOffsetsImpl
    implements LineOffsets {
        private final int[] myLineEnds;
        private final int myTextLength;

        private LineOffsetsImpl(int[] lineEnds, int textLength) {
            this.myLineEnds = lineEnds;
            this.myTextLength = textLength;
        }

        @Override
        public int getLineStart(int line) {
            this.checkLineIndex(line);
            if (line == 0) {
                return 0;
            }
            return this.myLineEnds[line - 1] + 1;
        }

        @Override
        public int getLineEnd(int line) {
            this.checkLineIndex(line);
            return this.myLineEnds[line];
        }

        @Override
        public int getLineEnd(int line, boolean includeNewline) {
            this.checkLineIndex(line);
            return this.myLineEnds[line] + (includeNewline && line != this.myLineEnds.length - 1 ? 1 : 0);
        }

        @Override
        public int getLineNumber(int offset) {
            if (offset < 0 || offset > this.getTextLength()) {
                throw new IndexOutOfBoundsException("Wrong offset: " + offset + ". Available text length: " + this.getTextLength());
            }
            if (offset == 0) {
                return 0;
            }
            if (offset == this.getTextLength()) {
                return this.getLineCount() - 1;
            }
            int bsResult = Arrays.binarySearch(this.myLineEnds, offset);
            return bsResult >= 0 ? bsResult : -bsResult - 1;
        }

        @Override
        public int getLineCount() {
            return this.myLineEnds.length;
        }

        @Override
        public int getTextLength() {
            return this.myTextLength;
        }

        private void checkLineIndex(int index) {
            if (index < 0 || index >= this.getLineCount()) {
                throw new IndexOutOfBoundsException("Wrong line: " + index + ". Available lines count: " + this.getLineCount());
            }
        }
    }
}

