/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs.patches.diff.apply;

import com.intellij.openapi.diagnostic.Logger;

public class LineRange {
    private static final Logger LOG = Logger.getInstance((String)LineRange.class.getName());
    public final int start;
    public final int end;

    public LineRange(int start, int end) {
        this.start = start;
        this.end = end;
        if (start > end) {
            LOG.error("LineRange is invalid: " + this.toString());
        }
    }

    public boolean contains(int start, int end) {
        return this.start <= start && this.end >= end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineRange range = (LineRange)o;
        if (this.start != range.start) {
            return false;
        }
        return this.end == range.end;
    }

    public int hashCode() {
        int result = this.start;
        result = 31 * result + this.end;
        return result;
    }

    public String toString() {
        return "[" + this.start + ", " + this.end + ")";
    }

    public boolean isEmpty() {
        return this.start == this.end;
    }
}

