/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs.patches.helpers;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.TCStreamUtil;
import jetbrains.buildServer.vcs.patches.LowLevelPatchAdapter;
import jetbrains.buildServer.vcs.patches.LowLevelPatcher;
import jetbrains.buildServer.vcs.patches.LowLevelPatcherListener;
import org.jetbrains.annotations.NotNull;

public class ExtractFilesFromPatch {
    public static void main(String[] args) {
        System.out.println("TeamCity extract files from patch utility ");
        System.out.println();
        System.out.println("Usage: program <path to patch file> <directory to extract patch>");
        if (args.length != 2) {
            System.exit(-1);
            return;
        }
        File patch = new File(args[0]);
        if (!patch.exists() || !patch.isFile()) {
            System.out.println("Failed to read file " + args[0]);
            System.exit(-2);
            return;
        }
        File dest = new File(args[1]);
        try {
            ExtractFilesFromPatch.extractFiles(patch, dest);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractFiles(@NotNull File patch, @NotNull File destFolder) throws IOException {
        if (patch == null) {
            ExtractFilesFromPatch.$$$reportNull$$$0(0);
        }
        if (destFolder == null) {
            ExtractFilesFromPatch.$$$reportNull$$$0(1);
        }
        if (destFolder.exists()) {
            FileUtil.delete((File)destFolder);
        }
        destFolder.mkdirs();
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(patch));
        LowLevelPatcher patcher = new LowLevelPatcher(dataInputStream);
        try {
            patcher.applyPatch(new MyLowLevelPatchAdapter(destFolder));
        }
        finally {
            ExtractFilesFromPatch.close(dataInputStream);
        }
    }

    private static void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "patch";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "destFolder";
                break;
            }
        }
        objectArray[1] = "jetbrains/buildServer/vcs/patches/helpers/ExtractFilesFromPatch";
        objectArray[2] = "extractFiles";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyLowLevelPatchAdapter
    extends LowLevelPatchAdapter {
        private final File myRoot;
        private File myDest;

        private MyLowLevelPatchAdapter(File root) {
            this.myDest = this.myRoot = root;
        }

        @Override
        public void rename(@NotNull String oldName, @NotNull String newName, boolean isFile, boolean emptyParent) throws IOException {
            if (oldName == null) {
                MyLowLevelPatchAdapter.$$$reportNull$$$0(0);
            }
            if (newName == null) {
                MyLowLevelPatchAdapter.$$$reportNull$$$0(1);
            }
            super.rename(oldName, newName, isFile, emptyParent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void changeBinary(@NotNull String file, long length, @NotNull LowLevelPatcherListener.ReadFileContent content, boolean bl) throws IOException {
            if (file == null) {
                MyLowLevelPatchAdapter.$$$reportNull$$$0(2);
            }
            if (content == null) {
                MyLowLevelPatchAdapter.$$$reportNull$$$0(3);
            }
            File f = this.file(file);
            FileOutputStream fos = new FileOutputStream(f);
            try {
                TCStreamUtil.writeBinary((InputStream)content.getInputStream(), (long)length, (OutputStream)fos);
            }
            finally {
                ExtractFilesFromPatch.close(fos);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void changeTextUsingBytes(@NotNull String file, @NotNull byte[] lineSeparator, long length, @NotNull LowLevelPatcherListener.ReadFileContent content, boolean bl) throws IOException {
            void create;
            if (file == null) {
                MyLowLevelPatchAdapter.$$$reportNull$$$0(4);
            }
            if (lineSeparator == null) {
                MyLowLevelPatchAdapter.$$$reportNull$$$0(5);
            }
            if (content == null) {
                MyLowLevelPatchAdapter.$$$reportNull$$$0(6);
            }
            this.changeBinary(file, length, content, (boolean)create);
        }

        private File file(String file) {
            File ff = new File(file);
            if (ff.isAbsolute()) {
                for (File root : File.listRoots()) {
                    String rootPath = root.getPath();
                    if (!file.startsWith(rootPath)) continue;
                    return this.file(file.substring(rootPath.length()));
                }
            }
            File absoluteFile = new File(this.myDest, file).getAbsoluteFile();
            absoluteFile.getParentFile().mkdirs();
            return absoluteFile;
        }

        @Override
        public void setWorkingDirectory(@NotNull String file) throws IOException {
            if (file == null) {
                MyLowLevelPatchAdapter.$$$reportNull$$$0(7);
            }
            super.setWorkingDirectory(file);
            this.myDest = new File(this.myRoot, file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lineSeparator";
                    break;
                }
            }
            objectArray2[1] = "jetbrains/buildServer/vcs/patches/helpers/ExtractFilesFromPatch$MyLowLevelPatchAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "rename";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "changeBinary";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "changeTextUsingBytes";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setWorkingDirectory";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

