/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs.patches.store;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.concurrent.atomic.AtomicBoolean;
import jetbrains.buildServer.vcs.patches.InputStreamPart;
import jetbrains.buildServer.vcs.patches.store.FileKey;
import jetbrains.buildServer.vcs.patches.store.FileStorageReader;
import jetbrains.buildServer.vcs.patches.store.RandomAccessFileKey;
import org.jetbrains.annotations.NotNull;

public class RandomAccessFileStoreReader
implements FileStorageReader,
Closeable {
    private final RandomAccessFile myFile;
    private final AtomicBoolean myHasReader;

    public RandomAccessFileStoreReader(@NotNull File file) throws IOException {
        if (file == null) {
            RandomAccessFileStoreReader.$$$reportNull$$$0(0);
        }
        this.myHasReader = new AtomicBoolean(false);
        this.myFile = new RandomAccessFile(file, "r"){};
    }

    @Override
    @NotNull
    public InputStream readFile(@NotNull FileKey id) throws IOException {
        if (id == null) {
            RandomAccessFileStoreReader.$$$reportNull$$$0(1);
        }
        if (!this.myHasReader.compareAndSet(false, true)) {
            throw new IllegalStateException("There is non-closed InputStream for another file. Only one stream can be used in a time");
        }
        RandomAccessFileKey key = (RandomAccessFileKey)id;
        this.myFile.seek(key.getOffset());
        InputStreamPart inputStreamPart = new InputStreamPart(new InputStream(){
            private final byte[] myBuff = new byte[8192];
            private int myOffset = 0;
            private int mySize = 0;

            @Override
            public int read() throws IOException {
                if (this.myOffset >= this.mySize) {
                    this.mySize = RandomAccessFileStoreReader.this.myFile.read(this.myBuff);
                    this.myOffset = 0;
                    if (this.mySize <= 0) {
                        return -1;
                    }
                }
                return this.myBuff[this.myOffset++];
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                if (this.myOffset >= this.mySize) {
                    return RandomAccessFileStoreReader.this.myFile.read(b, off, len);
                }
                int sz = Math.min(this.mySize - this.myOffset, len);
                System.arraycopy(this.myBuff, this.myOffset, b, off, sz);
                this.myOffset += sz;
                return sz;
            }
        }, key.getSize()){

            @Override
            public void close() {
                RandomAccessFileStoreReader.this.myHasReader.set(false);
            }
        };
        if (inputStreamPart == null) {
            RandomAccessFileStoreReader.$$$reportNull$$$0(2);
        }
        return inputStreamPart;
    }

    @Override
    public void close() throws IOException {
        this.myFile.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/vcs/patches/store/RandomAccessFileStoreReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/vcs/patches/store/RandomAccessFileStoreReader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "readFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readFile";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

