/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs.patches.store;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jetbrains.buildServer.vcs.patches.store.FileKey;
import jetbrains.buildServer.vcs.patches.store.FileStorageReader;
import jetbrains.buildServer.vcs.patches.store.FileStorageWriter;
import jetbrains.buildServer.vcs.patches.store.RandomAccessFileKey;
import jetbrains.buildServer.vcs.patches.store.RandomAccessFileStoreReader;
import org.jetbrains.annotations.NotNull;

public class RandomAccessFileStoreWriter
implements FileStorageWriter,
Closeable {
    private final OutputStream myOutputStream;
    private long myOffset;
    private final File myFile;
    private boolean myIsWriteClosed;

    public RandomAccessFileStoreWriter(@NotNull File file) throws IOException {
        if (file == null) {
            RandomAccessFileStoreWriter.$$$reportNull$$$0(0);
        }
        this.myOffset = 0L;
        this.myIsWriteClosed = false;
        this.myFile = file;
        this.myOutputStream = new BufferedOutputStream(new FileOutputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FileKey writeFile(@NotNull File file) throws IOException {
        int read;
        if (file == null) {
            RandomAccessFileStoreWriter.$$$reportNull$$$0(1);
        }
        long offset = this.myOffset;
        long sz = 0L;
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));
        byte[] buffer = new byte[65536];
        while ((read = ((InputStream)fis).read(buffer)) >= 0) {
            sz += (long)read;
            this.myOutputStream.write(buffer, 0, read);
        }
        this.myOffset += sz;
        RandomAccessFileKey randomAccessFileKey = new RandomAccessFileKey(offset, sz);
        RandomAccessFileKey randomAccessFileKey2 = randomAccessFileKey;
        if (randomAccessFileKey2 == null) {
            RandomAccessFileStoreWriter.$$$reportNull$$$0(2);
        }
        return randomAccessFileKey2;
        finally {
            ((InputStream)fis).close();
        }
    }

    @Override
    @NotNull
    public FileStorageReader closeOpenReader() throws IOException {
        this.close();
        RandomAccessFileStoreReader randomAccessFileStoreReader = new RandomAccessFileStoreReader(this.myFile);
        if (randomAccessFileStoreReader == null) {
            RandomAccessFileStoreWriter.$$$reportNull$$$0(3);
        }
        return randomAccessFileStoreReader;
    }

    @Override
    public void closeWriter() throws IOException {
        this.close();
    }

    @Override
    public void close() throws IOException {
        if (!this.myIsWriteClosed) {
            this.myOutputStream.close();
            this.myIsWriteClosed = true;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/vcs/patches/store/RandomAccessFileStoreWriter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/vcs/patches/store/RandomAccessFileStoreWriter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "writeFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "closeOpenReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeFile";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

