/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.xstream;

import com.thoughtworks.xstream.converters.extended.JavaClassConverter;
import java.util.ArrayList;
import java.util.List;
import jetbrains.buildServer.serverSide.auth.Permission;
import jetbrains.buildServer.serverSide.auth.Permissions;

public class PermissionsConverter
extends JavaClassConverter {
    private static final Class ourConverter = Permissions.class;

    public PermissionsConverter() {
        super(ourConverter.getClassLoader());
    }

    public boolean canConvert(Class aClass) {
        return aClass.equals(ourConverter);
    }

    public String toString(Object o) {
        Permissions perms = (Permissions)o;
        StringBuilder builder = new StringBuilder();
        List<Permission> permissions = perms.toList();
        for (int i = 0; i < permissions.size(); ++i) {
            builder.append(permissions.get(i).name());
            if (i >= permissions.size() - 1) continue;
            builder.append(':');
        }
        return builder.toString();
    }

    public Object fromString(String text) {
        String[] names = text.split(":");
        ArrayList<Permission> perms = new ArrayList<Permission>();
        for (String name : names) {
            Permission p = Permission.lookupPermission(name);
            if (p == null) continue;
            perms.add(p);
        }
        return new Permissions(perms);
    }
}

