/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import jetbrains.buildServer.AddToQueueRequest;
import jetbrains.buildServer.AddToQueueResult;
import jetbrains.buildServer.BuildInstanceData;
import jetbrains.buildServer.BuildTypeData;
import jetbrains.buildServer.ProjectData;
import jetbrains.buildServer.TeamServerSummaryData;
import jetbrains.buildServer.UserChangeInfoData;
import jetbrains.buildServer.messages.DateConverter;
import jetbrains.buildServer.messages.MessagesPersistence;
import jetbrains.buildServer.messages.StatusConverter;
import jetbrains.buildServer.serverSide.ResponsibilityInfoData;
import jetbrains.buildServer.serverSide.auth.Permissions;
import jetbrains.buildServer.serverSide.userChanges.CanceledInfo;
import jetbrains.buildServer.serverSide.userChanges.PersonalChangeDescriptor;
import jetbrains.buildServer.users.NotificatorPropertyKey;
import jetbrains.buildServer.users.SimpleUserData;
import jetbrains.buildServer.users.UserData;
import jetbrains.buildServer.vcs.VcsChange;
import jetbrains.buildServer.vcs.VcsModificationData;
import jetbrains.buildServer.vcs.impl.VcsRootImpl;
import jetbrains.buildServer.xstream.PermissionsConverter;

public class ServerXStreamFormat {
    private ServerXStreamFormat() {
    }

    public static void formatXStream(XStream xStream) {
        xStream.registerConverter((SingleValueConverter)new MessagesPersistence.StringConverter(), 1);
        xStream.registerConverter((SingleValueConverter)new StatusConverter());
        xStream.registerConverter((SingleValueConverter)new DateConverter());
        xStream.registerConverter((SingleValueConverter)new PermissionsConverter());
        xStream.alias("Summary", TeamServerSummaryData.class);
        xStream.alias("Project", ProjectData.class);
        xStream.alias("NotificatorPropertyKey", NotificatorPropertyKey.class);
        xStream.alias("Build", BuildInstanceData.class);
        xStream.alias("VcsChange", VcsChange.class);
        xStream.alias("ChangeInfo", UserChangeInfoData.class);
        xStream.alias("Configuration", BuildTypeData.class);
        xStream.alias("CanceledInfo", CanceledInfo.class);
        xStream.alias("Vcs", VcsRootImpl.class);
        xStream.alias("personalChangeInfo", PersonalChangeDescriptor.class);
        xStream.aliasType("permissions", Permissions.class);
        xStream.aliasField("projects", TeamServerSummaryData.class, "myProjects");
        xStream.aliasField("changes", TeamServerSummaryData.class, "myChanges");
        xStream.aliasField("personalChanges", TeamServerSummaryData.class, "myPersonalChanges");
        xStream.aliasField("watchedConfigs", TeamServerSummaryData.class, "myWatchedConfigurations");
        xStream.aliasField("watchedStatus", TeamServerSummaryData.class, "myWatchedBuildsStatus");
        xStream.aliasField("id", ProjectData.class, "myId");
        xStream.aliasField("name", ProjectData.class, "myName");
        xStream.aliasField("desc", ProjectData.class, "myDescription");
        xStream.aliasField("status", ProjectData.class, "myStatus");
        xStream.aliasField("configs", ProjectData.class, "myBuildTypes");
        xStream.aliasField("vcsRoots", ProjectData.class, "myVcsRoots");
        xStream.aliasField("singleton", BuildTypeData.class, "myIsSingleton");
        xStream.aliasField("queued", BuildTypeData.class, "myIsInQueue");
        xStream.aliasField("id", BuildTypeData.class, "myId");
        xStream.aliasField("projectName", BuildTypeData.class, "myProjectName");
        xStream.aliasField("projectId", BuildTypeData.class, "myProjectId");
        xStream.aliasField("timeOut", BuildTypeData.class, "myExecutionTimeoutMin");
        xStream.aliasField("runType", BuildTypeData.class, "myRunType");
        xStream.aliasField("descr", BuildTypeData.class, "myDescription");
        xStream.aliasField("name", BuildTypeData.class, "myName");
        xStream.aliasField("checkoutType", BuildTypeData.class, "myCheckoutType");
        xStream.aliasField("status", BuildTypeData.class, "myStatus");
        xStream.aliasField("responsibility", BuildTypeData.class, "myResponsibilityInfo");
        xStream.aliasField("isLastFinishedLoaded", BuildTypeData.class, "myLastFinishedLoaded");
        xStream.aliasField("lastFinished", BuildTypeData.class, "myLastFinished");
        xStream.aliasField("isLastSuccessfullyFinishedLoaded", BuildTypeData.class, "myLastSuccessfullyFinishedLoaded");
        xStream.aliasField("lastSuccessfullyFinished", BuildTypeData.class, "myLastSuccessfullyFinished");
        xStream.aliasField("running", BuildTypeData.class, "myRunning");
        xStream.aliasField("paused", BuildTypeData.class, "myIsPaused");
        xStream.aliasField("vcsRoots", BuildTypeData.class, "myVcsRoots");
        xStream.aliasField("user", ResponsibilityInfoData.class, "myUser");
        xStream.aliasField("comment", ResponsibilityInfoData.class, "myUserComment");
        xStream.aliasField("since", ResponsibilityInfoData.class, "myTimestamp");
        xStream.aliasField("fixed", ResponsibilityInfoData.class, "myFixed");
        xStream.aliasField("active", ResponsibilityInfoData.class, "myActive");
        xStream.aliasField("start", BuildInstanceData.class, "myStartDate");
        xStream.aliasField("finish", BuildInstanceData.class, "myFinishDate");
        xStream.aliasField("agent", BuildInstanceData.class, "myAgentName");
        xStream.aliasField("id", BuildInstanceData.class, "myBuildId");
        xStream.aliasField("estimationTimeLeft", BuildInstanceData.class, "myEstimationForTimeLeft");
        xStream.aliasField("statusDescriptor", BuildInstanceData.class, "myStatusDescriptor");
        xStream.aliasField("personal", BuildInstanceData.class, "myPersonal");
        xStream.aliasField("configId", BuildInstanceData.class, "myBuildTypeId");
        xStream.aliasField("number", BuildInstanceData.class, "myBuildNumber");
        xStream.aliasField("configuration", BuildInstanceData.class, "myBuildType");
        xStream.aliasField("id", UserData.class, "myId");
        xStream.aliasField("realm", UserData.class, "myRealm");
        xStream.aliasField("userName", UserData.class, "myUsername");
        xStream.aliasField("name", UserData.class, "myName");
        xStream.aliasField("lastLogged", UserData.class, "myLastLoginTimestamp");
        xStream.aliasField("properties", UserData.class, "myProperties");
        xStream.aliasField("visibleProjects", UserData.class, "myVisibleProjects");
        xStream.aliasField("allProjects", UserData.class, "myAllProjects");
        xStream.omitField(UserData.class, "myPermissionsHolder");
        xStream.aliasField("id", SimpleUserData.class, "myId");
        xStream.aliasField("userName", SimpleUserData.class, "myUsername");
        xStream.aliasField("name", SimpleUserData.class, "myName");
        xStream.aliasField("id", VcsModificationData.class, "myId");
        xStream.aliasField("personal", VcsModificationData.class, "myIsPersonal");
        xStream.aliasField("typeName", VcsChange.class, "myChangeTypeName");
        xStream.aliasField("file", VcsChange.class, "myFileName");
        xStream.aliasField("type", VcsChange.class, "myType");
        xStream.aliasField("afterMum", VcsChange.class, "myAfterChangeRevisionNumber");
        xStream.aliasField("beforeNum", VcsChange.class, "myBeforeChangeRevisionNumber");
        xStream.aliasField("mod", UserChangeInfoData.class, "myModificationData");
        xStream.aliasField("builds", UserChangeInfoData.class, "myFirstRunInMap");
        xStream.aliasField("current", UserChangeInfoData.class, "myCurrentMap");
        xStream.aliasField("fixed", UserChangeInfoData.class, "myFixedInMap");
        xStream.aliasField("users", UserChangeInfoData.class, "myUserIds");
        xStream.aliasField("userId", CanceledInfo.class, "myUserId");
        xStream.aliasField("comment", CanceledInfo.class, "myComment");
        xStream.alias("AddToQueueRequest", AddToQueueRequest.class);
        xStream.aliasField("changeListId", AddToQueueRequest.class, "myChangeListId");
        xStream.aliasField("buildTypeId", AddToQueueRequest.class, "myBuildTypeId");
        xStream.aliasField("agentId", AddToQueueRequest.class, "myAgentId");
        xStream.alias("AddToQueueResult", AddToQueueResult.class);
        xStream.aliasField("failureReasons", AddToQueueResult.class, "myFailureReason");
        xStream.ignoreUnknownElements();
    }
}

