/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import com.intellij.util.Consumer;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import jetbrains.buildServer.AlarmBasedComponent;
import jetbrains.buildServer.ExceptionUtil;
import jetbrains.buildServer.TeamCitySnapshot;
import jetbrains.buildServer.TeamServerSummary;
import jetbrains.buildServer.util.Dates;
import jetbrains.buildServer.util.filters.Filter;
import jetbrains.buildServer.util.filters.FilterUtil;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

abstract class AbstractKeyBasedPeriodicalChecker<T>
extends AlarmBasedComponent {
    @NotNull
    private static final Logger LOG = Logger.getLogger(AbstractKeyBasedPeriodicalChecker.class);
    @NotNull
    protected final TeamCitySnapshot mySnapshot;
    @NotNull
    private final MultiMap<String, T> myListeners;

    protected AbstractKeyBasedPeriodicalChecker(@NotNull TeamCitySnapshot snapshot, @NotNull String taskName) {
        if (snapshot == null) {
            AbstractKeyBasedPeriodicalChecker.$$$reportNull$$$0(0);
        }
        if (taskName == null) {
            AbstractKeyBasedPeriodicalChecker.$$$reportNull$$$0(1);
        }
        super(snapshot.getIde().createAlarm(), taskName, (int)Dates.ONE_MINUTE);
        this.myListeners = new MultiMap();
        this.mySnapshot = snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(@NotNull String key, @NotNull T listener) {
        if (key == null) {
            AbstractKeyBasedPeriodicalChecker.$$$reportNull$$$0(2);
        }
        if (listener == null) {
            AbstractKeyBasedPeriodicalChecker.$$$reportNull$$$0(3);
        }
        MultiMap<String, T> multiMap = this.myListeners;
        synchronized (multiMap) {
            this.myListeners.putValue((Object)key, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(@NotNull T listener) {
        if (listener == null) {
            AbstractKeyBasedPeriodicalChecker.$$$reportNull$$$0(4);
        }
        MultiMap<String, T> multiMap = this.myListeners;
        synchronized (multiMap) {
            for (String key : new ArrayList(this.myListeners.keySet())) {
                this.myListeners.removeValue((Object)key, listener);
            }
        }
    }

    @Override
    protected void doRequest() {
        if (this.mySnapshot.getState().canConnectToServer()) {
            this.doDoRequest();
        }
    }

    protected abstract void doDoRequest();

    protected void fireEvent(@NotNull String key, @NotNull Consumer<T> listenerConsumer) {
        if (key == null) {
            AbstractKeyBasedPeriodicalChecker.$$$reportNull$$$0(5);
        }
        if (listenerConsumer == null) {
            AbstractKeyBasedPeriodicalChecker.$$$reportNull$$$0(6);
        }
        for (T listener : this.getListenersForKey(key)) {
            try {
                listenerConsumer.consume(listener);
            }
            catch (Throwable e) {
                ExceptionUtil.log((Logger)LOG, (String)"Listener failed to process event", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected Set<String> getWatchedKeys() {
        final TeamServerSummary summary = this.mySnapshot.getSummaryProvider().getSummary();
        MultiMap<String, T> multiMap = this.myListeners;
        // MONITORENTER : multiMap
        Set set = (Set)FilterUtil.filterAndCopy((Iterable)this.myListeners.keySet(), new HashSet(), (Filter)new Filter<String>(){

            public boolean accept(@NotNull String key) {
                if (key == null) {
                    1.$$$reportNull$$$0(0);
                }
                return AbstractKeyBasedPeriodicalChecker.this.acceptKey(key, summary);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/AbstractKeyBasedPeriodicalChecker$1", "accept"));
            }
        });
        // MONITOREXIT : multiMap
        if (set != null) return set;
        AbstractKeyBasedPeriodicalChecker.$$$reportNull$$$0(7);
        return set;
    }

    protected abstract boolean acceptKey(@NotNull String var1, @NotNull TeamServerSummary var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private Collection<T> getListenersForKey(@NotNull String buildTypeId) {
        if (buildTypeId == null) {
            AbstractKeyBasedPeriodicalChecker.$$$reportNull$$$0(8);
        }
        MultiMap<String, T> multiMap = this.myListeners;
        // MONITORENTER : multiMap
        Collection collection = this.myListeners.get((Object)buildTypeId);
        // MONITOREXIT : multiMap
        if (collection != null) return collection;
        AbstractKeyBasedPeriodicalChecker.$$$reportNull$$$0(9);
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        super.dispose();
        MultiMap<String, T> multiMap = this.myListeners;
        synchronized (multiMap) {
            this.myListeners.clear();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshot";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listenerConsumer";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/AbstractKeyBasedPeriodicalChecker";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildTypeId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/AbstractKeyBasedPeriodicalChecker";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getWatchedKeys";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getListenersForKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fireEvent";
                break;
            }
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getListenersForKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

