/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jetbrains.buildServer.DebugSessionInfo;

public class AddToQueueRequest {
    private final String myBuildTypeId;
    private Long myChangeListId;
    private Integer myAgentId = null;
    private Integer myAgentPoolId = null;
    private Map<String, String> myBuildParameters = null;
    private boolean myPutBuildOnTheQueueTop = false;
    private boolean myRebuildDependencies = false;
    private boolean myCheckForChangesEarly = false;
    private boolean myCleanSources = false;
    private Map<String, DebugSessionInfo> myDebugSessionInfos = null;

    public AddToQueueRequest(String buildTypeId, long changeListId) {
        this.myBuildTypeId = buildTypeId;
        this.myChangeListId = changeListId;
    }

    public AddToQueueRequest(String buildTypeId) {
        this.myBuildTypeId = buildTypeId;
        this.myChangeListId = null;
    }

    public boolean isPersonal() {
        return this.myChangeListId != null;
    }

    public Long getChangeListId() {
        return this.myChangeListId;
    }

    public String getBuildTypeId() {
        return this.myBuildTypeId;
    }

    public Integer getAgentId() {
        return this.myAgentId;
    }

    public Integer getAgentPoolId() {
        return this.myAgentPoolId;
    }

    public Map<String, String> getBuildParameters() {
        return this.myBuildParameters != null ? this.myBuildParameters : Collections.emptyMap();
    }

    public boolean isPutBuildOnTheQueueTop() {
        return this.myPutBuildOnTheQueueTop;
    }

    public boolean isRebuildDependencies() {
        return this.myRebuildDependencies;
    }

    public boolean isCheckForChangesEarly() {
        return this.myCheckForChangesEarly;
    }

    public boolean isCleanSources() {
        return this.myCleanSources;
    }

    public Map<String, DebugSessionInfo> getDebugSessionInfos() {
        return this.myDebugSessionInfos;
    }

    public void setChangeListId(Long changeListId) {
        this.myChangeListId = changeListId;
    }

    public void setAgentId(Integer agentId) {
        this.myAgentId = agentId;
    }

    public void setAgentPoolId(Integer agentPoolId) {
        this.myAgentPoolId = agentPoolId;
    }

    public void setBuildParameters(Map<String, String> buildParameters) {
        this.myBuildParameters = buildParameters;
    }

    public void setPutBuildOnTheQueueTop(boolean putBuildOnTheQueueTop) {
        this.myPutBuildOnTheQueueTop = putBuildOnTheQueueTop;
    }

    public void setRebuildDependencies(boolean rebuildDependencies) {
        this.myRebuildDependencies = rebuildDependencies;
    }

    public void setCheckForChangesEarly(boolean checkForChangesEarly) {
        this.myCheckForChangesEarly = checkForChangesEarly;
    }

    public void setCleanSources(boolean cleanSources) {
        this.myCleanSources = cleanSources;
    }

    public void addDebugSessionInfo(String runnerId, DebugSessionInfo debugSessionInfo) {
        if (this.myDebugSessionInfos == null) {
            this.myDebugSessionInfos = new HashMap<String, DebugSessionInfo>();
        }
        this.myDebugSessionInfos.put(runnerId, debugSessionInfo);
    }

    public boolean equals(Object o) {
        return o instanceof AddToQueueRequest && AddToQueueRequest.safeEquals(this.myBuildTypeId, ((AddToQueueRequest)o).myBuildTypeId) && AddToQueueRequest.safeEquals(this.myChangeListId, ((AddToQueueRequest)o).myChangeListId) && AddToQueueRequest.safeEquals(this.myAgentId, ((AddToQueueRequest)o).myAgentId) && AddToQueueRequest.safeEquals(this.myAgentPoolId, ((AddToQueueRequest)o).myAgentPoolId) && AddToQueueRequest.safeEquals(this.myBuildParameters, ((AddToQueueRequest)o).myBuildParameters) && this.myPutBuildOnTheQueueTop == ((AddToQueueRequest)o).myPutBuildOnTheQueueTop && this.myRebuildDependencies == ((AddToQueueRequest)o).myRebuildDependencies && this.myCleanSources == ((AddToQueueRequest)o).myCleanSources && this.myCheckForChangesEarly == ((AddToQueueRequest)o).myCheckForChangesEarly && AddToQueueRequest.safeEquals(this.myDebugSessionInfos, ((AddToQueueRequest)o).myDebugSessionInfos);
    }

    public int hashCode() {
        int hashCode = 0;
        for (int hc : Arrays.asList(AddToQueueRequest.safeHashCode(this.myPutBuildOnTheQueueTop), AddToQueueRequest.safeHashCode(this.myRebuildDependencies), AddToQueueRequest.safeHashCode(this.myCleanSources), AddToQueueRequest.safeHashCode(this.myBuildTypeId), AddToQueueRequest.safeHashCode(this.myChangeListId), AddToQueueRequest.safeHashCode(this.myAgentId), AddToQueueRequest.safeHashCode(this.myAgentPoolId), AddToQueueRequest.safeHashCode(this.myBuildParameters), AddToQueueRequest.safeHashCode(this.myCheckForChangesEarly), AddToQueueRequest.safeHashCode(this.myDebugSessionInfos))) {
            hashCode = hashCode * 31 + hc;
        }
        return hashCode;
    }

    private static boolean safeEquals(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    private static int safeHashCode(Object obj) {
        return obj == null ? 0 : obj.hashCode();
    }

    public String toString() {
        return "AddToQueueRequest{myChangeListId=" + this.myChangeListId + ", myBuildTypeId='" + this.myBuildTypeId + "'}";
    }
}

