/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import java.util.Date;
import java.util.List;
import jetbrains.buildServer.BuildType;
import jetbrains.buildServer.StatusDescriptor;
import jetbrains.buildServer.messages.Status;
import jetbrains.buildServer.serverSide.userChanges.CanceledInfo;
import jetbrains.buildServer.tests.TestInfo;
import jetbrains.buildServer.users.User;
import jetbrains.buildServer.users.UserSet;
import jetbrains.buildServer.vcs.SelectPrevBuildPolicy;
import jetbrains.buildServer.vcs.VcsModification;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Build {
    @NotNull
    public Date getStartDate();

    public String getAgentName();

    public long getBuildId();

    public StatusDescriptor getStatusDescriptor();

    public List<String> getLogMessages(int var1, int var2);

    public List<TestInfo> getTestMessages(int var1, int var2);

    public List<String> getCompilationErrorMessages();

    @Nullable
    public BuildType getBuildType();

    @NotNull
    public String getBuildTypeId();

    @NotNull
    public String getBuildTypeExternalId();

    @NotNull
    public String getBuildTypeName();

    @NotNull
    public String getFullName();

    @Nullable
    public String getProjectId();

    @Nullable
    public String getProjectExternalId();

    public List<? extends VcsModification> getChanges(SelectPrevBuildPolicy var1, boolean var2);

    public List<? extends VcsModification> getContainingChanges();

    public boolean isPersonal();

    public Status getBuildStatus();

    public boolean isFinished();

    public UserSet<? extends User> getCommitters(SelectPrevBuildPolicy var1);

    @NotNull
    public String getBuildNumber();

    @Nullable
    public Date getFinishDate();

    public CanceledInfo getCanceledInfo();

    public long getDuration();
}

