/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jetbrains.buildServer.Build;
import jetbrains.buildServer.BuildTypeData;
import jetbrains.buildServer.DataFactory;
import jetbrains.buildServer.RunningBuild;
import jetbrains.buildServer.StatusDescriptor;
import jetbrains.buildServer.serverSide.userChanges.CanceledInfo;
import jetbrains.buildServer.users.User;
import jetbrains.buildServer.util.Dates;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildInstanceData {
    private final Date myStartDate;
    private final Date myFinishDate;
    private final String myAgentName;
    private final long myBuildId;
    private final long myEstimationForTimeLeft;
    private final StatusDescriptor myStatusDescriptor;
    private final boolean myPersonal;
    @NotNull
    private final String myBuildNumber;
    @NotNull
    private final BuildTypeData myBuildType;
    private final CanceledInfo myCanceledInfo;
    private final long myDuration;

    /*
     * WARNING - void declaration
     */
    public BuildInstanceData(Date startDate, Date finishDate, String agentName, long buildId, long estimationForTimeLeft, long buildDuration, StatusDescriptor statusDescriptor, boolean personal, @NotNull String string, @NotNull BuildTypeData buildTypeData, CanceledInfo canceledInfo) {
        void canceledInfo2;
        void buildType;
        void buildNumber;
        if (string == null) {
            BuildInstanceData.$$$reportNull$$$0(0);
        }
        if (buildTypeData == null) {
            BuildInstanceData.$$$reportNull$$$0(1);
        }
        this.myStartDate = Dates.toStandardDate((Date)startDate);
        this.myFinishDate = finishDate == null ? null : Dates.toStandardDate((Date)finishDate);
        this.myAgentName = agentName;
        this.myBuildId = buildId;
        this.myEstimationForTimeLeft = estimationForTimeLeft;
        this.myStatusDescriptor = statusDescriptor;
        this.myPersonal = personal;
        this.myBuildNumber = buildNumber;
        this.myBuildType = buildType;
        this.myCanceledInfo = canceledInfo2;
        this.myDuration = buildDuration;
    }

    public Date getStartDate() {
        return this.myStartDate;
    }

    public Date getFinishDate() {
        return this.myFinishDate;
    }

    public String getAgentName() {
        return this.myAgentName;
    }

    public long getBuildId() {
        return this.myBuildId;
    }

    public long getEstimationForTimeLeft() {
        return this.myEstimationForTimeLeft;
    }

    public StatusDescriptor getStatusDescriptor() {
        return this.myStatusDescriptor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildInstanceData that = (BuildInstanceData)o;
        return this.myBuildId == that.myBuildId;
    }

    public int hashCode() {
        return (int)(this.myBuildId ^ this.myBuildId >>> 32);
    }

    public boolean isPersonal() {
        return this.myPersonal;
    }

    public String getBuildTypeId() {
        return this.myBuildType.getId();
    }

    public static BuildInstanceData createOn(Build buildInstance, BuildTypeData buildType) {
        if (buildInstance.isFinished()) {
            return new BuildInstanceData(buildInstance.getStartDate(), buildInstance.getFinishDate(), buildInstance.getAgentName(), buildInstance.getBuildId(), -1L, buildInstance.getDuration(), buildInstance.getStatusDescriptor(), buildInstance.isPersonal(), buildInstance.getBuildNumber(), buildType, buildInstance.getCanceledInfo());
        }
        return new BuildInstanceData(buildInstance.getStartDate(), null, buildInstance.getAgentName(), buildInstance.getBuildId(), ((RunningBuild)buildInstance).getEstimationForTimeLeft(), buildInstance.getDuration(), buildInstance.getStatusDescriptor(), buildInstance.isPersonal(), buildInstance.getBuildNumber(), buildType, buildInstance.getCanceledInfo());
    }

    public static List<BuildInstanceData> convertBuildsToDatas(List<? extends Build> builds, DataFactory factory, @Nullable User user) {
        ArrayList<BuildInstanceData> result = new ArrayList<BuildInstanceData>();
        for (Build build : builds) {
            result.add(factory.createData(build, user));
        }
        return result;
    }

    public String getBuildNumber() {
        return this.myBuildNumber;
    }

    @NotNull
    public BuildTypeData getBuildType() {
        BuildTypeData buildTypeData = this.myBuildType;
        if (buildTypeData == null) {
            BuildInstanceData.$$$reportNull$$$0(2);
        }
        return buildTypeData;
    }

    public CanceledInfo getCanceledInfo() {
        return this.myCanceledInfo;
    }

    public long getDuration() {
        return this.myDuration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildNumber";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/BuildInstanceData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/BuildInstanceData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

