/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import com.intellij.util.containers.ComparatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.buildServer.BuildInstanceData;
import jetbrains.buildServer.BuildType;
import jetbrains.buildServer.BuildTypeDescriptor;
import jetbrains.buildServer.BuildTypeStatusDescriptorData;
import jetbrains.buildServer.DataFactory;
import jetbrains.buildServer.StatusDescriptor;
import jetbrains.buildServer.messages.Status;
import jetbrains.buildServer.serverSide.BuildTypeOptions;
import jetbrains.buildServer.serverSide.ResponsibilityInfoData;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.users.User;
import jetbrains.buildServer.util.CollectionsUtil;
import jetbrains.buildServer.util.Option;
import jetbrains.buildServer.util.OptionSupport;
import jetbrains.buildServer.util.filters.Filter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildTypeData {
    private final String myId;
    private final String myExternalId;
    @Nullable
    private final Long myPersonalChangeId;
    private final String myProjectName;
    private final String myProjectId;
    private final String myProjectExternalId;
    private final Collection<String> myRunnerTypes;
    private final String myName;
    private final String myDescription;
    private final BuildTypeDescriptor.CheckoutType myCheckoutType;
    @Deprecated
    private final Status myStatus;
    @NotNull
    private final BuildTypeStatusDescriptorData myStatusDescriptor;
    private final ResponsibilityInfoData myResponsibilityInfo;
    @Nullable
    private final Map<String, String> myInternalConfigParameters;
    @Nullable
    private final Map<Option, Object> myOptions;
    private boolean myLastFinishedLoaded;
    private BuildInstanceData myLastFinished;
    private boolean myLastSuccessfullyFinishedLoaded;
    private BuildInstanceData myLastSuccessfullyFinished;
    private List<BuildInstanceData> myRunning;
    private final boolean myIsPaused;
    private final boolean myIsInQueue = false;
    private static final boolean ourProvideBuildInStatusDescriptor = TeamCityProperties.getBoolean((String)"teamcity.serverSummary.buildTypeStatusDescriptor.includeBuild");
    private static final Set<Option> OPTIONS_TO_SEND = CollectionsUtil.setOf((Object[])new Option[]{BuildTypeOptions.BT_BUILD_CONFIGURATION_TYPE, BuildTypeOptions.BT_BRANCH_FILTER});

    public BuildTypeData(@NotNull String id, @NotNull String externalId, @Nullable Long personalChangeId, String projectName, String projectId, String projectExternalId, Collection<String> runnerTypes, String name, String description, BuildTypeDescriptor.CheckoutType checkoutType, @NotNull BuildTypeStatusDescriptorData statusDescriptor, ResponsibilityInfoData responsibilityInfo, boolean paused, Map<String, String> internalConfigParameters, Map<Option, Object> options) {
        if (id == null) {
            BuildTypeData.$$$reportNull$$$0(0);
        }
        if (externalId == null) {
            BuildTypeData.$$$reportNull$$$0(1);
        }
        if (statusDescriptor == null) {
            BuildTypeData.$$$reportNull$$$0(2);
        }
        this.myLastFinishedLoaded = false;
        this.myLastFinished = null;
        this.myLastSuccessfullyFinishedLoaded = false;
        this.myLastSuccessfullyFinished = null;
        this.myRunning = null;
        this.myIsInQueue = false;
        this.myIsPaused = paused;
        this.myId = id;
        this.myExternalId = externalId;
        this.myPersonalChangeId = personalChangeId;
        this.myProjectName = projectName;
        this.myRunnerTypes = new ArrayList<String>(runnerTypes);
        this.myName = name;
        this.myDescription = description;
        this.myCheckoutType = checkoutType;
        this.myStatus = statusDescriptor.getStatusDescriptor().getStatus();
        this.myStatusDescriptor = statusDescriptor;
        this.myResponsibilityInfo = responsibilityInfo;
        this.myProjectId = projectId;
        this.myProjectExternalId = projectExternalId;
        this.myInternalConfigParameters = internalConfigParameters.isEmpty() ? null : new HashMap<String, String>(internalConfigParameters);
        this.myOptions = options.isEmpty() ? null : new HashMap<Option, Object>(options);
    }

    public boolean isInQueue() {
        return false;
    }

    public String getId() {
        return this.myId;
    }

    public String getExternalId() {
        return this.myExternalId;
    }

    public String getProjectName() {
        return this.myProjectName;
    }

    public String getName() {
        return this.myName;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public Collection<String> getRunnerTypes() {
        return Collections.unmodifiableCollection(this.myRunnerTypes);
    }

    public BuildTypeDescriptor.CheckoutType getCheckoutType() {
        return this.myCheckoutType;
    }

    public static BuildTypeData createOn(@NotNull BuildType buildType) {
        if (buildType == null) {
            BuildTypeData.$$$reportNull$$$0(3);
        }
        return BuildTypeData.createOn(buildType, null);
    }

    public static BuildTypeData createOn(@NotNull BuildType buildType, @Nullable Long personalChangeId) {
        if (buildType == null) {
            BuildTypeData.$$$reportNull$$$0(4);
        }
        BuildTypeStatusDescriptorData btsd = ourProvideBuildInStatusDescriptor ? BuildTypeStatusDescriptorData.createOn(buildType.getStatusDescriptor()) : new BuildTypeStatusDescriptorData(new StatusDescriptor(buildType.getStatus(), ""), null, null);
        return new BuildTypeData(buildType.getBuildTypeId(), buildType.getExternalId(), personalChangeId, buildType.getProjectName(), buildType.getProjectId(), buildType.getProjectExternalId(), buildType.getRunnerTypes(), buildType.getName(), null, buildType.getCheckoutType(), btsd, ResponsibilityInfoData.createOn(buildType.getResponsibilityInfo()), buildType.isPaused(), BuildTypeData.getInternalConfigParameters(buildType.getParameters()), BuildTypeData.getDeclaredOptions(buildType));
    }

    public static List<BuildTypeData> createDataListOn(List<? extends BuildType> buildTypes, DataFactory factory, DataFactory.BuildTypeInstancesFilter loadInstances, Filter<BuildType> buildTypeFilter, User user) {
        ArrayList<BuildTypeData> result = new ArrayList<BuildTypeData>();
        for (BuildType buildType : buildTypes) {
            if (!buildTypeFilter.accept((Object)buildType)) continue;
            result.add(factory.createData(buildType, loadInstances, user));
        }
        return result;
    }

    @Deprecated
    public Status getStatus() {
        return this.myStatus;
    }

    @NotNull
    public BuildTypeStatusDescriptorData getStatusDescriptor() {
        BuildTypeStatusDescriptorData buildTypeStatusDescriptorData = this.myStatusDescriptor;
        if (buildTypeStatusDescriptorData == null) {
            BuildTypeData.$$$reportNull$$$0(5);
        }
        return buildTypeStatusDescriptorData;
    }

    public ResponsibilityInfoData getResponsibilityInfo() {
        return this.myResponsibilityInfo;
    }

    public boolean lastFinishedLoaded() {
        return this.myLastFinishedLoaded;
    }

    public void loadLastFinished(BuildInstanceData data) {
        try {
            this.myLastFinished = data;
        }
        finally {
            this.myLastFinishedLoaded = true;
        }
    }

    public boolean runningLoaded() {
        return this.myRunning != null;
    }

    public void loadRunning(List<BuildInstanceData> dataList) {
        this.myRunning = new ArrayList<BuildInstanceData>();
        this.myRunning.addAll(dataList);
    }

    public BuildInstanceData getLastFinished() {
        return this.myLastFinished;
    }

    public List<BuildInstanceData> getRunningBuilds() {
        return this.myRunning;
    }

    public boolean isLastSuccessfullyFinishedLoaded() {
        return this.myLastSuccessfullyFinishedLoaded;
    }

    public BuildInstanceData getLastSuccessfullyFinished() {
        return this.myLastSuccessfullyFinished;
    }

    public void loadLastSuccessfullyFinished(BuildInstanceData data) {
        this.myLastSuccessfullyFinished = data;
        this.myLastSuccessfullyFinishedLoaded = true;
    }

    public String getProjectId() {
        return this.myProjectId;
    }

    public String getProjectExternalId() {
        return this.myProjectExternalId;
    }

    public boolean isPaused() {
        return this.myIsPaused;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BuildTypeData)) {
            return false;
        }
        BuildTypeData that = (BuildTypeData)o;
        return this.myId.equals(that.myId) && this.myExternalId.equalsIgnoreCase(that.myExternalId) && ComparatorUtil.equalsNullable((Object)this.myPersonalChangeId, (Object)that.myPersonalChangeId);
    }

    public int hashCode() {
        int result = this.myId.hashCode() + this.myExternalId.hashCode() * 11;
        result = 31 * result + (this.myPersonalChangeId != null ? this.myPersonalChangeId.hashCode() : 0);
        return result;
    }

    @NotNull
    public Map<String, String> getInternalConfigParameters() {
        if (this.myInternalConfigParameters == null) {
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                BuildTypeData.$$$reportNull$$$0(6);
            }
            return map;
        }
        Map<String, String> map = Collections.unmodifiableMap(this.myInternalConfigParameters);
        if (map == null) {
            BuildTypeData.$$$reportNull$$$0(7);
        }
        return map;
    }

    @NotNull
    public Map<Option, Object> getOptions() {
        if (this.myOptions == null) {
            Map<Option, Object> map = Collections.emptyMap();
            if (map == null) {
                BuildTypeData.$$$reportNull$$$0(8);
            }
            return map;
        }
        Map<Option, Object> map = Collections.unmodifiableMap(this.myOptions);
        if (map == null) {
            BuildTypeData.$$$reportNull$$$0(9);
        }
        return map;
    }

    @NotNull
    public <T> T getOption(@NotNull Option<T> option) {
        Object val;
        if (option == null) {
            BuildTypeData.$$$reportNull$$$0(10);
        }
        if ((val = this.getOptions().get(option)) != null) {
            Object object = val;
            if (object == null) {
                BuildTypeData.$$$reportNull$$$0(11);
            }
            return (T)object;
        }
        Object object = option.getDefaultValue();
        if (object == null) {
            BuildTypeData.$$$reportNull$$$0(12);
        }
        return (T)object;
    }

    @NotNull
    private static Map<String, String> getInternalConfigParameters(Map<String, String> parameters) {
        Map map = CollectionsUtil.filterMap(parameters, (Filter)new Filter<String>(){

            public boolean accept(@NotNull String key) {
                if (key == null) {
                    1.$$$reportNull$$$0(0);
                }
                return key.startsWith("teamcity.remote-debug.");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/BuildTypeData$1", "accept"));
            }
        }, (Filter)CollectionsUtil.ACCEPT_ALL);
        if (map == null) {
            BuildTypeData.$$$reportNull$$$0(13);
        }
        return map;
    }

    private static Map<Option, Object> getDeclaredOptions(BuildType buildType) {
        if (buildType instanceof OptionSupport) {
            OptionSupport support = (OptionSupport)buildType;
            HashMap<Option, Object> result = new HashMap<Option, Object>();
            for (Option option : OPTIONS_TO_SEND) {
                Object value = support.getOption(option);
                if (value.equals(option.getDefaultValue())) continue;
                result.put(option, value);
            }
            return result;
        }
        return Collections.emptyMap();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusDescriptor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildType";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/BuildTypeData";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/BuildTypeData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusDescriptor";
                break;
            }
            case 6: 
            case 7: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalConfigParameters";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOption";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createOn";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOption";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

