/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.buildServer.AbstractKeyBasedPeriodicalChecker;
import jetbrains.buildServer.Build;
import jetbrains.buildServer.BuildType;
import jetbrains.buildServer.ConnectionStatusListener;
import jetbrains.buildServer.TeamCitySnapshot;
import jetbrains.buildServer.TeamServerSummary;
import jetbrains.buildServer.TeamServerSummaryProvider;
import jetbrains.buildServer.serverMessages.FinishedBuildListener;
import jetbrains.buildServer.serverProxy.BuildTypeProxy;
import jetbrains.buildServer.util.filters.Filter;
import jetbrains.buildServer.util.filters.FilterUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LastFinishedBuildsManager
extends AbstractKeyBasedPeriodicalChecker<FinishedBuildListener> {
    @NotNull
    private final Map<String, Build> myBuilds;

    public LastFinishedBuildsManager(@NotNull TeamCitySnapshot snapshot) {
        if (snapshot == null) {
            LastFinishedBuildsManager.$$$reportNull$$$0(0);
        }
        super(snapshot, "Load last finished");
        this.myBuilds = new HashMap<String, Build>();
    }

    @Nullable
    public Build getLastFinishedNoReload(@NotNull BuildType buildType) {
        if (buildType == null) {
            LastFinishedBuildsManager.$$$reportNull$$$0(1);
        }
        Build loaded = this.getBuild(buildType.getBuildTypeId());
        Build cached = this.getCachedLastFinished(buildType);
        if (loaded == null) {
            return cached;
        }
        if (cached == null) {
            return loaded;
        }
        return loaded.getBuildId() > cached.getBuildId() ? loaded : cached;
    }

    @NotNull
    public List<Build> getLastFinishedBuilds(@NotNull Collection<BuildType> buildTypes) {
        if (buildTypes == null) {
            LastFinishedBuildsManager.$$$reportNull$$$0(2);
        }
        final ArrayList<Build> result = new ArrayList<Build>();
        final ArrayList<String> buildTypeIds = new ArrayList<String>();
        for (BuildType buildType : buildTypes) {
            Build cached = this.getLastFinishedNoReload(buildType);
            if (cached == null) {
                buildTypeIds.add(buildType.getBuildTypeId());
                continue;
            }
            result.add(cached);
        }
        this.mySnapshot.getProcessManager().performSystemAction(new Runnable(){

            @Override
            public void run() {
                result.addAll(LastFinishedBuildsManager.this.mySnapshot.getServerFacade().getNewFinishedBuilds(Collections.emptyList(), buildTypeIds));
            }
        }, "Loading Data from Server", ConnectionStatusListener.ErrorProcessingKind.SHOW_MESSAGE);
        ArrayList<Build> arrayList = result;
        if (arrayList == null) {
            LastFinishedBuildsManager.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDoRequest() {
        final ArrayList<String> buildIds = new ArrayList<String>();
        final ArrayList<String> buildTypeIds = new ArrayList<String>();
        final ArrayList<Build> newFinished = new ArrayList<Build>();
        final Set<String> watchedConfigurationIds = this.getWatchedKeys();
        for (String buildTypeId : watchedConfigurationIds) {
            Build build = this.getBuild(buildTypeId);
            Build cached = this.getCachedLastFinished(buildTypeId, true);
            if (cached == null) {
                if (build == null) {
                    buildTypeIds.add(buildTypeId);
                    continue;
                }
                buildIds.add(String.valueOf(build.getBuildId()));
                continue;
            }
            if (build == null) {
                Map<String, Build> map = this.myBuilds;
                synchronized (map) {
                    this.myBuilds.put(buildTypeId, cached);
                    continue;
                }
            }
            if (cached.getBuildId() <= build.getBuildId()) continue;
            newFinished.add(cached);
        }
        if (!buildIds.isEmpty() || !buildTypeIds.isEmpty()) {
            this.mySnapshot.getProcessManager().performSystemAction(new Runnable(){

                @Override
                public void run() {
                    newFinished.addAll(LastFinishedBuildsManager.this.mySnapshot.getServerFacade().getNewFinishedBuilds(buildIds, buildTypeIds));
                }
            }, "Loading Data from Server", ConnectionStatusListener.ErrorProcessingKind.IGNORE);
        }
        Iterator iterator = this.myBuilds;
        synchronized (iterator) {
            FilterUtil.filterMapByKey(this.myBuilds, (Filter)new Filter<String>(){

                public boolean accept(@NotNull String buildTypeId) {
                    if (buildTypeId == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return watchedConfigurationIds.contains(buildTypeId);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildTypeId", "jetbrains/buildServer/LastFinishedBuildsManager$3", "accept"));
                }
            });
        }
        for (Build build : newFinished) {
            Map<String, Build> map = this.myBuilds;
            synchronized (map) {
                this.myBuilds.put(build.getBuildTypeId(), build);
            }
        }
        this.fireBuildsFinished(newFinished, buildTypeIds);
    }

    private void fireBuildsFinished(@NotNull List<Build> builds, @NotNull Collection<String> buildTypeIdsToIgnore) {
        if (builds == null) {
            LastFinishedBuildsManager.$$$reportNull$$$0(4);
        }
        if (buildTypeIdsToIgnore == null) {
            LastFinishedBuildsManager.$$$reportNull$$$0(5);
        }
        for (final Build build : builds) {
            String buildTypeId = build.getBuildTypeId();
            if (buildTypeIdsToIgnore.contains(buildTypeId)) continue;
            this.fireEvent(buildTypeId, new Consumer<FinishedBuildListener>(){

                public void consume(@NotNull FinishedBuildListener listener) {
                    if (listener == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    listener.processBuildFinished(build);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "jetbrains/buildServer/LastFinishedBuildsManager$4", "consume"));
                }
            });
        }
    }

    @Nullable
    private Build getCachedLastFinished(@NotNull BuildType buildType) {
        if (buildType == null) {
            LastFinishedBuildsManager.$$$reportNull$$$0(6);
        }
        return buildType instanceof BuildTypeProxy ? ((BuildTypeProxy)buildType).getLastFinishedNoReload() : this.getCachedLastFinished(buildType.getBuildTypeId(), false);
    }

    @Nullable
    private Build getCachedLastFinished(@NotNull String buildTypeId, boolean onlyUpToDate) {
        if (buildTypeId == null) {
            LastFinishedBuildsManager.$$$reportNull$$$0(7);
        }
        TeamServerSummaryProvider summaryProvider = this.mySnapshot.getSummaryProvider();
        if (onlyUpToDate && !summaryProvider.isSummaryUpToDate()) {
            return null;
        }
        BuildType proxy = summaryProvider.getSummary().findConfigurationById(buildTypeId);
        return proxy instanceof BuildTypeProxy ? ((BuildTypeProxy)proxy).getLastFinishedNoReload() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Build getBuild(@NotNull String buildTypeId) {
        if (buildTypeId == null) {
            LastFinishedBuildsManager.$$$reportNull$$$0(8);
        }
        Map<String, Build> map = this.myBuilds;
        synchronized (map) {
            return this.myBuilds.get(buildTypeId);
        }
    }

    @Override
    protected boolean acceptKey(@NotNull String key, @NotNull TeamServerSummary summary) {
        if (key == null) {
            LastFinishedBuildsManager.$$$reportNull$$$0(9);
        }
        if (summary == null) {
            LastFinishedBuildsManager.$$$reportNull$$$0(10);
        }
        return summary.findConfigurationById(key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        super.dispose();
        Map<String, Build> map = this.myBuilds;
        synchronized (map) {
            this.myBuilds.clear();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshot";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildTypes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/LastFinishedBuildsManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builds";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildTypeIdsToIgnore";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildTypeId";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "summary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/LastFinishedBuildsManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastFinishedBuilds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLastFinishedNoReload";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLastFinishedBuilds";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fireBuildsFinished";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCachedLastFinished";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBuild";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "acceptKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

