/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import jetbrains.buildServer.ConnectionStatusListener;
import jetbrains.buildServer.IncompatiblePluginError;
import jetbrains.buildServer.TeamCityCommand;
import jetbrains.buildServer.TeamCitySnapshot;
import jetbrains.buildServer.TeamServerSummary;
import jetbrains.buildServer.TeamServerSummaryProvider;
import jetbrains.buildServer.serverSide.auth.AuthenticationFailedException;
import jetbrains.buildServer.xmlrpc.RemoteCallException;
import org.apache.log4j.Logger;

public class RefreshSummaryCommand
extends TeamCityCommand {
    private static final Logger LOG = Logger.getLogger(RefreshSummaryCommand.class);

    public RefreshSummaryCommand(TeamCitySnapshot server) {
        super(server);
    }

    @Override
    public void execute() throws AuthenticationFailedException, IncompatiblePluginError, RemoteCallException {
        TeamServerSummaryProvider summaryProvider = this.getServer().getSummaryProvider();
        if (summaryProvider.isSummaryAvailable()) {
            final TeamServerSummary summary = summaryProvider.getSummary();
            int localCounter = summary.getSummaryCounter();
            final int[] serverCounter = new int[]{0};
            this.getServer().getProcessManager().performSystemAction(new Runnable(){

                @Override
                public void run() {
                    serverCounter[0] = RefreshSummaryCommand.this.getServer().getServerFacade().getTotalNumberOfEvents(summary.createSubscription(RefreshSummaryCommand.this.getServer().getUser()));
                }
            }, "Checking whether the summary is changed on server", ConnectionStatusListener.ErrorProcessingKind.RETHROW);
            if (serverCounter[0] != localCounter) {
                LOG.info((Object)"TeamCity summary is changed on server server. Schedule loading of the summary.");
                this.getServer().scheduleUpdate();
            } else {
                LOG.debug((Object)"TeamCity summary unchanged.");
                this.getServer().getIde().updateSummary(this.getServer().getSummaryProvider());
            }
        } else {
            LOG.info((Object)"TeamCity summary is empty. Schedule loading of the summary");
            this.getServer().scheduleUpdate();
        }
    }
}

