/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import jetbrains.buildServer.messages.Status;

public class StatusDescriptor {
    private static final String[] COMMONLY_USED_STATUS_TEXTS = new String[]{"Success", "Failure", "Compilation failed"};
    private final String myText;
    private final Status myStatus;

    public StatusDescriptor(Status status, String text) {
        if (status == null) {
            throw new IllegalArgumentException("Null status is not allowed");
        }
        this.myStatus = status;
        for (String commonlyUsedText : COMMONLY_USED_STATUS_TEXTS) {
            if (!commonlyUsedText.equals(text)) continue;
            text = commonlyUsedText;
            break;
        }
        this.myText = text;
    }

    public Status getStatus() {
        return this.myStatus;
    }

    public String getText() {
        return this.myText;
    }

    public boolean isSuccessful() {
        return this.getStatus().isSuccessful();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusDescriptor that = (StatusDescriptor)o;
        return this.myStatus == that.myStatus && (this.myText == null ? that.myText == null : this.myText.equals(that.myText));
    }

    public int hashCode() {
        int result = this.myText != null ? this.myText.hashCode() : 0;
        result = 29 * result + (this.myStatus != null ? this.myStatus.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.myStatus + " '" + this.myText + "'";
    }
}

