/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jetbrains.buildServer.ConnectionStatusListener;
import jetbrains.buildServer.ExceptionUtil;
import jetbrains.buildServer.Ide;
import jetbrains.buildServer.IncompatiblePluginError;
import jetbrains.buildServer.InvalidServerStateException;
import jetbrains.buildServer.ProcessExecutor;
import jetbrains.buildServer.serverProxy.RemoteBuildServerFacade;
import jetbrains.buildServer.serverSide.auth.AccessDeniedException;
import jetbrains.buildServer.serverSide.auth.AuthenticationFailedException;
import jetbrains.buildServer.util.EventDispatcher;
import jetbrains.buildServer.xmlrpc.RemoteCallException;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class TeamCityProcessManager {
    private final Ide myIde;
    private final ProcessExecutor myProcessExecutor;
    private final Logger LOG = Logger.getLogger((String)TeamCityProcessManager.class.getName());
    private final Map<Thread, Integer> myThreadLevels = new HashMap<Thread, Integer>();
    private final EventDispatcher<ConnectionStatusListener> myDispatcher = EventDispatcher.create(ConnectionStatusListener.class);
    private final Map<Thread, RemoteBuildServerFacade> myCurrentFacades = new HashMap<Thread, RemoteBuildServerFacade>();
    private static final String[] ourInvalidServerStates = new String[]{"jetbrains.buildServer.ServerCleanupInProgressException:", "jetbrains.buildServer.ServerStartingUpException:"};
    private static final String ACCESS_DENIED_EXCEPTION_PREFIX = "jetbrains.buildServer.serverSide.auth.AccessDeniedException:";

    public TeamCityProcessManager(Ide ide, ProcessExecutor processExecutor) {
        this.myIde = ide;
        this.myProcessExecutor = processExecutor;
    }

    public synchronized boolean isInsideCommand() {
        Thread current = Thread.currentThread();
        Integer commandLevel = this.myThreadLevels.get(current);
        return commandLevel != null && commandLevel > 0;
    }

    public boolean performUserAction(Runnable action, String name, ConnectionStatusListener.ErrorProcessingKind showErrorMessagesKind) {
        try {
            return this.performAction(action, name, showErrorMessagesKind);
        }
        catch (InvalidServerStateException e) {
            this.myIde.showInfoMessage("Cannot perform operation: " + e.getMessage(), name);
            return false;
        }
    }

    public boolean performSystemAction(Runnable action, String name, ConnectionStatusListener.ErrorProcessingKind showErrorMessagesKind) {
        try {
            return this.performAction(action, name, showErrorMessagesKind);
        }
        catch (InvalidServerStateException ignore) {
            return false;
        }
    }

    public boolean performAction(Runnable action, String name, ConnectionStatusListener.ErrorProcessingKind showErrorMessagesKind) {
        return this.performAction(action, name, null, showErrorMessagesKind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performAction(final Runnable action, String name, @Nullable String cancelText, ConnectionStatusListener.ErrorProcessingKind showErrorMessagesKind) {
        Thread current = Thread.currentThread();
        this.incCurrentLevel(current);
        try {
            boolean dispatchThread = this.myIde.isDispatchThread();
            if (dispatchThread) {
                final Throwable[] ex = new Throwable[1];
                boolean completed = this.myProcessExecutor.runProcessWithProgressSynchronously(new Runnable(){

                    @Override
                    public void run() {
                        Thread currentInProgress = Thread.currentThread();
                        TeamCityProcessManager.this.incCurrentLevel(currentInProgress);
                        try {
                            action.run();
                        }
                        catch (Throwable e) {
                            ex[0] = e;
                        }
                        finally {
                            TeamCityProcessManager.this.decCurrentLevel(currentInProgress);
                        }
                    }
                }, name, true, cancelText);
                if (!completed) {
                    boolean bl = false;
                    return bl;
                }
                Throwable throwable = ex[0];
                this.processException(throwable, showErrorMessagesKind, name, this.getCurrentFacade());
                boolean bl = throwable == null;
                return bl;
            }
            action.run();
            this.processException(null, showErrorMessagesKind, name, this.getCurrentFacade());
            boolean ex = true;
            return ex;
        }
        finally {
            TeamCityProcessManager teamCityProcessManager = this;
            synchronized (teamCityProcessManager) {
                this.myCurrentFacades.remove(current);
            }
            this.decCurrentLevel(current);
        }
    }

    private synchronized RemoteBuildServerFacade getCurrentFacade() {
        return this.myCurrentFacades.get(Thread.currentThread());
    }

    public synchronized void registerCurrentFacade(RemoteBuildServerFacade facade) {
        Thread current = Thread.currentThread();
        this.myCurrentFacades.put(current, facade);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decCurrentLevel(Thread current) {
        TeamCityProcessManager teamCityProcessManager = this;
        synchronized (teamCityProcessManager) {
            Integer currentLevel = this.myThreadLevels.get(current);
            if (currentLevel != null) {
                if (currentLevel == 0) {
                    this.myThreadLevels.remove(current);
                    this.LOG.warn((Object)"Unexpected zero value");
                } else {
                    Integer newValue = currentLevel - 1;
                    this.myThreadLevels.put(current, newValue);
                    if (newValue == 0) {
                        this.myThreadLevels.remove(current);
                    }
                }
            } else {
                this.LOG.warn((Object)"Unexpected null value");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incCurrentLevel(Thread current) {
        TeamCityProcessManager teamCityProcessManager = this;
        synchronized (teamCityProcessManager) {
            Integer currentLevel = this.myThreadLevels.get(current);
            Integer newValue = currentLevel == null ? 1 : currentLevel + 1;
            this.myThreadLevels.put(current, newValue);
        }
    }

    private void processException(@Nullable Throwable throwable, ConnectionStatusListener.ErrorProcessingKind showErrorMessagesKind, String name, RemoteBuildServerFacade facade) {
        String message;
        if (throwable != null && (message = throwable.getLocalizedMessage()) != null) {
            for (String invalidState : ourInvalidServerStates) {
                if (!message.contains(invalidState)) continue;
                this.LOG.debug((Object)message, throwable);
                String description = message.substring(message.lastIndexOf(invalidState) + invalidState.length()).trim();
                if (showErrorMessagesKind == ConnectionStatusListener.ErrorProcessingKind.SHOW_MESSAGE) {
                    this.myIde.showInfoMessage("Cannot perform operation: " + description, name);
                } else if (showErrorMessagesKind == ConnectionStatusListener.ErrorProcessingKind.RETHROW) {
                    throw new InvalidServerStateException(description);
                }
                return;
            }
        }
        if (throwable instanceof AuthenticationFailedException) {
            ((ConnectionStatusListener)this.myDispatcher.getMulticaster()).onAuthenticationFailed(throwable, showErrorMessagesKind);
            if (showErrorMessagesKind == ConnectionStatusListener.ErrorProcessingKind.RETHROW) {
                throw (AuthenticationFailedException)throwable;
            }
        } else if (TeamCityProcessManager.isIncompatibleVersionException(throwable)) {
            this.processIncompatiblePluginError((IncompatiblePluginError)ExceptionUtil.getCause((Throwable)throwable, IncompatiblePluginError.class), showErrorMessagesKind, facade);
        } else if (TeamCityProcessManager.isConnectException(throwable)) {
            this.processConnectException(throwable, showErrorMessagesKind, new RemoteCallException("Connect problem", ExceptionUtil.getCause((Throwable)throwable, IOException.class)));
        } else if (throwable != null && throwable.getLocalizedMessage() != null && throwable.getLocalizedMessage().contains(ACCESS_DENIED_EXCEPTION_PREFIX)) {
            if (showErrorMessagesKind == ConnectionStatusListener.ErrorProcessingKind.SHOW_MESSAGE) {
                this.myIde.showInfoMessage("Cannot perform operation (access denied): " + ExceptionUtil.getDisplayMessage((Throwable)throwable), name);
            } else if (showErrorMessagesKind == ConnectionStatusListener.ErrorProcessingKind.RETHROW) {
                message = ExceptionUtil.getDisplayMessage((Throwable)throwable).trim();
                if (message.startsWith(ACCESS_DENIED_EXCEPTION_PREFIX)) {
                    message = message.substring(ACCESS_DENIED_EXCEPTION_PREFIX.length()).trim();
                }
                throw (AccessDeniedException)new AccessDeniedException(null, message).initCause(throwable);
            }
        } else if (throwable != null) {
            if (showErrorMessagesKind == ConnectionStatusListener.ErrorProcessingKind.SHOW_MESSAGE) {
                this.LOG.debug((Object)("Cannot perform operation: " + throwable.toString()), throwable);
                this.myIde.showInfoMessage("Cannot perform operation: " + ExceptionUtil.getDisplayMessage((Throwable)throwable), name);
            } else {
                if (showErrorMessagesKind == ConnectionStatusListener.ErrorProcessingKind.RETHROW) {
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    throw new RuntimeException(throwable);
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                this.LOG.debug((Object)throwable.toString(), throwable);
            }
        } else {
            ((ConnectionStatusListener)this.myDispatcher.getMulticaster()).onConnectionSuccessful();
        }
    }

    private void processIncompatiblePluginError(IncompatiblePluginError throwable, ConnectionStatusListener.ErrorProcessingKind showErrorMessagesKind, RemoteBuildServerFacade facade) {
        ((ConnectionStatusListener)this.myDispatcher.getMulticaster()).onIncompatibleVersion(throwable, showErrorMessagesKind, facade);
        if (showErrorMessagesKind == ConnectionStatusListener.ErrorProcessingKind.RETHROW) {
            throw throwable;
        }
    }

    private void processConnectException(Throwable throwable, ConnectionStatusListener.ErrorProcessingKind showErrorMessagesKind, RemoteCallException original) {
        ((ConnectionStatusListener)this.myDispatcher.getMulticaster()).onConnectException(throwable, showErrorMessagesKind);
        this.LOG.debug((Object)"Connect exception: ", throwable);
        if (showErrorMessagesKind == ConnectionStatusListener.ErrorProcessingKind.RETHROW) {
            throw original;
        }
    }

    private static boolean isConnectException(@Nullable Throwable throwable) {
        return ExceptionUtil.getCause((Throwable)throwable, IOException.class) != null;
    }

    private static boolean isIncompatibleVersionException(@Nullable Throwable throwable) {
        return ExceptionUtil.getCause((Throwable)throwable, IncompatiblePluginError.class) != null;
    }

    public EventDispatcher<ConnectionStatusListener> getDispatcher() {
        return this.myDispatcher;
    }
}

