/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import java.io.Reader;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import jetbrains.buildServer.BuildProject;
import jetbrains.buildServer.ConnectionStatusListener;
import jetbrains.buildServer.ExceptionUtil;
import jetbrains.buildServer.FakeRootProject;
import jetbrains.buildServer.Ide;
import jetbrains.buildServer.IdeAlarm;
import jetbrains.buildServer.IdeSettings;
import jetbrains.buildServer.IncompatiblePluginError;
import jetbrains.buildServer.LastFinishedBuildsManager;
import jetbrains.buildServer.ProcessExecutor;
import jetbrains.buildServer.StateChangedEvent;
import jetbrains.buildServer.StateChangedListener;
import jetbrains.buildServer.SummaryListener;
import jetbrains.buildServer.TeamCityProcessManager;
import jetbrains.buildServer.TeamCityState;
import jetbrains.buildServer.TeamServerSummary;
import jetbrains.buildServer.TeamServerSummaryProvider;
import jetbrains.buildServer.Used;
import jetbrains.buildServer.delayedCommit.PersonalBuildsSnapshot;
import jetbrains.buildServer.log.LogUtil;
import jetbrains.buildServer.login.LoginCallback;
import jetbrains.buildServer.login.LoginResult;
import jetbrains.buildServer.messages.Status;
import jetbrains.buildServer.notification.NotificationMessage;
import jetbrains.buildServer.serverMessages.FinishedBuildListener;
import jetbrains.buildServer.serverMessages.NotificationListener;
import jetbrains.buildServer.serverMessages.PersonalChangeProcessor;
import jetbrains.buildServer.serverMessages.UserLoginListener;
import jetbrains.buildServer.serverProxy.ProjectsProvider;
import jetbrains.buildServer.serverProxy.ProxyFactory;
import jetbrains.buildServer.serverProxy.RemoteBuildServerFacade;
import jetbrains.buildServer.serverProxy.RemoteFacadeListener;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.serverSide.auth.AuthenticationFailedException;
import jetbrains.buildServer.tree.runningBuilds.RunningBuildsHolder;
import jetbrains.buildServer.users.User;
import jetbrains.buildServer.users.UserData;
import jetbrains.buildServer.util.Dates;
import jetbrains.buildServer.util.EventDispatcher;
import jetbrains.buildServer.util.ExponentialBackoffHelper;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.SystemTimeService;
import jetbrains.buildServer.util.TimeService;
import jetbrains.buildServer.util.filters.Filter;
import jetbrains.buildServer.util.filters.FilterUtil;
import jetbrains.buildServer.xmlrpc.RemoteCallException;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeamCitySnapshot
implements ConnectionStatusListener,
ProjectsProvider {
    private static final Comparator<NotificationMessage> NOTIFICATION_MESSAGES_COMPARATOR = new Comparator<NotificationMessage>(){

        @Override
        public int compare(NotificationMessage nm1, NotificationMessage nm2) {
            long diff = nm1.getModificationCounter() - nm2.getModificationCounter();
            return diff > 0L ? 1 : (diff < 0L ? -1 : 0);
        }
    };
    private static final int MAX_MESSAGE_COUNT_TO_SHOW_SIMULTANEOUSLY = 6;
    private final Runnable myCheckModificationsAction = new UpdateCurrentStatusAction();
    private TeamCityState myState = TeamCityState.getDefault();
    private RemoteBuildServerFacade myServerFacade;
    private TeamServerSummaryProviderImpl mySummaryProvider = TeamServerSummaryProviderImpl.access$100();
    private UserData myUser;
    private final Object myUpdateLock = new Object();
    private final Ide myIde;
    private final IdeSettings mySettings;
    private final TeamCityProcessManager myProcessManager;
    private final IdeAlarm myUpdateAlarm;
    private final IdeAlarm myModificationTrackerAlarm;
    private final PersonalBuildsSnapshot myPersonalSnapshot;
    private static final Logger LOG = Logger.getLogger(TeamCitySnapshot.class);
    private final EventDispatcher<FinishedBuildListener> myFinishedBuildDispatcher = EventDispatcher.create(FinishedBuildListener.class);
    private final EventDispatcher<NotificationListener> myNotificationDispatcher = EventDispatcher.create(NotificationListener.class);
    private final EventDispatcher<PersonalChangeProcessor> myPersonalBuildEventDispatcher = EventDispatcher.create(PersonalChangeProcessor.class);
    private final EventDispatcher<UserLoginListener> myUserLoginDispatcher = EventDispatcher.create(UserLoginListener.class);
    private final EventDispatcher<SummaryListener> mySummaryDispatcher = EventDispatcher.create(SummaryListener.class);
    private String myProblemDescription = null;
    private final RunningBuildsHolder myRunningBuildsHolder = new RunningBuildsHolder();
    private long myNotificationTimestamp = -1L;
    private boolean myWasLoggedOut = false;
    private Date myLastUpdatedDate = new Date();
    private final LastFinishedBuildsManager myLastFinishedBuildsManager;
    private final ExponentialBackoffHelper myConnectionHelper = new ExponentialBackoffHelper();
    private RemoteBuildServerFacade myLastCreatedFacade = null;
    private TimeService myTimeService = new SystemTimeService();
    private final ReentrantLock myRequestSummaryLock = new ReentrantLock();
    private final UpdateSummaryTracker myUpdateSummaryTracker = new UpdateSummaryTracker(this.myTimeService);
    private final Runnable emptyRunnable = new Runnable(){

        @Override
        public void run() {
        }
    };
    private final ArrayList<StateChangedListener> myStateListeners = new ArrayList();
    private Throwable myProblem;

    public TeamCitySnapshot(Ide ide, IdeSettings settings, ProcessExecutor processExecutor) {
        this.myIde = ide;
        this.myModificationTrackerAlarm = this.myIde.createAlarm();
        this.myUpdateAlarm = this.myIde.createAlarm();
        this.mySettings = settings;
        this.myProcessManager = new TeamCityProcessManager(ide, processExecutor);
        this.myPersonalSnapshot = new PersonalBuildsSnapshot(this);
        this.myPersonalSnapshot.getDispatcher().addListener(this.myPersonalBuildEventDispatcher.getMulticaster());
        this.myLastFinishedBuildsManager = new LastFinishedBuildsManager(this);
    }

    @Used(value="Eclipse")
    protected synchronized void clearAll() {
        this.mySummaryProvider = TeamServerSummaryProviderImpl.DEFAULT_PROVIDER;
        this.myUser = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateSummary() {
        block8: {
            if (this.myIde.isDisposed()) {
                LOG.info((Object)"IDE/Project is disposed, won't update anything");
                return;
            }
            try {
                LOG.debug((Object)("State: " + (Object)((Object)this.getState())));
                if (this.getState().canConnectToServer() && this.getServerFacade().getSession().getUserId() != null) {
                    this.doUpdateSummaryForLoggedUser();
                    break block8;
                }
                LOG.debug((Object)"Cannot connect or session has no user id specified");
                TeamCitySnapshot teamCitySnapshot = this;
                synchronized (teamCitySnapshot) {
                    this.myUser = null;
                }
            }
            finally {
                this.myIde.updateStatus();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateSummaryForLoggedUser() {
        UserData currentUser = this.findCurrentUser();
        LOG.debug((Object)("Current user: " + LogUtil.describe((Object)currentUser)));
        if (currentUser == null) {
            LOG.debug((Object)"Summary not requested: user is null");
            this.switchStateToLoggedOutBySystem();
            return;
        }
        TeamServerSummaryProviderImpl outdatedSummaryProvider = this.mySummaryProvider;
        LOG.debug((Object)"Requesting summary");
        try {
            boolean shouldNotifyUserLogin;
            TeamServerSummary summary = this.doFetchNewSummaryFromServer(currentUser);
            if (summary == null) {
                LOG.debug((Object)"Another fetch is in progress, skipping update");
                return;
            }
            this.myUpdateSummaryTracker.onSuccess();
            LOG.debug((Object)"Summary has been received");
            TeamServerSummaryProviderImpl provider = TeamServerSummaryProviderImpl.create(summary);
            assert (provider.isSummaryAvailable());
            this.setState(TeamCityState.LOGGED_IN);
            TeamCitySnapshot teamCitySnapshot = this;
            synchronized (teamCitySnapshot) {
                shouldNotifyUserLogin = !Comparing.equal((Object)this.myUser, (Object)currentUser);
                this.myUser = currentUser;
                this.mySummaryProvider = provider;
            }
            this.myIde.updateSummary(provider);
            ((SummaryListener)this.mySummaryDispatcher.getMulticaster()).updateSummary(provider);
            if (shouldNotifyUserLogin) {
                ((UserLoginListener)this.myUserLoginDispatcher.getMulticaster()).processLogin(currentUser);
            }
        }
        catch (Throwable e) {
            this.myUpdateSummaryTracker.onError();
            ExceptionUtil.log((Logger)LOG, (String)"Summary update failed", (Throwable)e);
            this.setProblem(e);
            if (e.getCause() instanceof SocketTimeoutException && outdatedSummaryProvider != null && outdatedSummaryProvider.isSummaryAvailable()) {
                LOG.warn((Object)"Attempt to continue with outdated summary");
                this.myUser = currentUser;
                TeamCitySnapshot teamCitySnapshot = this;
                synchronized (teamCitySnapshot) {
                    this.mySummaryProvider = outdatedSummaryProvider;
                }
            }
            this.switchStateToLoggedOutBySystem();
        }
    }

    @Nullable
    private TeamServerSummary doFetchNewSummaryFromServer(final @NotNull User user) throws Throwable {
        Collection<String> samplePaths;
        if (user == null) {
            TeamCitySnapshot.$$$reportNull$$$0(0);
        }
        if ((samplePaths = this.getSamplePaths()) == null) {
            LOG.info((Object)"Requesting full summary as there're no sample paths...");
        } else {
            LOG.info((Object)("Requesting partial summary as there're " + samplePaths.size() + " sample paths provided..."));
            LOG.debug((Object)("Sample paths: " + samplePaths));
        }
        final TeamServerSummary[] summary = new TeamServerSummary[1];
        final boolean[] inProgress = new boolean[1];
        this.myProcessManager.performAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!TeamCitySnapshot.this.myRequestSummaryLock.tryLock()) {
                    LOG.info((Object)"Summary update cancelled: another one is in progress");
                    inProgress[0] = true;
                    return;
                }
                try {
                    RemoteBuildServerFacade facade = TeamCitySnapshot.this.getServerFacade();
                    ProxyFactory proxyFactory = new ProxyFactory(facade);
                    proxyFactory.addListener(TeamCitySnapshot.this.myRunningBuildsHolder);
                    TeamCitySnapshot.this.myRunningBuildsHolder.onBeforeUpdate();
                    try {
                        summary[0] = facade.getSummary(user, samplePaths, proxyFactory);
                    }
                    finally {
                        TeamCitySnapshot.this.myRunningBuildsHolder.onAfterUpdate();
                    }
                }
                finally {
                    TeamCitySnapshot.this.myRequestSummaryLock.unlock();
                }
            }
        }, "Loading Data from Server", ConnectionStatusListener.ErrorProcessingKind.RETHROW);
        if (inProgress[0]) {
            return null;
        }
        assert (summary[0] != null);
        return summary[0];
    }

    @Nullable
    private Collection<String> getSamplePaths() {
        if (this.getSettings().isFilterSummaryByCurrentProject()) {
            LOG.debug((Object)"Filtering by current project is enabled.");
            try {
                return this.getIde().getSamplePaths();
            }
            catch (Exception e) {
                ExceptionUtil.log((Logger)LOG, (String)"Unable to collect sample paths to filter summary by current project", (Throwable)e);
                return null;
            }
        }
        LOG.debug((Object)"Filtering by current project is disabled.");
        return null;
    }

    @Nullable
    private UserData findCurrentUser() {
        final UserData[] user = new UserData[]{null};
        final Integer userId = this.getServerFacade().getSession().getUserId();
        try {
            this.myProcessManager.performAction(new Runnable(){

                @Override
                public void run() {
                    if (userId != null) {
                        user[0] = TeamCitySnapshot.this.getServerFacade().findUserById(userId.intValue());
                    }
                }
            }, "Find User", ConnectionStatusListener.ErrorProcessingKind.IGNORE);
        }
        catch (Throwable e) {
            ExceptionUtil.log((Logger)LOG, (String)("Cannot find user with id " + userId), (Throwable)e);
        }
        return user[0];
    }

    private synchronized void markSummaryAsOutdated() {
        this.mySummaryProvider.markAsOutdated();
    }

    private void switchStateToLoggedOutBySystem() {
        LOG.debug((Object)"Logout by system");
        this.updateLastUpdatedDate();
        if (this.getState().canConnectToServer()) {
            this.setState(TeamCityState.LOGGED_OUT_BY_SYSTEM);
        }
    }

    private synchronized void updateLastUpdatedDate() {
        this.myLastUpdatedDate = new Date();
    }

    public synchronized RemoteBuildServerFacade getServerFacade() {
        return this.myServerFacade;
    }

    public synchronized UserData getUser() {
        return this.myUser;
    }

    public synchronized void setUser(UserData user) {
        this.myUser = user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout(boolean callLogoutOnServer) {
        LOG.debug((Object)("Logout by user, logout on server: " + callLogoutOnServer));
        this.setState(TeamCityState.LOGGED_OUT_BY_USER);
        TeamCitySnapshot teamCitySnapshot = this;
        synchronized (teamCitySnapshot) {
            this.myUser = null;
        }
        final RemoteBuildServerFacade facade = this.getServerFacade();
        if (callLogoutOnServer) {
            this.myProcessManager.performSystemAction(new Runnable(){

                @Override
                public void run() {
                    facade.logout();
                }
            }, "Logout from server", ConnectionStatusListener.ErrorProcessingKind.SHOW_MESSAGE);
        }
        TeamCitySnapshot teamCitySnapshot2 = this;
        synchronized (teamCitySnapshot2) {
            this.myWasLoggedOut = true;
        }
        this.scheduleUpdate();
    }

    public void scheduleUpdate() {
        this.scheduleUpdate(false);
    }

    public void scheduleUpdate(boolean updateStatusImmediately) {
        this.doScheduleSummaryUpdate(100, false, updateStatusImmediately);
    }

    public void scheduleUpdate(boolean updateStatusImmediately, @NotNull Runnable afterAction) {
        if (afterAction == null) {
            TeamCitySnapshot.$$$reportNull$$$0(1);
        }
        this.doScheduleSummaryUpdate(100, false, updateStatusImmediately, afterAction);
    }

    public synchronized void refreshServerUrl() throws MalformedURLException {
        String oldValue = this.getServerUrl();
        String url = this.getSettings().getServerUrl();
        if (!Comparing.equal((String)url, (String)oldValue)) {
            this.updateFacade();
        }
    }

    private String getServerUrl() {
        return this.getServerFacade() != null ? this.getServerFacade().getServerUrl() : null;
    }

    private synchronized void updateFacade() throws MalformedURLException {
        String url = this.getSettings().getServerUrl();
        if (url != null) {
            if (this.myServerFacade != null) {
                this.myServerFacade.dispose();
                this.myServerFacade = null;
            }
            this.myServerFacade = this.getOrCreateServerFacade(url);
            this.myLastCreatedFacade = null;
        }
    }

    public RemoteBuildServerFacade getOrCreateServerFacade(@NotNull String url) throws MalformedURLException {
        RemoteBuildServerFacade facade;
        RemoteBuildServerFacade previous;
        if (url == null) {
            TeamCitySnapshot.$$$reportNull$$$0(2);
        }
        if ((previous = this.myLastCreatedFacade) == null) {
            previous = this.myServerFacade;
        }
        if (previous != null && Comparing.equal((String)previous.getServerUrl(), (String)url)) {
            facade = previous;
        } else {
            facade = this.createServerFacade(url);
            if (this.myLastCreatedFacade != null) {
                this.myLastCreatedFacade.dispose();
                this.myLastCreatedFacade = null;
            }
            this.myLastCreatedFacade = facade;
        }
        return facade;
    }

    protected RemoteBuildServerFacade createServerFacade(String url) throws MalformedURLException {
        RemoteBuildServerFacade facade = RemoteBuildServerFacade.createInstance(url, this.myIde.getUserAgent(), this.myIde.createApplicationFacade(), this.mySettings.getProxySettings(), this);
        facade.getDispatcher().addListener((EventListener)new RemoteFacadeListener(){

            @Override
            public void remoteCommandStarted(RemoteBuildServerFacade facade) {
                TeamCityProcessManager manager = TeamCitySnapshot.this.getProcessManager();
                if (!manager.isInsideCommand()) {
                    throw new RuntimeException("All server operations must be run inside TeamCityProcessManager command");
                }
                if (TeamCitySnapshot.this.myIde.isDispatchThread()) {
                    throw new RuntimeException("Dispatch thread not allowed here");
                }
                manager.registerCurrentFacade(facade);
            }

            @Override
            public void remoteCommandFinished(RemoteBuildServerFacade facade) {
            }
        });
        return facade;
    }

    @Override
    @NotNull
    public List<BuildProject> getAllProjects() {
        List<BuildProject> list = this.getSummaryProvider().getSummary().getAllProjects();
        if (list == null) {
            TeamCitySnapshot.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @Nullable
    public BuildProject findProjectById(@Nullable String projectId) {
        return this.getSummaryProvider().getSummary().findProjectById(projectId, true);
    }

    @NotNull
    public synchronized TeamServerSummaryProvider getSummaryProvider() {
        TeamServerSummaryProviderImpl teamServerSummaryProviderImpl = this.mySummaryProvider;
        if (teamServerSummaryProviderImpl == null) {
            TeamCitySnapshot.$$$reportNull$$$0(4);
        }
        return teamServerSummaryProviderImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdateRequestSynchronously(@NotNull Runnable runnable) {
        if (runnable == null) {
            TeamCitySnapshot.$$$reportNull$$$0(5);
        }
        this.cancelUpdateRequests();
        Object object = this.myUpdateLock;
        synchronized (object) {
            try {
                runnable.run();
            }
            finally {
                if (!this.myIde.isDisposed()) {
                    this.scheduleUpdate();
                }
            }
        }
    }

    protected void cancelUpdateRequests() {
        LOG.debug((Object)"Cancel update requests...");
        this.myUpdateAlarm.cancelAllRequests();
    }

    public void addUpdateRequest(final @NotNull Runnable runnable, int delay) {
        if (runnable == null) {
            TeamCitySnapshot.$$$reportNull$$$0(6);
        }
        LOG.debug((Object)("Adding update request, delay: " + delay));
        this.myUpdateAlarm.addRequest(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = TeamCitySnapshot.this.myUpdateLock;
                synchronized (object) {
                    runnable.run();
                }
            }
        }, delay, "Update Summary");
    }

    public LoginResult authorize(String url, final String user, final char[] password) throws MalformedURLException, ConnectException, AuthenticationFailedException, ProcessCanceledException {
        try {
            final RemoteBuildServerFacade facade = this.getOrCreateServerFacade(url);
            final UserData[] result = new UserData[]{null};
            try {
                this.myProcessManager.performAction(new Runnable(){

                    @Override
                    public void run() {
                        if (user == null) {
                            throw new AuthenticationFailedException("User not specified");
                        }
                        if (password == null || password.length == 0) {
                            throw new AuthenticationFailedException("Password not specified");
                        }
                        String pswd = new String(password);
                        result[0] = facade.checkPassword(user, pswd);
                    }
                }, "Login", ConnectionStatusListener.ErrorProcessingKind.RETHROW);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (IncompatiblePluginError e) {
                throw e;
            }
            catch (AuthenticationFailedException e) {
                throw e;
            }
            catch (Throwable e) {
                RemoteCallException callException;
                Throwable cause2;
                Throwable cause = e.getCause();
                if (cause instanceof ConnectException) {
                    throw (ConnectException)cause;
                }
                if (cause instanceof RemoteCallException && (cause2 = (callException = (RemoteCallException)cause).getCause()) instanceof ConnectException) {
                    throw (ConnectException)cause2;
                }
                if (cause instanceof AuthenticationFailedException) {
                    throw (AuthenticationFailedException)cause;
                }
                throw ExceptionUtil.createRuntimeException(e);
            }
            if (result[0] == null) {
                throw new AuthenticationFailedException("No result returned from authorization request");
            }
            return new LoginResult(facade.getSession(), result[0], url, facade.getServerBuildNumber());
        }
        catch (MalformedURLException e) {
            throw new AuthenticationFailedException("Malformed URL: " + url);
        }
    }

    public TeamCityProcessManager getProcessManager() {
        return this.myProcessManager;
    }

    @NotNull
    public static TeamServerSummaryProvider getDefaultSummaryProvider() {
        TeamServerSummaryProviderImpl teamServerSummaryProviderImpl = TeamServerSummaryProviderImpl.DEFAULT_PROVIDER;
        if (teamServerSummaryProviderImpl == null) {
            TeamCitySnapshot.$$$reportNull$$$0(7);
        }
        return teamServerSummaryProviderImpl;
    }

    public void init() {
        this.getProcessManager().getDispatcher().addListener((EventListener)this);
        try {
            this.updateFacade();
        }
        catch (MalformedURLException e) {
            LOG.warn((Object)e.toString());
            LOG.debug((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void tryToRelogin(final boolean invokeManualIfFailed) {
        final String url = this.getSettings().getServerUrl();
        if (url == null) {
            this.myIde.updateStatus();
            return;
        }
        final String login = this.getSettings().getLogin();
        if (login == null) {
            this.myIde.updateStatus();
            return;
        }
        final char[] password = this.getSettings().getPassword();
        if (password == null || password.length == 0) {
            this.myIde.updateStatus();
            return;
        }
        this.doScheduleSummaryUpdateRequest(10, new Runnable(){

            @Override
            public void run() {
                try {
                    TeamCitySnapshot.this.setState(TeamCityState.LOGGING_IN);
                    TeamCitySnapshot.this.myIde.updateStatus();
                    LoginResult loginResult = TeamCitySnapshot.this.authorize(url, login, password);
                    TeamCitySnapshot.this.login(loginResult);
                }
                catch (ConnectException e) {
                    TeamCitySnapshot.this.onConnectException(e, ConnectionStatusListener.ErrorProcessingKind.IGNORE);
                }
                catch (AuthenticationFailedException e) {
                    TeamCitySnapshot.this.onAuthenticationFailed(e, ConnectionStatusListener.ErrorProcessingKind.IGNORE);
                    if (invokeManualIfFailed) {
                        TeamCitySnapshot.this.myIde.invokeManualLogin("TeamCity autologin failed: " + ExceptionUtil.getDisplayMessage((Throwable)e));
                    }
                }
                catch (IncompatiblePluginError e) {
                    try {
                        RemoteBuildServerFacade facade = TeamCitySnapshot.this.getOrCreateServerFacade(url);
                        facade.setServerBuildVersion(e.getServerBuildNumber());
                        TeamCitySnapshot.this.onIncompatibleVersion(e, ConnectionStatusListener.ErrorProcessingKind.IGNORE, facade);
                    }
                    catch (MalformedURLException e1) {
                        if (invokeManualIfFailed) {
                            TeamCitySnapshot.this.myIde.invokeManualLogin("TeamCity autologin failed: " + ExceptionUtil.getDisplayMessage((Throwable)e1));
                        }
                    }
                }
                catch (Throwable e) {
                    TeamCitySnapshot.this.onConnectException(e, ConnectionStatusListener.ErrorProcessingKind.IGNORE);
                }
            }
        }, null, true);
    }

    public void doInitialLogin() {
        this.tryToRelogin(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void login(LoginResult loginResult) {
        boolean shouldNotifyUserLogin;
        TeamCitySnapshot teamCitySnapshot = this;
        synchronized (teamCitySnapshot) {
            shouldNotifyUserLogin = !Comparing.equal((Object)this.myUser, (Object)loginResult.getUser());
            this.myUser = loginResult.getUser();
            this.getServerFacade().setSession(loginResult.getSession(), loginResult.getUrl(), loginResult.getServerBuildNumber());
        }
        this.doScheduleSummaryUpdate(10, shouldNotifyUserLogin);
    }

    public void dispose() {
        this.myProcessManager.getDispatcher().removeListener((EventListener)this);
        this.myFinishedBuildDispatcher.dispose();
        this.myNotificationDispatcher.dispose();
        this.myPersonalBuildEventDispatcher.dispose();
        this.myUserLoginDispatcher.dispose();
        this.mySummaryDispatcher.dispose();
        this.myPersonalSnapshot.getDispatcher().dispose();
        this.myUpdateAlarm.dispose();
        this.myModificationTrackerAlarm.dispose();
        this.myLastFinishedBuildsManager.dispose();
        if (this.myServerFacade != null) {
            this.myServerFacade.dispose();
        }
        this.myServerFacade = null;
        if (this.myLastCreatedFacade != null) {
            this.myLastCreatedFacade.dispose();
        }
        this.myLastCreatedFacade = null;
    }

    public LoginCallback createLoginCallback() {
        return new LoginCallback(){

            @Override
            public void successfullyLogged(LoginResult loginResult) {
                TeamCitySnapshot.this.login(loginResult);
                TeamCitySnapshot.this.setState(TeamCityState.LOGGED_IN);
            }

            @Override
            public void loginCanceled() {
            }

            @Override
            public void loginFailed(Throwable ex, RemoteBuildServerFacade facade) {
            }
        };
    }

    public void setIsLoggingIn() {
        this.setState(TeamCityState.LOGGING_IN);
    }

    public Ide getIde() {
        return this.myIde;
    }

    public PersonalBuildsSnapshot getPersonalSnapshot() {
        return this.myPersonalSnapshot;
    }

    public synchronized Date getLastStateUpdatedDate() {
        return this.myLastUpdatedDate;
    }

    private void doScheduleSummaryUpdate(int delay, boolean shouldNotifyUserLogin) {
        this.doScheduleSummaryUpdate(delay, shouldNotifyUserLogin, false);
    }

    private void doScheduleSummaryUpdate(int delay, boolean shouldNotifyUserLogin, boolean updateStatusImmediately) {
        this.doScheduleSummaryUpdate(delay, shouldNotifyUserLogin, updateStatusImmediately, this.emptyRunnable);
    }

    private void doScheduleSummaryUpdate(int delay, final boolean shouldNotifyUserLogin, boolean updateStatusImmediately, final @NotNull Runnable afterAction) {
        if (afterAction == null) {
            TeamCitySnapshot.$$$reportNull$$$0(8);
        }
        LOG.debug((Object)("Schedule summary update for " + delay + " milliseconds"));
        Runnable after = new Runnable(){

            @Override
            public void run() {
                if (shouldNotifyUserLogin) {
                    ((UserLoginListener)TeamCitySnapshot.this.getUserLoginDispatcher().getMulticaster()).processLogin(TeamCitySnapshot.this.getUser());
                }
                afterAction.run();
            }
        };
        this.doScheduleSummaryUpdateRequest(delay, null, after, updateStatusImmediately);
    }

    private void doScheduleSummaryUpdateRequest(int delay, @Nullable Runnable beforeAction, @Nullable Runnable afterAction, boolean updateStatusImmediately) {
        int updatedDelay = this.myUpdateSummaryTracker.getDelayBeforeAnotherAttempt(delay);
        if (delay != updatedDelay) {
            LOG.debug((Object)("Adding update summary request, delay: " + updatedDelay + " ms. Increased from " + delay + " ms due to failures during previous attempts"));
        } else {
            LOG.debug((Object)("Adding update summary request, delay: " + delay + " ms."));
        }
        this.cancelUpdateRequests();
        this.addUpdateRequest(new UpdateServerDataRequest(beforeAction, afterAction, updateStatusImmediately), updatedDelay);
    }

    private void processMessagesSincePreviousUpdate(TeamServerSummary currentState) {
        RemoteBuildServerFacade facade = this.getServerFacade();
        if (facade == null) {
            LOG.error((Object)"Cannot process messages since previous update: RemoteBuildServerFacade is unexpectedly null");
            return;
        }
        UserData user = this.getUser();
        if (user == null) {
            LOG.error((Object)"Cannot process messages since previous update: User is unexpectedly null");
            return;
        }
        this.myPersonalSnapshot.newSnapshotAvailable(currentState.getPersonalChanges(), facade.getServerUrl(), user.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConnectException(Throwable exception, ConnectionStatusListener.ErrorProcessingKind showErrorMessagesKind) {
        LOG.debug((Object)"Connect exception", exception);
        this.setProblem(exception);
        this.updateLastUpdatedDate();
        TeamCitySnapshot teamCitySnapshot = this;
        synchronized (teamCitySnapshot) {
            this.myUser = null;
            this.mySummaryProvider = TeamServerSummaryProviderImpl.DEFAULT_PROVIDER;
        }
        if (showErrorMessagesKind == ConnectionStatusListener.ErrorProcessingKind.SHOW_MESSAGE) {
            // empty if block
        }
        if (this.getState() != TeamCityState.SERVER_UNAVAILABLE) {
            this.setState(TeamCityState.SERVER_UNAVAILABLE);
            if (showErrorMessagesKind != ConnectionStatusListener.ErrorProcessingKind.SHOW_MESSAGE) {
                // empty if block
            }
        }
        this.myIde.updateStatus();
        this.handleCollision();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onIncompatibleVersion(IncompatiblePluginError incompatiblePluginError, ConnectionStatusListener.ErrorProcessingKind showErrorMessagesKind, RemoteBuildServerFacade facade) {
        LOG.debug((Object)"Incompatible version", (Throwable)incompatiblePluginError);
        this.setProblem(incompatiblePluginError);
        this.myConnectionHelper.reset();
        this.updateLastUpdatedDate();
        TeamCitySnapshot teamCitySnapshot = this;
        synchronized (teamCitySnapshot) {
            this.myUser = null;
        }
        if (this.getState() != TeamCityState.INCOMPATIBLE_VERSION) {
            this.setState(TeamCityState.INCOMPATIBLE_VERSION);
            this.myIde.showIncompatibleVersionProblemMessage(facade, incompatiblePluginError);
        }
        this.myIde.updateStatus();
    }

    @Override
    public void onConnectionSuccessful() {
        LOG.debug((Object)"Connection successful");
        this.setProblem(null);
        this.myConnectionHelper.reset();
        this.updateLastUpdatedDate();
        if (!this.getState().canConnectToServer() && this.getState().wantConnectToServer()) {
            this.tryToRelogin(false);
        } else {
            this.myIde.updateStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAuthenticationFailed(Throwable e, ConnectionStatusListener.ErrorProcessingKind showErrorMessagesKind) {
        LOG.debug((Object)"Authentication failed", e);
        this.setProblem(e);
        this.myConnectionHelper.reset();
        this.updateLastUpdatedDate();
        TeamCitySnapshot teamCitySnapshot = this;
        synchronized (teamCitySnapshot) {
            this.myUser = null;
        }
        if (this.getState() != TeamCityState.AUTHENTICATION_FAILED) {
            if (showErrorMessagesKind == ConnectionStatusListener.ErrorProcessingKind.SHOW_MESSAGE) {
                this.myIde.showInfoMessage("Authentication failed: " + ExceptionUtil.getDisplayMessage((Throwable)e), "TeamCity Login Failed");
            }
            this.setState(TeamCityState.AUTHENTICATION_FAILED);
        }
        this.myIde.updateStatus();
    }

    @NotNull
    public synchronized TeamCityState getState() {
        TeamCityState teamCityState = this.myState;
        if (teamCityState == null) {
            TeamCitySnapshot.$$$reportNull$$$0(9);
        }
        return teamCityState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(@NotNull TeamCityState state) {
        TeamCityState old;
        if (state == null) {
            TeamCitySnapshot.$$$reportNull$$$0(10);
        }
        TeamCitySnapshot teamCitySnapshot = this;
        synchronized (teamCitySnapshot) {
            LOG.debug((Object)("Change state: was " + this.myState.name() + ", now " + state.name()));
            this.updateLastUpdatedDate();
            old = this.myState;
            this.myState = state;
        }
        if (!old.equals((Object)state)) {
            this.notifyStateListeners(old, state);
        }
    }

    private void pingServer() {
        this.myProcessManager.performSystemAction(new Runnable(){

            @Override
            public void run() {
                TeamCitySnapshot.this.getServerFacade().pingServer();
            }
        }, "Ping Server", ConnectionStatusListener.ErrorProcessingKind.RETHROW);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadNewNotifications() {
        boolean wasLoggedOut;
        final ArrayList<NotificationMessage> messages = new ArrayList<NotificationMessage>();
        this.myProcessManager.performSystemAction(new Runnable(){

            @Override
            public void run() {
                if (TeamCitySnapshot.this.myNotificationTimestamp == -1L) {
                    TeamCitySnapshot.this.myNotificationTimestamp = TeamCitySnapshot.this.getServerFacade().getCurrentNotificationTimestamp();
                } else {
                    UserData user = TeamCitySnapshot.this.getUser();
                    if (user != null) {
                        messages.addAll(TeamCitySnapshot.this.getServerFacade().getNotifications(user, TeamCitySnapshot.this.myNotificationTimestamp));
                    }
                }
            }
        }, "Loading Data from Server", ConnectionStatusListener.ErrorProcessingKind.RETHROW);
        this.filterNotificationsIfNeeded(messages);
        Collections.sort(messages, NOTIFICATION_MESSAGES_COMPARATOR);
        this.updateNotificationTimestamp(messages);
        Set<Long> obsoleteNotificationIds = TeamCitySnapshot.collectObsoleteNotificationIds(messages);
        TeamCitySnapshot teamCitySnapshot = this;
        synchronized (teamCitySnapshot) {
            wasLoggedOut = this.myWasLoggedOut;
            this.myWasLoggedOut = false;
        }
        if (wasLoggedOut) {
            this.dispatchImportantNotificationMessages(messages, obsoleteNotificationIds);
        } else {
            this.dispatchNotificationMessages(messages, obsoleteNotificationIds);
        }
    }

    private void filterNotificationsIfNeeded(ArrayList<NotificationMessage> messages) {
        TeamServerSummaryProvider summaryProvider = this.getSummaryProvider();
        if (summaryProvider.isSummaryAvailable()) {
            final TeamServerSummary summary = summaryProvider.getSummary();
            FilterUtil.filterArrayList(messages, (Filter)new Filter<NotificationMessage>(){

                public boolean accept(@NotNull NotificationMessage message) {
                    if (message == null) {
                        14.$$$reportNull$$$0(0);
                    }
                    return message.isImportant() || summary.findProjectById(message.getProjectId(), true) != null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "jetbrains/buildServer/TeamCitySnapshot$14", "accept"));
                }
            });
        }
    }

    void updateNotificationTimestamp(List<NotificationMessage> messages) {
        if (!messages.isEmpty()) {
            this.myNotificationTimestamp = messages.get(messages.size() - 1).getModificationCounter();
        }
    }

    @NotNull
    private static Set<Long> collectObsoleteNotificationIds(List<NotificationMessage> messages) {
        HashMap<Long, ArrayList<NotificationMessage>> notificationsByBuild = new HashMap<Long, ArrayList<NotificationMessage>>();
        for (NotificationMessage message : messages) {
            long buildId = message.getBuildId();
            if (buildId < 0L) continue;
            ArrayList<NotificationMessage> buildNotifications = (ArrayList<NotificationMessage>)notificationsByBuild.get(buildId);
            if (buildNotifications == null) {
                buildNotifications = new ArrayList<NotificationMessage>();
                notificationsByBuild.put(buildId, buildNotifications);
            }
            buildNotifications.add(message);
        }
        HashSet<Long> result = new HashSet<Long>();
        for (List buildNotifications : notificationsByBuild.values()) {
            int obsoleteCount = buildNotifications.size() - 1;
            for (int i = 0; i < obsoleteCount; ++i) {
                result.add(((NotificationMessage)buildNotifications.get(i)).getModificationCounter());
            }
        }
        HashSet<Long> hashSet = result;
        if (hashSet == null) {
            TeamCitySnapshot.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    void dispatchImportantNotificationMessages(List<NotificationMessage> messages, Set<Long> obsoleteNotificationIds) {
        long threshold = new Date().getTime() - Dates.ONE_DAY;
        for (NotificationMessage message : messages) {
            if (!message.isImportant() || message.getTime() <= threshold || obsoleteNotificationIds.contains(message.getModificationCounter())) continue;
            ((NotificationListener)this.myNotificationDispatcher.getMulticaster()).onMessageReceived(message, false);
        }
    }

    void dispatchNotificationMessages(List<NotificationMessage> messages, Set<Long> obsoleteNotificationIds) {
        int count = messages.size();
        int majorCount = 0;
        for (NotificationMessage message : messages) {
            if (!message.isImportant() || obsoleteNotificationIds.contains(message.getModificationCounter())) continue;
            ++majorCount;
        }
        int obsoleteCount = obsoleteNotificationIds.size();
        int minorCount = count - majorCount - obsoleteCount;
        int minorSilentCount = majorCount < 6 ? count - obsoleteCount + 1 - 6 : minorCount;
        if (minorSilentCount == 1) {
            minorSilentCount = 0;
        }
        int minorIndex = 0;
        for (int i = 0; i < count; ++i) {
            NotificationMessage message = messages.get(i);
            if (obsoleteNotificationIds.contains(message.getModificationCounter())) {
                ((NotificationListener)this.myNotificationDispatcher.getMulticaster()).onMessageReceived(message, true);
                continue;
            }
            if (message.isImportant()) {
                ((NotificationListener)this.myNotificationDispatcher.getMulticaster()).onMessageReceived(message, false);
                continue;
            }
            ((NotificationListener)this.myNotificationDispatcher.getMulticaster()).onMessageReceived(message, minorIndex++ < minorSilentCount);
        }
        if (minorSilentCount > 0) {
            ((NotificationListener)this.myNotificationDispatcher.getMulticaster()).onSystemMessage(String.format("%d more notifications were received from TeamCity", minorSilentCount + obsoleteCount));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateStatus(Ref<Boolean> updateScheduled) {
        TeamServerSummaryProvider summaryProvider = this.getSummaryProvider();
        LOG.debug((Object)("Summary available: " + summaryProvider.isSummaryAvailable()));
        LOG.debug((Object)("Summary is up to date: " + summaryProvider.isSummaryUpToDate()));
        LOG.debug((Object)("UI is visible: " + this.getIde().isUIVisible()));
        if (summaryProvider.isSummaryAvailable() && (summaryProvider.isSummaryUpToDate() || this.getIde().isUIVisible())) {
            final TeamServerSummary summary = summaryProvider.getSummary();
            int localCounter = summary.getSummaryCounter();
            final int[] serverCounter = new int[]{0};
            final ArrayList<String> runningBuildXmls = new ArrayList<String>();
            LOG.debug((Object)"Update request...");
            this.myProcessManager.performAction(new Runnable(){

                @Override
                public void run() {
                    UserData user = TeamCitySnapshot.this.getUser();
                    if (TeamCitySnapshot.this.getIde().isUIVisible()) {
                        if (user == null) {
                            runningBuildXmls.addAll(TeamCitySnapshot.this.getServerFacade().getRunningBuildInfoList());
                        } else {
                            Set<String> paths = TeamCitySnapshot.this.getSamplePaths();
                            runningBuildXmls.addAll(TeamCitySnapshot.this.getServerFacade().getRunningBuildInfoList(user.getId(), paths != null, paths != null ? paths : Collections.emptySet()));
                        }
                    }
                    if (user != null) {
                        serverCounter[0] = TeamCitySnapshot.this.getServerFacade().getTotalNumberOfEvents(summary.createSubscription(user));
                    }
                }
            }, "Loading Data from Server", ConnectionStatusListener.ErrorProcessingKind.RETHROW);
            this.myRunningBuildsHolder.updateFrom(TeamCitySnapshot.createXmlElements(runningBuildXmls));
            LOG.debug((Object)("Local counter: " + localCounter));
            LOG.debug((Object)("Server counter: " + serverCounter[0]));
            if (serverCounter[0] != localCounter) {
                LOG.debug((Object)"Event counter changed");
                if (this.getIde().isUIVisible()) {
                    try {
                        LOG.debug((Object)"Reload TeamCity summary");
                        this.scheduleUpdate();
                    }
                    finally {
                        updateScheduled.set((Object)true);
                    }
                } else {
                    LOG.debug((Object)"Mark TeamCity summary as outdated");
                    this.markSummaryAsOutdated();
                }
            } else if (this.getIde().isUIVisible()) {
                this.myIde.updateStatus();
            }
        } else if (this.hasNewCommitDecisions()) {
            try {
                LOG.debug((Object)"Reload TeamCity summary");
                this.scheduleUpdate();
            }
            finally {
                updateScheduled.set((Object)true);
            }
        } else {
            this.myIde.updateStatus();
        }
    }

    private boolean hasNewCommitDecisions() {
        final List<String> changeIds = this.myPersonalSnapshot.getActiveSessionChangeIds();
        if (changeIds.isEmpty()) {
            return false;
        }
        final Ref result = new Ref((Object)false);
        this.getProcessManager().performSystemAction(new Runnable(){

            @Override
            public void run() {
                result.set((Object)TeamCitySnapshot.this.getServerFacade().haveCommitDecision(changeIds));
            }
        }, "Check personal sessions status", ConnectionStatusListener.ErrorProcessingKind.IGNORE);
        return (Boolean)result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Element> createXmlElements(List<String> runningBuildXmls) {
        ArrayList<Element> result = new ArrayList<Element>();
        StringBuilder builder = new StringBuilder();
        builder.append("<root>");
        for (String runningBuildXml : runningBuildXmls) {
            builder.append(runningBuildXml);
        }
        builder.append("</root>");
        try (StringReader reader = new StringReader(builder.toString());){
            Element root = FileUtil.parseDocument((Reader)reader, (boolean)false);
            for (Object elObj : root.getChildren("build")) {
                result.add((Element)elObj);
            }
        }
        return result;
    }

    public RunningBuildsHolder getRunningBuildsHolder() {
        return this.myRunningBuildsHolder;
    }

    private void handleCollision() {
        this.addModificationTrackerAlarm(this.myConnectionHelper.computeDelayForCollision(TeamCitySnapshot.getStatusUpdateInterval()));
    }

    void addModificationTrackerAlarm() {
        this.addModificationTrackerAlarm(TeamCitySnapshot.getStatusUpdateInterval());
    }

    private static int getStatusUpdateInterval() {
        return TeamCityProperties.getInteger((String)"teamcity.ideaplugin.status.update.interval.seconds", (int)10) * 1000;
    }

    void addModificationTrackerAlarm(int delay) {
        LOG.debug((Object)"Scheduling status update...");
        LOG.debug((Object)("Delay = " + delay + " milliseconds"));
        this.myModificationTrackerAlarm.cancelAllRequests();
        this.myModificationTrackerAlarm.addRequest(this.myCheckModificationsAction, delay, "Check for Modifications");
    }

    protected IdeAlarm getModificationTrackerAlarm() {
        return this.myModificationTrackerAlarm;
    }

    public EventDispatcher<UserLoginListener> getUserLoginDispatcher() {
        return this.myUserLoginDispatcher;
    }

    public EventDispatcher<PersonalChangeProcessor> getPersonalBuildEventDispatcher() {
        return this.myPersonalBuildEventDispatcher;
    }

    public EventDispatcher<NotificationListener> getNotificationDispatcher() {
        return this.myNotificationDispatcher;
    }

    public synchronized IdeSettings getSettings() {
        return this.mySettings;
    }

    public LastFinishedBuildsManager getLastFinishedBuildsManager() {
        return this.myLastFinishedBuildsManager;
    }

    public EventDispatcher<SummaryListener> getSummaryDispatcher() {
        return this.mySummaryDispatcher;
    }

    public synchronized void addStateChangedListener(StateChangedListener listener) {
        this.myStateListeners.add(listener);
    }

    public synchronized void removeStateChangedListener(StateChangedListener listener) {
        this.myStateListeners.remove(listener);
    }

    private void notifyStateListeners(final TeamCityState oldState, final TeamCityState newState) {
        final StateChangedEvent event = new StateChangedEvent(){

            @Override
            public TeamCityState getNewState() {
                return newState;
            }

            @Override
            public TeamCityState getOldState() {
                return oldState;
            }

            @Override
            public TeamCitySnapshot getSource() {
                return TeamCitySnapshot.this;
            }
        };
        LOG.debug((Object)MessageFormat.format("State changed: {0} -> {1}", new Object[]{oldState, newState}));
        try {
            for (final StateChangedListener listener : this.myStateListeners) {
                Runnable notification = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            listener.stateChanged(event);
                        }
                        catch (Throwable t) {
                            LOG.warn((Object)t.getLocalizedMessage(), t);
                        }
                    }
                };
                Thread executor = new Thread(notification);
                executor.start();
            }
        }
        catch (Throwable t) {
            LOG.warn((Object)t.getLocalizedMessage(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Used(value="Eclipse")
    public void setProblem(Throwable problem) {
        String description = this.getProblemDescription();
        if (problem != null) {
            String newDescription = ExceptionUtil.getDisplayMessage((Throwable)problem);
            if (description == null || !description.equals(newDescription)) {
                description = newDescription;
            }
        } else {
            description = null;
        }
        TeamCitySnapshot teamCitySnapshot = this;
        synchronized (teamCitySnapshot) {
            this.myProblem = problem;
            this.myProblemDescription = description;
        }
    }

    @Used(value="Eclipse")
    public synchronized Throwable getProblem() {
        return this.myProblem;
    }

    @Used(value="IDEA,Eclipse")
    public synchronized String getProblemDescription() {
        return this.myProblemDescription;
    }

    @Used(value="test")
    void setTimeService(@NotNull TimeService service) {
        if (service == null) {
            TeamCitySnapshot.$$$reportNull$$$0(12);
        }
        this.myTimeService = service;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/TeamCitySnapshot";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/TeamCitySnapshot";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProjects";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSummaryProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSummaryProvider";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectObsoleteNotificationIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doFetchNewSummaryFromServer";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "scheduleUpdate";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateServerFacade";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "executeUpdateRequestSynchronously";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addUpdateRequest";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doScheduleSummaryUpdate";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setTimeService";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TeamServerSummaryProviderImpl
    implements TeamServerSummaryProvider {
        @NotNull
        private final TeamServerSummary mySummary;
        private final boolean myIsSummaryAvailable;
        private boolean myIsSummaryUpToDate;
        @NotNull
        private static final TeamServerSummaryProviderImpl DEFAULT_PROVIDER = new TeamServerSummaryProviderImpl(new TeamServerSummary(Collections.singletonList(new FakeRootProject()), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptySet(), Status.UNKNOWN, Collections.emptyMap(), Collections.emptyMap(), false, Status.UNKNOWN, 0, 0, 0), false);

        @NotNull
        static TeamServerSummaryProviderImpl create(@Nullable TeamServerSummary summary) {
            TeamServerSummaryProviderImpl teamServerSummaryProviderImpl = summary == null ? DEFAULT_PROVIDER : new TeamServerSummaryProviderImpl(summary, true);
            if (teamServerSummaryProviderImpl == null) {
                TeamServerSummaryProviderImpl.$$$reportNull$$$0(0);
            }
            return teamServerSummaryProviderImpl;
        }

        private TeamServerSummaryProviderImpl(@NotNull TeamServerSummary summary, boolean isSummaryAvailable) {
            if (summary == null) {
                TeamServerSummaryProviderImpl.$$$reportNull$$$0(1);
            }
            this.myIsSummaryUpToDate = true;
            this.mySummary = summary;
            this.myIsSummaryAvailable = isSummaryAvailable;
        }

        @Override
        public boolean isSummaryAvailable() {
            return this.myIsSummaryAvailable;
        }

        @Override
        public synchronized boolean isSummaryUpToDate() {
            return this.myIsSummaryUpToDate;
        }

        synchronized void markAsOutdated() {
            this.myIsSummaryUpToDate = false;
        }

        @Override
        @NotNull
        public TeamServerSummary getSummary() {
            TeamServerSummary teamServerSummary = this.mySummary;
            if (teamServerSummary == null) {
                TeamServerSummaryProviderImpl.$$$reportNull$$$0(2);
            }
            return teamServerSummary;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/TeamCitySnapshot$TeamServerSummaryProviderImpl";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "summary";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/TeamCitySnapshot$TeamServerSummaryProviderImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSummary";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class UpdateCurrentStatusAction
    implements Runnable {
        private UpdateCurrentStatusAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.debug((Object)"Updating current status...");
            LOG.debug((Object)("Current state: " + TeamCitySnapshot.this.getState().name()));
            Ref updateScheduled = new Ref((Object)false);
            try {
                if (TeamCitySnapshot.this.getServerFacade() == null) {
                    LOG.debug((Object)"Update cannot be performed: there is no server facade");
                    return;
                }
                TeamCityState state = TeamCitySnapshot.this.getState();
                if (!state.canConnectToServer()) {
                    LOG.debug((Object)"Update cannot be performed: cannot connect to server");
                    if (state.wantConnectToServer()) {
                        try {
                            LOG.debug((Object)"Ping server...");
                            TeamCitySnapshot.this.pingServer();
                        }
                        finally {
                            updateScheduled.set((Object)true);
                        }
                    }
                    return;
                }
                TeamCitySnapshot.this.loadNewNotifications();
                TeamCitySnapshot.this.doUpdateStatus((Ref<Boolean>)updateScheduled);
            }
            catch (Throwable e) {
                ExceptionUtil.log((Logger)LOG, (String)"Update failed", (Throwable)e);
            }
            finally {
                LOG.debug((Object)"Status update performed.");
                if (((Boolean)updateScheduled.get()).booleanValue()) {
                    LOG.debug((Object)"Summary update scheduled.");
                } else {
                    TeamCitySnapshot.this.addModificationTrackerAlarm();
                    LOG.debug((Object)"Status update scheduled.");
                }
            }
        }
    }

    private class UpdateServerDataRequest
    implements Runnable {
        private final Runnable myBeforeAction;
        private final Runnable myAfterAction;
        private final boolean myUpdateStatusImmediately;

        UpdateServerDataRequest(Runnable beforeAction, Runnable afterAction, boolean updateStatusImmediately) {
            this.myBeforeAction = beforeAction;
            this.myAfterAction = afterAction;
            this.myUpdateStatusImmediately = updateStatusImmediately;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Throwable throwable;
            block15: {
                throwable = null;
                LOG.debug((Object)"Updating summary...");
                try {
                    if (this.myBeforeAction != null) {
                        LOG.debug((Object)"Before updating summary action");
                        this.myBeforeAction.run();
                    }
                }
                catch (Throwable e) {
                    ExceptionUtil.log((Logger)LOG, (String)"Exception in 'BeforeAction' runnable", (Throwable)e);
                    throwable = e;
                }
                try {
                    TeamCitySnapshot.this.doUpdateSummary();
                    UserData user = TeamCitySnapshot.this.getUser();
                    if (user == null) break block15;
                    TeamServerSummaryProvider summaryProvider = TeamCitySnapshot.this.getSummaryProvider();
                    if (summaryProvider.isSummaryAvailable() && !TeamCitySnapshot.this.myIde.isDisposed()) {
                        TeamCitySnapshot.this.processMessagesSincePreviousUpdate(summaryProvider.getSummary());
                    }
                    try {
                        if (this.myAfterAction != null) {
                            LOG.debug((Object)"After action");
                            this.myAfterAction.run();
                        }
                    }
                    catch (Throwable e) {
                        ExceptionUtil.log((Logger)LOG, (String)"Exception in 'AfterAction' runnable", (Throwable)e);
                        throwable = e;
                    }
                }
                finally {
                    if (this.myUpdateStatusImmediately) {
                        TeamCitySnapshot.this.addModificationTrackerAlarm(10);
                    } else {
                        TeamCitySnapshot.this.addModificationTrackerAlarm();
                    }
                }
            }
            if (throwable != null) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new RuntimeException(throwable);
            }
        }
    }

    private static final class UpdateSummaryTracker {
        private final TimeService myTimeService;
        private final ExponentialBackoffHelper myTimeoutHelper = new ExponentialBackoffHelper();
        private long myLastFailedAttemptTime = 0L;

        UpdateSummaryTracker(TimeService timeService) {
            this.myTimeService = timeService;
        }

        synchronized void onSuccess() {
            this.myTimeoutHelper.reset();
            this.myLastFailedAttemptTime = 0L;
        }

        synchronized void onError() {
            this.myLastFailedAttemptTime = this.myTimeService.now();
        }

        synchronized int getDelayBeforeAnotherAttempt(int delay) {
            if (this.myLastFailedAttemptTime == 0L) {
                return delay;
            }
            int computed = this.myTimeoutHelper.computeDelayForCollision(delay < 1000 ? 1000 : delay) - (int)(this.myTimeService.now() - this.myLastFailedAttemptTime);
            return computed < delay ? delay : computed;
        }
    }
}

