/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.buildServer.BuildType;
import jetbrains.buildServer.DataFactory;
import jetbrains.buildServer.ProjectData;
import jetbrains.buildServer.TeamServerSummary;
import jetbrains.buildServer.UserChangeInfoData;
import jetbrains.buildServer.messages.Status;
import jetbrains.buildServer.responsibility.ResponsibilityEntry;
import jetbrains.buildServer.responsibility.impl.Util;
import jetbrains.buildServer.tests.TestData;
import jetbrains.buildServer.users.User;
import jetbrains.buildServer.util.CollectionsUtil;
import jetbrains.buildServer.util.filters.Filter;
import org.jetbrains.annotations.NotNull;

public class TeamServerSummaryData {
    private final List<ProjectData> myProjects;
    private final List<ProjectData> myFilteredOutProjectsWithInvetsigations;
    private final List<UserChangeInfoData> myChanges;
    private final List<UserChangeInfoData> myPersonalChanges;
    private final Set<String> myWatchedConfigurationIds;
    private final Status myWatchedBuildsStatus;
    private final Collection<String> myVisibleProjects;
    private final Map<String, Status> myProjectStatuses;
    private final Map<String, List<TestData>> myTestsWithInvestigation;
    private final boolean myResponsibleExists;
    private final Status myChangesStatus;
    private final int myFilteredOutProjectsCount;
    private final int myFilteredOutChangesCount;
    private final int mySummaryCounter;

    public TeamServerSummaryData(List<ProjectData> projects, List<ProjectData> filteredOutProjectsWithInvestigations, Collection<String> visibleProjects, Set<String> watchedConfigurationIds, List<UserChangeInfoData> changes, List<UserChangeInfoData> personalChanges, Status watchedBuildsStatus, Map<String, Status> projectStatuses, Map<String, List<TestData>> testsWithInvestigation, boolean responsibleExists, Status changesStatus, int filteredOutProjectsCount, int filteredOutChangesCount, int summaryCounter) {
        this.myProjects = projects;
        this.myFilteredOutProjectsWithInvetsigations = filteredOutProjectsWithInvestigations;
        this.myChanges = changes;
        this.myPersonalChanges = personalChanges;
        this.myWatchedConfigurationIds = watchedConfigurationIds;
        this.myWatchedBuildsStatus = watchedBuildsStatus;
        this.myVisibleProjects = visibleProjects;
        this.myProjectStatuses = projectStatuses;
        this.myTestsWithInvestigation = testsWithInvestigation;
        this.myResponsibleExists = responsibleExists;
        this.myChangesStatus = changesStatus;
        this.myFilteredOutProjectsCount = filteredOutProjectsCount;
        this.myFilteredOutChangesCount = filteredOutChangesCount;
        this.mySummaryCounter = summaryCounter;
    }

    public List<ProjectData> getProjects() {
        return this.myProjects;
    }

    public List<ProjectData> getFilteredOutProjectsWithInvetsigations() {
        return this.myFilteredOutProjectsWithInvetsigations;
    }

    public List<UserChangeInfoData> getChanges() {
        return this.myChanges;
    }

    public List<UserChangeInfoData> getPersonalChanges() {
        return this.myPersonalChanges;
    }

    public Set<String> getWatchedConfigurationIds() {
        return this.myWatchedConfigurationIds;
    }

    public Status getStatus() {
        return this.myWatchedBuildsStatus;
    }

    public static TeamServerSummaryData createOn(final TeamServerSummary summary, final Set<String> suitableBuildTypeIds, DataFactory dataFactory, final User user) {
        DataFactory.BuildTypeInstancesFilter filter = new DataFactory.BuildTypeInstancesFilter(){

            @Override
            public boolean loadInstances(BuildType type) {
                return summary.configurationIsVisible(type) || TeamServerSummaryData.userIsResponsibleForOrFixed(type, user);
            }
        };
        Filter buildTypeFilter = suitableBuildTypeIds == null ? CollectionsUtil.ACCEPT_ALL : new Filter<BuildType>(){

            public boolean accept(@NotNull BuildType data) {
                if (data == null) {
                    2.$$$reportNull$$$0(0);
                }
                return suitableBuildTypeIds.contains(data.getBuildTypeId()) || TeamServerSummaryData.userIsResponsibleForOrFixed(data, user);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "jetbrains/buildServer/TeamServerSummaryData$2", "accept"));
            }
        };
        return new TeamServerSummaryData(ProjectData.createDataListOn(summary.getProjects(), dataFactory, filter, (Filter<BuildType>)buildTypeFilter, user), ProjectData.createDataListOn(summary.getAdditionalProjects(), dataFactory, filter, user), summary.getVisibleProjectIds(), summary.getWatchedConfigurationIds(), UserChangeInfoData.createListOn(summary.getChanges(), dataFactory, user), UserChangeInfoData.createListOn(summary.getPersonalChanges(), dataFactory, user), summary.getStatus(), summary.getProjectStatusMap(), summary.getTestsWithInvestigation(), summary.responsibleExists(), summary.getChangesStatus(), summary.getFilteredOutProjectsCount(), summary.getFilteredOutChangesCount(), summary.getSummaryCounter());
    }

    private static boolean userIsResponsibleForOrFixed(BuildType type, User user) {
        ResponsibilityEntry info = type.getResponsibilityInfo();
        return user != null && (Util.isUserResponsible(info, user) || Util.isUserFixed(info, user));
    }

    public Status getWatchedBuildStatus() {
        return this.myWatchedBuildsStatus;
    }

    public Collection<String> getVisibleProjects() {
        return this.myVisibleProjects;
    }

    public Map<String, Status> getProjectStatuses() {
        return this.myProjectStatuses;
    }

    public Map<String, List<TestData>> getTestsWithInvestigation() {
        return this.myTestsWithInvestigation;
    }

    public boolean getResponsibleExists() {
        return this.myResponsibleExists;
    }

    public Status getChangesStatus() {
        return this.myChangesStatus;
    }

    public int getFilteredOutProjectsCount() {
        return this.myFilteredOutProjectsCount;
    }

    public int getFilteredOutChangesCount() {
        return this.myFilteredOutChangesCount;
    }

    public int getSummaryCounter() {
        return this.mySummaryCounter;
    }
}

