/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.BuildInstanceData;
import jetbrains.buildServer.BuildType;
import jetbrains.buildServer.BuildTypeData;
import jetbrains.buildServer.DataFactory;
import jetbrains.buildServer.UserChangeInfo;
import jetbrains.buildServer.UserChangeStatus;
import jetbrains.buildServer.serverSide.userChanges.PersonalChangeDescriptor;
import jetbrains.buildServer.users.User;
import jetbrains.buildServer.vcs.VcsModificationData;

public class UserChangeInfoData {
    private final VcsModificationData myModificationData;
    private final Map<BuildTypeData, BuildInstanceData> myTypeToInstanceMap = new LinkedHashMap<BuildTypeData, BuildInstanceData>();
    private final Map<BuildTypeData, BuildInstanceData> myFixedInMap = new LinkedHashMap<BuildTypeData, BuildInstanceData>();
    private final Map<BuildTypeData, BuildInstanceData> myCurrentMap = new LinkedHashMap<BuildTypeData, BuildInstanceData>();
    private final List<Long> myUserIds;
    private final PersonalChangeDescriptor myPersonalDesc;
    private final UserChangeStatus myStatus;

    public UserChangeInfoData(VcsModificationData modificationData, List<Long> userIds, PersonalChangeDescriptor desc, UserChangeStatus status) {
        this.myModificationData = modificationData;
        this.myUserIds = userIds;
        this.myPersonalDesc = desc;
        this.myStatus = status;
    }

    public static UserChangeInfoData createOn(UserChangeInfo info, DataFactory factory, User user) {
        UserChangeInfoData result = new UserChangeInfoData(factory.createData(info.getModification()), info.getUserIds(), info.getPersonalChangeDescriptor(), info.getChangeStatus());
        List<BuildType> types = info.getBuildTypes();
        for (BuildType type : types) {
            BuildTypeData buildTypeData = factory.createData(type, DataFactory.BuildTypeInstancesFilter.FALSE, user);
            result.myTypeToInstanceMap.put(buildTypeData, factory.createData(info.getFirstRunIn(type), user));
            result.myFixedInMap.put(buildTypeData, factory.createData(info.getFixedIn(type), user));
            result.myCurrentMap.put(buildTypeData, factory.createData(info.getCurrentBuild(type), user));
        }
        return result;
    }

    public VcsModificationData getModificationData() {
        return this.myModificationData;
    }

    public Map<BuildTypeData, BuildInstanceData> getTypeToInstanceMap() {
        return this.myTypeToInstanceMap;
    }

    public static List<UserChangeInfoData> createListOn(List<UserChangeInfo> changes, DataFactory factory, User user) {
        ArrayList<UserChangeInfoData> datas = new ArrayList<UserChangeInfoData>();
        for (UserChangeInfo change : changes) {
            datas.add(UserChangeInfoData.createOn(change, factory, user));
        }
        return datas;
    }

    public Map<BuildTypeData, BuildInstanceData> getFixedInMap() {
        return this.myFixedInMap;
    }

    public List<Long> getUserIds() {
        return this.myUserIds;
    }

    public Map<BuildTypeData, BuildInstanceData> getCurrentMap() {
        return this.myCurrentMap;
    }

    public PersonalChangeDescriptor getPersonalDesc() {
        return this.myPersonalDesc;
    }

    public UserChangeStatus getChangeStatus() {
        return this.myStatus;
    }
}

