/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.activation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import jetbrains.buildServer.ConnectionStatusListener;
import jetbrains.buildServer.TeamCityProcessManager;
import jetbrains.buildServer.Used;
import jetbrains.buildServer.activation.LogUtil;
import jetbrains.buildServer.activation.UrlUtil;
import jetbrains.buildServer.http.HttpUserAgent;
import jetbrains.buildServer.http.HttpUtil;
import jetbrains.buildServer.util.FileUtil;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jetbrains.annotations.NotNull;

public abstract class ActivatorBase {
    private static final Logger LOG = Logger.getInstance((String)ActivatorBase.class.getName());
    private static final String FILE = "/file";
    private static final String TEST = "/test";
    private static final String PATCH = "/patch";
    private static final String COMPILATION = "/compilation";

    @Used(value="IDE-plugins")
    protected abstract void accept(PatchLoader var1);

    @Used(value="IDE-plugins")
    protected abstract File suggestPatchFileName(File var1);

    public void handle(@NotNull String res, @NotNull Map<String, String> params, @NotNull ResultHandler handler) {
        if (res == null) {
            ActivatorBase.$$$reportNull$$$0(0);
        }
        if (params == null) {
            ActivatorBase.$$$reportNull$$$0(1);
        }
        if (handler == null) {
            ActivatorBase.$$$reportNull$$$0(2);
        }
        LogUtil.log(LOG, "handle:" + res);
        if (!this.willHandleActivation()) {
            handler.done(ActivationResult.FAILED);
        }
        if (PATCH.equals(res)) {
            handler.done(ActivationResult.SUCCEED);
            this.handleLoadPatch(params);
        } else if (FILE.equals(res)) {
            this.activateFile(params, handler);
        } else if (TEST.equals(res)) {
            this.activateTest(params, handler);
        } else if (COMPILATION.equals(res)) {
            this.activateCompilation(params, handler);
        } else {
            handler.done(ActivationResult.UNSUPPORTED);
        }
    }

    @Used(value="IDE-plugins")
    protected boolean willHandleActivation() {
        return true;
    }

    private void handleLoadPatch(final Map<String, String> params) {
        this.accept(new PatchLoader(){

            @Override
            public void loadPatch(TaskScheduler scheduler, final TeamCityProcessManager processManager, final String serverUrl, final String username, final String password, final PatchConsumer consumer) {
                scheduler.schedule(new Runnable(){

                    @Override
                    public void run() {
                        processManager.performAction(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                block10: {
                                    try {
                                        URL patchUrl;
                                        try {
                                            patchUrl = UrlUtil.createUrl(params, serverUrl);
                                        }
                                        catch (MalformedURLException | URISyntaxException e) {
                                            return;
                                        }
                                        File content = ActivatorBase.downloadPatch(patchUrl, username, password);
                                        if (content == null || !content.exists()) break block10;
                                        File newPatchFile = ActivatorBase.this.suggestPatchFileName(content);
                                        if (newPatchFile != null) {
                                            FileUtil.rename((File)content, (File)newPatchFile);
                                            content = newPatchFile;
                                        }
                                        try {
                                            consumer.consumePatch(content, patchUrl);
                                        }
                                        finally {
                                            content.deleteOnExit();
                                        }
                                    }
                                    catch (ProcessCanceledException patchUrl) {
                                    }
                                    catch (RuntimeException e) {
                                        throw e;
                                    }
                                    catch (Exception e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                            }
                        }, "Download patch", ConnectionStatusListener.ErrorProcessingKind.RETHROW);
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File downloadPatch(URL patchUrl, String username, String password) throws IOException {
        File content;
        block6: {
            content = null;
            HttpClient client = HttpUtil.createHttpClient((int)300, (URL)patchUrl, (Credentials)new UsernamePasswordCredentials(username, password));
            LogUtil.log(LOG, String.format("request patch url: %s", patchUrl));
            GetMethod get = new GetMethod(patchUrl.toString());
            HttpUserAgent.addHeader((HttpMethod)get);
            try {
                int statusCode = client.executeMethod((HttpMethod)get);
                if (statusCode != 200) break block6;
                content = File.createTempFile("uploaded", ".patch");
                try (BufferedOutputStream outToTmp = new BufferedOutputStream(new FileOutputStream(content));){
                    FileUtil.copyStreams((InputStream)new BufferedInputStream(get.getResponseBodyAsStream()), (OutputStream)outToTmp);
                }
            }
            finally {
                get.releaseConnection();
            }
        }
        return content;
    }

    @NotNull
    @Used(value="IDE-plugins")
    protected void activateFile(@NotNull Map<String, String> params, @NotNull ResultHandler handler) {
        if (params == null) {
            ActivatorBase.$$$reportNull$$$0(3);
        }
        if (handler == null) {
            ActivatorBase.$$$reportNull$$$0(4);
        }
        handler.done(ActivationResult.UNSUPPORTED);
    }

    @NotNull
    @Used(value="IDE-plugins")
    protected void activateTest(@NotNull Map<String, String> params, @NotNull ResultHandler handler) {
        if (params == null) {
            ActivatorBase.$$$reportNull$$$0(5);
        }
        if (handler == null) {
            ActivatorBase.$$$reportNull$$$0(6);
        }
        handler.done(ActivationResult.UNSUPPORTED);
    }

    @NotNull
    @Used(value="IDE-plugins")
    protected void activateCompilation(@NotNull Map<String, String> params, @NotNull ResultHandler handler) {
        if (params == null) {
            ActivatorBase.$$$reportNull$$$0(7);
        }
        if (handler == null) {
            ActivatorBase.$$$reportNull$$$0(8);
        }
        handler.done(ActivationResult.UNSUPPORTED);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/activation/ActivatorBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handle";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "activateFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "activateTest";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "activateCompilation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface TaskScheduler {
        public void schedule(Runnable var1);
    }

    public static interface PatchConsumer {
        public void consumePatch(File var1, URL var2) throws IOException;
    }

    protected static interface PatchLoader {
        @Used(value="IDE-plugins")
        public void loadPatch(TaskScheduler var1, TeamCityProcessManager var2, String var3, String var4, String var5, PatchConsumer var6);
    }

    public static interface ResultHandler {
        public void done(@NotNull ActivationResult var1);
    }

    public static enum ActivationResult {
        SUCCEED,
        FAILED,
        UNSUPPORTED;

    }
}

