/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.buildTriggers.vcs;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import jetbrains.buildServer.parameters.ReferencesResolverUtil;
import jetbrains.buildServer.serverSide.InvalidProperty;
import jetbrains.buildServer.serverSide.PropertiesProcessor;
import org.apache.log4j.Logger;

public abstract class AbstractVcsPropertiesProcessor
implements PropertiesProcessor {
    private static final String NEWLINE = "\n";
    private static final String FILE_IS_NULL_MESSAGE = "file is null. cannot dump";
    private static final String NO_DEBUG_ENABLED_MESSAGE = "No debug enabled";
    private static final Logger LOG = Logger.getLogger(AbstractVcsPropertiesProcessor.class);

    protected void removePropertiesWithEmptyValues(Map<String, String> properties) {
        Iterator<Map.Entry<String, String>> mapEntryIt = properties.entrySet().iterator();
        while (mapEntryIt.hasNext()) {
            Map.Entry<String, String> mapEntry = mapEntryIt.next();
            if (!this.isEmpty(mapEntry.getValue())) continue;
            mapEntryIt.remove();
        }
    }

    protected void checkFileProperty(String propertyName, String propertyValue, Collection<InvalidProperty> result) {
        if (this.mayContainReference(propertyValue)) {
            return;
        }
        File file = new File(propertyValue);
        if (file.exists()) {
            if (!file.isFile()) {
                result.add(new InvalidProperty(propertyName, String.format("File \"%s\" is not a file", file.getPath())));
                LOG.debug((Object)String.format("File exists but is not a file: %s", AbstractVcsPropertiesProcessor.dumpFileProps(file, false)));
            }
        } else {
            result.add(new InvalidProperty(propertyName, String.format("File \"%s\" does not exist", file.getPath())));
            LOG.debug((Object)String.format("File does not exist: %s", AbstractVcsPropertiesProcessor.dumpFileProps(file, true)));
        }
    }

    protected void checkDirectoryProperty(String propertyName, String propertyValue, Collection<InvalidProperty> result) {
        if (this.mayContainReference(propertyValue)) {
            return;
        }
        File file = new File(propertyValue);
        if (file.exists()) {
            if (!file.isDirectory()) {
                result.add(new InvalidProperty(propertyName, String.format("File \"%s\" exists but is not a directory", file.getPath())));
                LOG.debug((Object)String.format("File exists but is not directory: %s", AbstractVcsPropertiesProcessor.dumpFileProps(file, false)));
            }
        } else {
            result.add(new InvalidProperty(propertyName, String.format("Directory \"%s\" does not exist or TeamCity server is running under a user that has no access to this directory", file.getPath())));
            LOG.debug((Object)String.format("Directory does not exist: %s", AbstractVcsPropertiesProcessor.dumpFileProps(file, true)));
        }
    }

    private static String dumpFileProps(File file, boolean listParent) {
        if (LOG.isDebugEnabled()) {
            if (file != null) {
                StringBuffer dump = new StringBuffer("\nFile properties dump for \"").append(file.getAbsolutePath()).append("\"");
                dump.append(NEWLINE);
                dump.append("exists=").append(file.exists()).append(NEWLINE);
                dump.append("isAbsolute=").append(file.isAbsolute()).append(NEWLINE);
                dump.append("isDirectory=").append(file.isDirectory()).append(NEWLINE);
                dump.append("isFile=").append(file.isFile()).append(NEWLINE);
                dump.append("isHidden=").append(file.isHidden()).append(NEWLINE);
                dump.append("canRead=").append(file.canRead()).append(NEWLINE);
                dump.append("canWrite=").append(file.canWrite()).append(NEWLINE);
                dump.append("lastModified=").append(file.lastModified()).append(NEWLINE);
                if (listParent) {
                    File parentDir = file.getParentFile();
                    if (parentDir != null && parentDir.exists()) {
                        dump.append("List content of parent folder \"").append(parentDir).append("\"\n");
                        for (File neighbour : parentDir.listFiles()) {
                            if (neighbour.isDirectory()) {
                                dump.append("<dir>\t\"").append(neighbour.getName()).append("\"\n");
                                continue;
                            }
                            dump.append("<file>\t\"").append(neighbour.getName()).append("\"\n");
                        }
                    } else {
                        dump.append("Parent folder \"").append(parentDir).append("\" does not exist\n");
                    }
                }
                return dump.toString().trim();
            }
            return FILE_IS_NULL_MESSAGE;
        }
        return NO_DEBUG_ENABLED_MESSAGE;
    }

    protected void checkPortNumberProperty(String propertyName, String propertyValue, Collection<InvalidProperty> result) {
        if (this.mayContainReference(propertyValue)) {
            return;
        }
        Integer port = this.parseInteger(propertyValue);
        if (port == null) {
            result.add(new InvalidProperty(propertyName, "Invalid port value"));
        } else if (port <= 0 || port > 65535) {
            result.add(new InvalidProperty(propertyName, "Port number must be from 1 to 65535"));
        }
    }

    protected void checkIntegerProperty(String propertyName, String propertyValue, Collection<InvalidProperty> result) {
        if (this.mayContainReference(propertyValue)) {
            return;
        }
        Integer timeout = this.parseInteger(propertyValue);
        if (timeout == null || timeout < 0) {
            result.add(new InvalidProperty(propertyName, "Invalid number"));
        }
    }

    protected boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    protected boolean mayContainReference(String str) {
        if (this.isEmpty(str)) {
            return false;
        }
        return ReferencesResolverUtil.mayContainReference((String)str);
    }

    protected Integer parseInteger(String str) {
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

