/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.notification;

import jetbrains.buildServer.messages.Status;

public class EventType {
    private final String myName;
    private final Status myStatus;
    private final int myEventId;
    public static final EventType BUILD_STARTED = new EventType("The build starts", Status.NORMAL, 1);
    public static final EventType BUILD_SUCCESSFUL = new EventType("The build is successful", Status.NORMAL, 2);
    public static final EventType BUILD_FAILED = new EventType("The build fails", Status.FAILURE, 3);
    public static final EventType BUILD_FAILING = new EventType("The build is failing", Status.FAILURE, 4);
    public static final EventType RESPONSIBILITY_CHANGES = new EventType("Responsibility changes", Status.NORMAL, 5);
    public static final EventType BUILD_PROBABLY_HANGING = new EventType("The build is probably hanging", Status.WARNING, 6);
    public static final EventType LABELING_FAILED = new EventType("Labeling failed for the build", Status.FAILURE, 7);
    public static final EventType TEST_RESPONSIBILITY_CHANGES = new EventType("Test responsibility changes", Status.NORMAL, 8);
    public static final EventType TEST_MUTED = new EventType("Test muted", Status.NORMAL, 9);

    private EventType(String name, Status status, int eventId) {
        this.myName = name;
        this.myStatus = status;
        this.myEventId = eventId;
    }

    public String getName() {
        return this.myName;
    }

    public Status getStatus() {
        return this.myStatus;
    }

    public int getEventId() {
        return this.myEventId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventType eventType = (EventType)o;
        return this.myName.equals(eventType.myName) && this.myStatus.equals(eventType.myStatus);
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + this.myStatus.hashCode();
        return result;
    }
}

