/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.notification;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import jetbrains.buildServer.messages.MessagesPersistence;
import jetbrains.buildServer.messages.StatusConverter;
import jetbrains.buildServer.messages.XStreamHolder;
import jetbrains.buildServer.notification.EventType;

public final class NotificationMessage {
    private final EventType myEventType;
    private final String myMessage;
    private final String myDetailLink;
    private final String myProjectId;
    private final String myBuildTypeId;
    private final long myBuildId;
    private final boolean myIsPersonalBuild;
    private final boolean myIsImportant;
    private final long myModificationCounter;
    private final long myTime;

    public NotificationMessage(EventType status, String message, String detailLink, String projectId, String buildTypeId, long buildId, boolean isPersonalBuild, boolean isImportant, long counter) {
        this.myEventType = status;
        this.myMessage = message;
        this.myDetailLink = detailLink;
        this.myProjectId = projectId;
        this.myBuildTypeId = buildTypeId;
        this.myBuildId = buildId;
        this.myIsPersonalBuild = isPersonalBuild;
        this.myIsImportant = isImportant;
        this.myModificationCounter = counter;
        this.myTime = System.currentTimeMillis();
    }

    public EventType getEventType() {
        return this.myEventType;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public String getDetailLink() {
        return this.myDetailLink;
    }

    public String getProjectId() {
        return this.myProjectId;
    }

    public String getBuildTypeId() {
        return this.myBuildTypeId;
    }

    public long getBuildId() {
        return this.myBuildId;
    }

    public boolean isPersonalBuild() {
        return this.myIsPersonalBuild;
    }

    public long getModificationCounter() {
        return this.myModificationCounter;
    }

    public long getTime() {
        return this.myTime;
    }

    public boolean isImportant() {
        return this.myIsImportant;
    }

    public static XStreamHolder createNotificatorHolder() {
        return new XStreamHolder(){

            protected void configureXStream(XStream xStream) {
                xStream.registerConverter((SingleValueConverter)new MessagesPersistence.StringConverter(), 1);
                xStream.registerConverter((SingleValueConverter)new StatusConverter());
                xStream.alias("Message", NotificationMessage.class);
                xStream.alias("EventType", EventType.class);
            }
        };
    }
}

