/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverProxy;

import java.util.logging.Level;
import java.util.logging.Logger;
import jetbrains.buildServer.serverProxy.ApplicationFacade;
import jetbrains.buildServer.serverProxy.InvalidXmlRpcSessionException;
import jetbrains.buildServer.serverProxy.SessionXmlRpcTarget;
import jetbrains.buildServer.serverProxy.VersionChecker;
import jetbrains.buildServer.xmlrpc.RemoteCallException;
import jetbrains.buildServer.xmlrpc.XmlRpcTarget;
import org.jetbrains.annotations.NotNull;

public class ClientXmlRpcExecutorFacade {
    private static final Logger LOG = Logger.getLogger("#" + ClientXmlRpcExecutorFacade.class.getName());
    private final XmlRpcTarget myTarget;
    private final ApplicationFacade myApplicationFacade;
    private final String myHandlerName;
    private final VersionChecker myVersionChecker;

    public ClientXmlRpcExecutorFacade(XmlRpcTarget target, ApplicationFacade applicationFacade, String handlerName, VersionChecker checker) {
        this.myTarget = target;
        this.myApplicationFacade = applicationFacade;
        this.myHandlerName = handlerName;
        this.myVersionChecker = checker;
    }

    public <T> T callXmlRpc(String method, Object ... parameters) throws RemoteCallException {
        XmlRpcTarget.Cancelable cancelable = this.myApplicationFacade.createCancelable();
        try {
            return (T)this.myTarget.call(this.myHandlerName + "." + method, parameters, cancelable);
        }
        catch (XmlRpcTarget.ProcessCanceledException e) {
            return this.cancelAndReturnNull(e);
        }
        catch (RemoteCallException throwable) {
            LOG.log(Level.FINE, "XmlRpc exception", throwable);
            throw throwable;
        }
        catch (InvalidXmlRpcSessionException invalidSession) {
            try {
                return (T)this.processInvalidSession(invalidSession, cancelable, method, parameters);
            }
            catch (XmlRpcTarget.ProcessCanceledException e) {
                return this.cancelAndReturnNull(e);
            }
        }
        catch (Throwable throwable) {
            LOG.log(Level.FINE, "XmlRpc exception", throwable);
            throw new RemoteCallException(throwable.getLocalizedMessage(), throwable);
        }
    }

    private Object processInvalidSession(@NotNull InvalidXmlRpcSessionException e, XmlRpcTarget.Cancelable cancelable, String method, Object ... parameters) {
        if (e == null) {
            ClientXmlRpcExecutorFacade.$$$reportNull$$$0(0);
        }
        if (this.myTarget instanceof SessionXmlRpcTarget) {
            this.myVersionChecker.checkServerVersion();
            ((SessionXmlRpcTarget)this.myTarget).authenticate(cancelable);
            return this.callXmlRpc(method, parameters);
        }
        throw e;
    }

    private <T> T cancelAndReturnNull(XmlRpcTarget.ProcessCanceledException e) {
        LOG.log(Level.FINE, "Operation canceled", e);
        this.myApplicationFacade.onProcessCanceled();
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientXmlRpcExecutorFacade that = (ClientXmlRpcExecutorFacade)o;
        return !(this.myTarget == null ? that.myTarget != null : !this.myTarget.equals(that.myTarget));
    }

    public int hashCode() {
        return this.myTarget != null ? this.myTarget.hashCode() : 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "jetbrains/buildServer/serverProxy/ClientXmlRpcExecutorFacade", "processInvalidSession"));
    }
}

