/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverProxy.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ConcurrencyUtil;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import jetbrains.buildServer.xmlrpc.XmlRpcTarget;
import jetbrains.buildServer.xmlrpc.impl.CommonsXmlRpcTargetImpl;

public class CancelableXmlRpcTargetImpl
extends CommonsXmlRpcTargetImpl {
    private static final Logger LOG = Logger.getInstance((String)CancelableXmlRpcTargetImpl.class.getName());
    private final ExecutorService myExecutor;

    public CancelableXmlRpcTargetImpl(CancelableXmlRpcTargetImpl source, int connectionTimeout) throws MalformedURLException {
        super((CommonsXmlRpcTargetImpl)source, connectionTimeout);
        this.myExecutor = source.myExecutor;
    }

    public CancelableXmlRpcTargetImpl(String serverURL, String userAgent, int connectionTimeout, boolean keepAlive) throws MalformedURLException {
        this(serverURL, userAgent, connectionTimeout, keepAlive, ConcurrencyUtil.newSingleThreadExecutor((String)"TeamCity XML-RPC Simple Executor"));
    }

    protected CancelableXmlRpcTargetImpl(String serverURL, String userAgent, int connectionTimeout, boolean keepAlive, ExecutorService executor) throws MalformedURLException {
        super(serverURL, userAgent, connectionTimeout, keepAlive);
        this.myExecutor = executor;
    }

    protected void callWithCancelable(final String method, final Object[] parameters, final Object[] result, XmlRpcTarget.Cancelable cancelable) throws XmlRpcTarget.ProcessCanceledException {
        if (this.myExecutor.isShutdown()) {
            LOG.warn("XML-RPC executor is already disposed");
            throw new XmlRpcTarget.ProcessCanceledException("XML-RPC executor is already disposed");
        }
        Future<?> task = this.myExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    result[0] = CancelableXmlRpcTargetImpl.this.getClient().execute(method, new Vector<Object>(Arrays.asList(parameters)));
                }
                catch (Throwable e) {
                    result[0] = e;
                }
            }
        });
        while (!task.isDone()) {
            if (cancelable.isCanceled()) {
                task.cancel(true);
                throw new XmlRpcTarget.ProcessCanceledException();
            }
            CancelableXmlRpcTargetImpl.sleep(cancelable.sleepingPeriod());
        }
    }

    public void dispose() {
        LOG.info("Disposing XML-RPC executor");
        LOG.debug("Disposing XML-RPC executor", new Throwable());
        super.dispose();
        this.myExecutor.shutdown();
    }

    private static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

