/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import jetbrains.buildServer.Build;
import jetbrains.buildServer.BuildAgent;
import jetbrains.buildServer.BuildType;
import jetbrains.buildServer.QueuedBuild;
import jetbrains.buildServer.log.LogUtil;
import jetbrains.buildServer.log.Loggers;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelativeWebLinks {
    @NotNull
    public String getViewResultsUrl(@NotNull Build build) {
        if (build == null) {
            RelativeWebLinks.$$$reportNull$$$0(0);
        }
        String string = this.makeBuildUrl(build, null);
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getViewChangesUrl(@NotNull Build build) {
        if (build == null) {
            RelativeWebLinks.$$$reportNull$$$0(2);
        }
        String string = this.makeBuildUrl(build, "buildChangesDiv");
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getViewLogUrl(@NotNull Build build) {
        if (build == null) {
            RelativeWebLinks.$$$reportNull$$$0(4);
        }
        String string = this.makeBuildUrl(build, "buildLog");
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getViewArtifactsUrl(@NotNull Build build) {
        if (build == null) {
            RelativeWebLinks.$$$reportNull$$$0(6);
        }
        String string = this.makeBuildUrl(build, "artifacts");
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getBuildParametersUrl(@NotNull Build build) {
        if (build == null) {
            RelativeWebLinks.$$$reportNull$$$0(8);
        }
        String string = this.makeBuildUrl(build, "buildParameters");
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getBuildDependenciesUrl(@NotNull Build build) {
        if (build == null) {
            RelativeWebLinks.$$$reportNull$$$0(10);
        }
        String string = this.makeBuildUrl(build, "dependencies");
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public String getUserSettingsUrl() {
        String string = this.prepareUrl("/profile.html?init=1");
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public String getUserNotificationsUrl() {
        String string = this.prepareUrl("/profile.html?init=1&tab=userNotifications");
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(13);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String getDownloadArtefactUrl(@NotNull String buildTypeExternalId, long buildId, @NotNull String string) {
        void path;
        if (buildTypeExternalId == null) {
            RelativeWebLinks.$$$reportNull$$$0(14);
        }
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(15);
        }
        String pathWithoutLeadingSlash = this.getRelativePath((String)path);
        String string2 = this.prepareProjectUrlByExternalBuildTypeId("/repository/download/" + buildTypeExternalId + "/" + buildId + ":id/" + pathWithoutLeadingSlash, buildTypeExternalId);
        if (string2 == null) {
            RelativeWebLinks.$$$reportNull$$$0(16);
        }
        return string2;
    }

    @NotNull
    public String getDownloadArtefactUrl(@NotNull String buildTypeExternalId, @NotNull String buildNumber, @NotNull String path) {
        if (buildTypeExternalId == null) {
            RelativeWebLinks.$$$reportNull$$$0(17);
        }
        if (buildNumber == null) {
            RelativeWebLinks.$$$reportNull$$$0(18);
        }
        if (path == null) {
            RelativeWebLinks.$$$reportNull$$$0(19);
        }
        String pathWithoutLeadingSlash = this.getRelativePath(path);
        String string = this.prepareProjectUrlByExternalBuildTypeId("/repository/download/" + buildTypeExternalId + "/" + buildNumber + "/" + pathWithoutLeadingSlash, buildTypeExternalId);
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public String getDownloadAllArtefactsUrl(@NotNull Build build) {
        BuildType buildType;
        if (build == null) {
            RelativeWebLinks.$$$reportNull$$$0(21);
        }
        if ((buildType = build.getBuildType()) == null) {
            throw new RuntimeException("Build configuration with internal id " + LogUtil.quote((String)build.getBuildTypeId()) + " does not exist anymore.");
        }
        long buildId = build.getBuildId();
        String string = this.prepareProjectUrl("/repository/downloadAll/" + buildType.getExternalId() + "/" + buildId + ":id/artifacts.zip", build.getProjectExternalId());
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public String getChangeUrl(long modificationId, boolean isPersonal) {
        String string = this.prepareUrl("/viewModification.html?modId=" + modificationId + "&personal=" + isPersonal);
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public String getChangeFilesUrl(long modificationId, boolean isPersonal) {
        String string = this.prepareUrl("/viewModification.html?modId=" + modificationId + "&personal=" + isPersonal + "&tab=vcsModificationFiles");
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public String getQueuedBuildUrl(@NotNull QueuedBuild queuedBuild) {
        if (queuedBuild == null) {
            RelativeWebLinks.$$$reportNull$$$0(25);
        }
        String string = this.prepareProjectUrlByInternalBuildTypeId("/viewQueued.html?itemId=" + queuedBuild.getItemId(), queuedBuild.getBuildTypeId());
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(26);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String getPersonalQueuedBuildUrl(long personalChangeId, @NotNull BuildType buildType) {
        void buildType2;
        if (buildType == null) {
            RelativeWebLinks.$$$reportNull$$$0(27);
        }
        String string = this.prepareProjectUrl("/viewQueuedPersonal.html?changeId=" + personalChangeId + "&buildTypeId=" + buildType2.getExternalId(), buildType2.getProjectExternalId());
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    public String getConfigurationHomePageUrl(@NotNull BuildType buildType) {
        if (buildType == null) {
            RelativeWebLinks.$$$reportNull$$$0(29);
        }
        String buildTypeId = buildType.getExternalId();
        String string = this.prepareProjectUrl("/viewType.html?buildTypeId=" + buildTypeId, buildType.getProjectExternalId());
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    public String getProjectPageUrl(@NotNull String projectExternalId) {
        if (projectExternalId == null) {
            RelativeWebLinks.$$$reportNull$$$0(31);
        }
        String string = this.prepareProjectUrl("/project.html?projectId=" + projectExternalId, projectExternalId);
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    public String getEditProjectPageUrl(@NotNull String projectExternalId) {
        if (projectExternalId == null) {
            RelativeWebLinks.$$$reportNull$$$0(33);
        }
        String string = this.prepareProjectUrl("/admin/editProject.html?init=1&projectId=" + projectExternalId, projectExternalId);
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    public String getEditConfigurationPageUrl(@NotNull String buildTypeExternalId) {
        if (buildTypeExternalId == null) {
            RelativeWebLinks.$$$reportNull$$$0(35);
        }
        String string = this.prepareProjectUrlByExternalBuildTypeId("/admin/editBuild.html?init=1&id=buildType:" + buildTypeExternalId, buildTypeExternalId);
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    public String getEditTemplatePageUrl(@NotNull String templateExternalId) {
        if (templateExternalId == null) {
            RelativeWebLinks.$$$reportNull$$$0(37);
        }
        String string = this.prepareProjectUrlByBuildTypeTemplateExternalId("/admin/editBuild.html?init=1&id=template:" + templateExternalId, templateExternalId);
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(38);
        }
        return string;
    }

    @Deprecated
    @NotNull
    public String getEditVcsRootPageUrl(@NotNull String vcsRootExternalId) {
        if (vcsRootExternalId == null) {
            RelativeWebLinks.$$$reportNull$$$0(39);
        }
        String string = this.prepareUrl("/admin/editVcsRoot.html?init=1&action=editVcsRoot&vcsRootId=" + vcsRootExternalId);
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(40);
        }
        return string;
    }

    @NotNull
    public String getEditVcsRootPageUrl(@Nullable String extProjectId, @NotNull String vcsRootExternalId) {
        if (vcsRootExternalId == null) {
            RelativeWebLinks.$$$reportNull$$$0(41);
        }
        String string = this.prepareProjectUrl("/admin/editVcsRoot.html?init=1&action=editVcsRoot&vcsRootId=" + vcsRootExternalId, extProjectId);
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(42);
        }
        return string;
    }

    @NotNull
    public String getCreateConfigurationPageUrl(@NotNull String projectExtId) {
        if (projectExtId == null) {
            RelativeWebLinks.$$$reportNull$$$0(43);
        }
        String string = this.prepareProjectUrl("/admin/createObjectMenu.html?showMode=createBuildTypeMenu&projectId=" + projectExtId, projectExtId);
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(44);
        }
        return string;
    }

    @NotNull
    public String getCreateProjectPageUrl(@NotNull String parentExtId) {
        if (parentExtId == null) {
            RelativeWebLinks.$$$reportNull$$$0(45);
        }
        String string = this.prepareUrl("/admin/createObjectMenu.html?showMode=createProjectMenu&projectId=" + parentExtId);
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(46);
        }
        return string;
    }

    @NotNull
    public String getOverviewUrl() {
        String string = this.prepareUrl("/overview.html");
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(47);
        }
        return string;
    }

    @NotNull
    public String getEditNotificationsUrl(@NotNull String notificatorType) {
        if (notificatorType == null) {
            RelativeWebLinks.$$$reportNull$$$0(48);
        }
        String string = this.prepareUrl("/profile.html?init=1&tab=userNotifications&notificatorType=" + this.encodeURLParameter(notificatorType));
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(49);
        }
        return string;
    }

    @NotNull
    public String getEditBuildFeaturesUrl(@NotNull BuildType buildType) {
        if (buildType == null) {
            RelativeWebLinks.$$$reportNull$$$0(50);
        }
        String string = this.prepareUrl("/admin/editBuildFeatures.html?id=buildType:" + buildType.getExternalId());
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(51);
        }
        return string;
    }

    @NotNull
    public String getPluginUrl() {
        String string = this.prepareUrl("/update/TeamCity-IDEAplugin.zip");
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(52);
        }
        return string;
    }

    @NotNull
    public String getTestDetailsUrl(@NotNull String projectExternalId, long testNameId) {
        if (projectExternalId == null) {
            RelativeWebLinks.$$$reportNull$$$0(53);
        }
        String string = this.getTestDetailsUrl(projectExternalId, testNameId, null);
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(54);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String getTestDetailsUrl(@NotNull String projectExternalId, long testNameId, @Nullable String string) {
        void buildTypeId;
        if (projectExternalId == null) {
            RelativeWebLinks.$$$reportNull$$$0(55);
        }
        String string2 = this.prepareProjectUrl("/project.html?tab=testDetails&projectId=" + projectExternalId + (buildTypeId == null ? "" : "&buildTypeId=" + (String)buildTypeId) + "&testNameId=" + testNameId, projectExternalId);
        if (string2 == null) {
            RelativeWebLinks.$$$reportNull$$$0(56);
        }
        return string2;
    }

    @NotNull
    public String getResponsibilitiesUrl(@NotNull String projectExternalId, @NotNull String username) {
        if (projectExternalId == null) {
            RelativeWebLinks.$$$reportNull$$$0(57);
        }
        if (username == null) {
            RelativeWebLinks.$$$reportNull$$$0(58);
        }
        String string = this.prepareProjectUrl("/project.html?projectId=" + projectExternalId + "&tab=investigations&selectedUser=" + this.encodeURLParameter(username), projectExternalId);
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(59);
        }
        return string;
    }

    @NotNull
    public String getMutedProblemsUrl(@NotNull String projectExternalId) {
        if (projectExternalId == null) {
            RelativeWebLinks.$$$reportNull$$$0(60);
        }
        String string = this.prepareProjectUrl("/project.html?projectId=" + projectExternalId + "&tab=mutedProblems", projectExternalId);
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(61);
        }
        return string;
    }

    @NotNull
    private String makeBuildUrl(@NotNull Build build, @Nullable String tab) {
        if (build == null) {
            RelativeWebLinks.$$$reportNull$$$0(62);
        }
        String string = this.prepareProjectUrl("/viewLog.html?" + (tab == null ? "" : "tab=" + tab + "&") + "buildId=" + build.getBuildId() + "&buildTypeId=" + build.getBuildTypeExternalId(), build.getProjectExternalId());
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(63);
        }
        return string;
    }

    @Nullable
    public String getAgentUrl(@NotNull BuildAgent agent, @Nullable Integer agentTypeId) {
        String agentName;
        if (agent == null) {
            RelativeWebLinks.$$$reportNull$$$0(64);
        }
        StringBuilder result = new StringBuilder();
        result.append("/agentDetails.html");
        boolean firstParameter = true;
        if (agent.getId() > 0) {
            firstParameter = false;
            result.append("?id=").append(agent.getId());
        }
        if (agentTypeId != null && agentTypeId > 0) {
            if (firstParameter) {
                result.append("?");
                firstParameter = false;
            } else {
                result.append("&");
            }
            result.append("agentTypeId=").append(agentTypeId);
        }
        if (!(firstParameter || StringUtil.isEmpty((String)(agentName = agent.getName())) || "<unknown>".equalsIgnoreCase(agentName) || "Dead agent".equalsIgnoreCase(agentName))) {
            result.append("&realAgentName=").append(this.encodeURLParameter(agentName));
        }
        if (firstParameter) {
            return null;
        }
        return this.prepareUrl(result.toString());
    }

    @NotNull
    private String getRelativePath(@NotNull String path) {
        if (path == null) {
            RelativeWebLinks.$$$reportNull$$$0(65);
        }
        String pathWithoutLeadingSlash = path;
        if (path.startsWith("/")) {
            pathWithoutLeadingSlash = path.substring(1);
        }
        String string = pathWithoutLeadingSlash;
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(66);
        }
        return string;
    }

    @Nullable
    @Contract(value="null->null;!null->!null")
    private String encodeURLParameter(@Nullable String source) {
        if (source == null) {
            return null;
        }
        if (TeamCityProperties.getBoolean((String)"teamcity.internal.legacyUrlEncoding.enable")) {
            try {
                return URLEncoder.encode(source, "UTF-8").replace("+", "%20");
            }
            catch (UnsupportedEncodingException e) {
                Loggers.SERVER.warn("Failed to encode URL parameter: " + source);
                return source;
            }
        }
        return StringUtil.encodeURLParameter((String)source);
    }

    @NotNull
    protected String prepareUrl(@NotNull String relativeUrl) {
        if (relativeUrl == null) {
            RelativeWebLinks.$$$reportNull$$$0(67);
        }
        String string = relativeUrl;
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(68);
        }
        return string;
    }

    @NotNull
    protected String prepareProjectUrl(@NotNull String relativeUrl, @Nullable String externalProjectID) {
        if (relativeUrl == null) {
            RelativeWebLinks.$$$reportNull$$$0(69);
        }
        String string = relativeUrl;
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(70);
        }
        return string;
    }

    @NotNull
    protected String prepareProjectUrlByExternalBuildTypeId(@NotNull String relativeUrl, @Nullable String extBuildTypeId) {
        if (relativeUrl == null) {
            RelativeWebLinks.$$$reportNull$$$0(71);
        }
        String string = relativeUrl;
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(72);
        }
        return string;
    }

    @NotNull
    protected String prepareProjectUrlByInternalBuildTypeId(@NotNull String relativeUrl, @Nullable String intBuildTypeId) {
        if (relativeUrl == null) {
            RelativeWebLinks.$$$reportNull$$$0(73);
        }
        String string = relativeUrl;
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(74);
        }
        return string;
    }

    @NotNull
    protected String prepareProjectUrlByBuildTypeTemplateExternalId(@NotNull String relativeUrl, @Nullable String extTemplateId) {
        if (relativeUrl == null) {
            RelativeWebLinks.$$$reportNull$$$0(75);
        }
        String string = relativeUrl;
        if (string == null) {
            RelativeWebLinks.$$$reportNull$$$0(76);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 59: 
            case 61: 
            case 63: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 74: 
            case 76: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 59: 
            case 61: 
            case 63: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 74: 
            case 76: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "build";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 59: 
            case 61: 
            case 63: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 74: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/serverSide/RelativeWebLinks";
                break;
            }
            case 14: 
            case 17: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildTypeExternalId";
                break;
            }
            case 15: 
            case 19: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildNumber";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queuedBuild";
                break;
            }
            case 27: 
            case 29: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildType";
                break;
            }
            case 31: 
            case 33: 
            case 53: 
            case 55: 
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectExternalId";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateExternalId";
                break;
            }
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRootExternalId";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectExtId";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentExtId";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificatorType";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "username";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agent";
                break;
            }
            case 67: 
            case 69: 
            case 71: 
            case 73: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/serverSide/RelativeWebLinks";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewResultsUrl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewChangesUrl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewLogUrl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewArtifactsUrl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildParametersUrl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildDependenciesUrl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserSettingsUrl";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserNotificationsUrl";
                break;
            }
            case 16: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDownloadArtefactUrl";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDownloadAllArtefactsUrl";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeUrl";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeFilesUrl";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueuedBuildUrl";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersonalQueuedBuildUrl";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationHomePageUrl";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectPageUrl";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditProjectPageUrl";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditConfigurationPageUrl";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditTemplatePageUrl";
                break;
            }
            case 40: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditVcsRootPageUrl";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateConfigurationPageUrl";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateProjectPageUrl";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverviewUrl";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditNotificationsUrl";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditBuildFeaturesUrl";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginUrl";
                break;
            }
            case 54: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestDetailsUrl";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getResponsibilitiesUrl";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutedProblemsUrl";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "makeBuildUrl";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareUrl";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareProjectUrl";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareProjectUrlByExternalBuildTypeId";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareProjectUrlByInternalBuildTypeId";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareProjectUrlByBuildTypeTemplateExternalId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getViewResultsUrl";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 59: 
            case 61: 
            case 63: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 74: 
            case 76: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getViewChangesUrl";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getViewLogUrl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getViewArtifactsUrl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBuildParametersUrl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getBuildDependenciesUrl";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDownloadArtefactUrl";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDownloadAllArtefactsUrl";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getQueuedBuildUrl";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getPersonalQueuedBuildUrl";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationHomePageUrl";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getProjectPageUrl";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getEditProjectPageUrl";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getEditConfigurationPageUrl";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getEditTemplatePageUrl";
                break;
            }
            case 39: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getEditVcsRootPageUrl";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getCreateConfigurationPageUrl";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getCreateProjectPageUrl";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getEditNotificationsUrl";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getEditBuildFeaturesUrl";
                break;
            }
            case 53: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getTestDetailsUrl";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getResponsibilitiesUrl";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getMutedProblemsUrl";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "makeBuildUrl";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getAgentUrl";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "prepareUrl";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "prepareProjectUrl";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "prepareProjectUrlByExternalBuildTypeId";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "prepareProjectUrlByInternalBuildTypeId";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "prepareProjectUrlByBuildTypeTemplateExternalId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 59: 
            case 61: 
            case 63: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 74: 
            case 76: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

