/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide;

import org.jetbrains.annotations.NotNull;

public class TestGroupName
implements Comparable<TestGroupName> {
    private final String mySuite;
    private final String myPackageName;
    private final String myShortClassName;
    private String myFullNameCache;

    public TestGroupName() {
        this("*", "*", "*");
    }

    public TestGroupName(@NotNull String suite, @NotNull String aPackage, @NotNull String shortClassName) {
        if (suite == null) {
            TestGroupName.$$$reportNull$$$0(0);
        }
        if (aPackage == null) {
            TestGroupName.$$$reportNull$$$0(1);
        }
        if (shortClassName == null) {
            TestGroupName.$$$reportNull$$$0(2);
        }
        this.mySuite = suite.endsWith(": ") ? suite.substring(0, suite.length() - 2) : suite;
        this.myPackageName = aPackage;
        this.myShortClassName = shortClassName;
    }

    @NotNull
    public String getSuite() {
        String string = this.mySuite;
        if (string == null) {
            TestGroupName.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getPackageName() {
        String string = this.myPackageName;
        if (string == null) {
            TestGroupName.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getClassName() {
        String string = this.myShortClassName;
        if (string == null) {
            TestGroupName.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean isPackageSet() {
        return TestGroupName.notEmpty(this.myPackageName);
    }

    public boolean isClassNameSet() {
        return TestGroupName.notEmpty(this.myShortClassName);
    }

    public boolean isSuiteSet() {
        return TestGroupName.notEmpty(this.mySuite);
    }

    public boolean isEmpty1() {
        return "*".equals(this.mySuite) && "*".equals(this.myPackageName) && "*".equals(this.myShortClassName);
    }

    public boolean includes(TestGroupName tg) {
        return this.match(this.getClassName(), tg.getClassName()) && this.match(this.getPackageName(), tg.getPackageName()) && this.match(this.getSuite(), tg.getSuite());
    }

    private boolean match(String s, String other) {
        if ("*".equals(s)) {
            return true;
        }
        if (s.length() == 0) {
            return TestGroupName.val(other).length() == 0;
        }
        return s.equals(other);
    }

    private static String val(String s) {
        return "*".equals(s) ? "" : s;
    }

    @NotNull
    public String getFullName() {
        if (this.myFullNameCache == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(TestGroupName.val(this.getSuite()));
            if (TestGroupName.notEmpty(sb.toString()) && (TestGroupName.notEmpty(this.getClassName()) || TestGroupName.notEmpty(this.getPackageName()))) {
                sb.append(": ");
            }
            if (TestGroupName.notEmpty(this.getPackageName())) {
                sb.append(TestGroupName.val(this.getPackageName()));
                if (TestGroupName.notEmpty(this.getClassName())) {
                    sb.append('.');
                }
            }
            sb.append(TestGroupName.val(this.getClassName()));
            this.myFullNameCache = sb.toString();
        }
        String string = this.myFullNameCache;
        if (string == null) {
            TestGroupName.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static boolean notEmpty(String s) {
        return TestGroupName.val(s).length() > 0;
    }

    @Override
    public int compareTo(TestGroupName o) {
        int res = this.mySuite.compareTo(o.mySuite);
        if (res != 0) {
            return res;
        }
        res = this.myPackageName.compareTo(o.myPackageName);
        if (res != 0) {
            return res;
        }
        res = this.myShortClassName.compareTo(o.myShortClassName);
        if (res != 0) {
            return res;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestGroupName that = (TestGroupName)o;
        return this.myPackageName.equals(that.myPackageName) && this.myShortClassName.equals(that.myShortClassName) && this.mySuite.equals(that.mySuite);
    }

    public int hashCode() {
        int result = this.mySuite.hashCode();
        result = 31 * result + this.myPackageName.hashCode();
        result = 31 * result + this.myShortClassName.hashCode();
        return result;
    }

    public String toString() {
        return this.getFullName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortClassName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/serverSide/TestGroupName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/serverSide/TestGroupName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuite";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

