/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide.auth;

import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.ExceptionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuthenticationFailedException
extends RuntimeException {
    @NotNull
    public static final String INCORRECT_USERNAME_OR_PASSWORD = "Incorrect username or password.";
    @NotNull
    public static final String INTERNAL_ERROR_HAS_OCCURRED = "An error in configuration or an internal error occurred during login. Please contact your system administrator.";
    @Nullable
    private final String myUserMessage;
    private final boolean myInternalError;

    public AuthenticationFailedException() {
        this((String)null);
    }

    public AuthenticationFailedException(@Nullable String adminMessage) {
        this(adminMessage, null);
    }

    public AuthenticationFailedException(@Nullable String adminMessage, @Nullable Throwable cause) {
        this(adminMessage, cause, true);
    }

    public AuthenticationFailedException(@Nullable String userMessage, @Nullable Throwable cause, boolean internalError) {
        this(internalError ? null : userMessage, userMessage == null ? INCORRECT_USERNAME_OR_PASSWORD : userMessage, cause, internalError && userMessage != null);
    }

    public AuthenticationFailedException(@Nullable String userMessage, @NotNull String adminMessage, @Nullable Throwable cause, boolean internalError) {
        if (adminMessage == null) {
            AuthenticationFailedException.$$$reportNull$$$0(0);
        }
        super(adminMessage, cause);
        this.myUserMessage = userMessage;
        this.myInternalError = internalError;
    }

    public boolean isInternalError() {
        return this.myInternalError;
    }

    @NotNull
    public String getUserMessage() {
        if (AuthenticationFailedException.mustShowDetails()) {
            String string = ExceptionUtil.getDisplayMessage((Throwable)this);
            if (string == null) {
                AuthenticationFailedException.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (this.myUserMessage != null) {
            String string = this.myUserMessage;
            if (string == null) {
                AuthenticationFailedException.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (this.myInternalError) {
            if (INTERNAL_ERROR_HAS_OCCURRED == null) {
                AuthenticationFailedException.$$$reportNull$$$0(3);
            }
            return INTERNAL_ERROR_HAS_OCCURRED;
        }
        if (INCORRECT_USERNAME_OR_PASSWORD == null) {
            AuthenticationFailedException.$$$reportNull$$$0(4);
        }
        return INCORRECT_USERNAME_OR_PASSWORD;
    }

    public static boolean mustShowDetails() {
        return TeamCityProperties.getBoolean((String)"teamcity.authentication.error.showDetails");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adminMessage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/serverSide/auth/AuthenticationFailedException";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/serverSide/auth/AuthenticationFailedException";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

