/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide.auth;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import jetbrains.buildServer.util.ReadOnlyBitSet;
import org.jetbrains.annotations.NotNull;

public enum Permission {
    RUN_BUILD(0, true, "Run build"),
    CANCEL_BUILD(2, true, "Stop build / remove from queue"),
    CANCEL_ANY_PERSONAL_BUILD(3, true, "Stop / remove from queue any personal build"),
    PIN_UNPIN_BUILD(4, true, "Pin / unpin build"),
    TAG_BUILD(5, true, "Tag build"),
    REMOVE_BUILD(86, true, "Remove finished build"),
    PAUSE_ACTIVATE_BUILD_CONFIGURATION(6, true, "Pause / activate build configuration"),
    COMMENT_BUILD(7, true, "Comment build"),
    CLEAN_BUILD_CONFIGURATION_SOURCES(8, true, "Clean build configuration sources"),
    ASSIGN_INVESTIGATION(9, true, "Assign / unassign investigation"),
    VIEW_PROJECT(10, true, "View project and all parent projects"),
    VIEW_BUILD_CONFIGURATION_SETTINGS(12, true, "View build configuration settings"),
    VIEW_FILE_CONTENT(14, true, "View VCS file content"),
    EDIT_VCS_MODIFICATION(15, true, "Edit VCS change description"),
    EDIT_PROJECT(20, true, "Edit project"),
    CHANGE_CLEANUP_RULES(22, true, "Change cleanup rules"),
    BACKUP(23, false, "Change backup settings and control backup process"),
    IMPORT_PROJECTS(87, false, "Import projects"),
    CUSTOMIZE_BUILD_PARAMETERS(24, true, "Customize build parameters"),
    CUSTOMIZE_BUILD_REVISIONS(26, true, "Customize build revisions"),
    CREATE_SUB_PROJECT(30, true, "Create subproject"),
    DELETE_SUB_PROJECT(31, true, "Delete subproject"),
    CREATE_DELETE_VCS_ROOT(32, true, "Create / delete VCS root"),
    CHANGE_USER_ROLES_IN_PROJECT(35, true, "Change user roles in project"),
    LABEL_BUILD(36, true, "Manually label / merge build sources"),
    ARCHIVE_PROJECT(37, true, "Archive / dearchive project"),
    MANAGE_BUILD_PROBLEMS(38, true, "Mute / unmute problems in project"),
    MANAGE_BUILD_PROBLEM_INSTANCES(85, true, "Change build status"),
    VIEW_BUILD_RUNTIME_DATA(39, true, "View build runtime parameters and data"),
    MANAGE_AGENT_POOLS_FOR_PROJECT(84, true, "Change agent pools associated with project"),
    EDIT_VERSIONED_SETTINGS(88, true, "Enable / disable versioned settings"),
    EDIT_ENFORCED_SETTINGS(97, true, "Enable / disable enforced settings in project"),
    ENABLE_DISABLE_AGENT_FOR_PROJECT(89, true, "Enable / disable agents associated with project"),
    CHANGE_AGENT_RUN_CONFIGURATION_POLICY_FOR_PROJECT(91, true, "Change agent run configuration policy for project"),
    ADMINISTER_AGENT_FOR_PROJECT(92, true, "Administer project agent machines (e.g. reboot, view agent logs, etc.)"),
    REMOVE_AGENT_FOR_PROJECT(93, true, "Remove project agent"),
    AUTHORIZE_AGENT_FOR_PROJECT(94, true, "Authorize project agent"),
    VIEW_AGENT_DETAILS_FOR_PROJECT(98, true, "View project agents details"),
    MANAGE_AGENT_CLOUDS(78, true, "Manage project's agent cloud profiles"),
    VIEW_AGENT_CLOUDS(77, true, "View cloud images and instances"),
    START_STOP_CLOUD_AGENT(79, true, "Start / Stop cloud agent"),
    CHANGE_USER_NOTIFICATIONS_IN_PROJECT(100, true, "Change user / group notification rules in project"),
    CREATE_USER(40, false, "Create user account"),
    DELETE_USER(41, false, "Delete user account"),
    CHANGE_USER(42, false, "Modify user profile and roles"),
    CHANGE_USER_NOTIFICATIONS(43, false, "Change user / group notification rules"),
    MANAGE_SERVER_LICENSES(44, false, "Manage server licenses"),
    CHANGE_SERVER_SETTINGS(45, false, "Change server settings"),
    MANAGE_AUTHENTICATION_SETTINGS(101, false, "Manage authentication settings"),
    CHANGE_AGENT_RUN_CONFIGURATION_POLICY(46, false, "Change agent run configuration policy"),
    CLEAN_AGENT_SOURCES(47, false, "Clean sources on agent"),
    ENABLE_DISABLE_AGENT(50, false, "Enable / disable agent"),
    AUTHORIZE_AGENT(52, false, "Authorize agent"),
    VIEW_AGENT_DETAILS(53, false, "View agent details"),
    MANAGE_CUSTOM_SSL_CERTIFICATES(102, false, "Manage custom SSL/HTTPS certificates"),
    CONFIGURE_SERVER_DATA_CLEANUP(54, false, "Configure server data cleanup"),
    CHANGE_OWN_PROFILE(56, false, "Change own profile"),
    VIEW_AGENT_USAGE_STATISTICS(58, false, "View agent usage statistics"),
    REMOVE_AGENT(60, false, "Remove agent"),
    CREATE_USERGROUP(70, false, "Create user group"),
    DELETE_USERGROUP(71, false, "Delete user group"),
    CHANGE_USERGROUP(72, false, "Modify user group (name, description and roles)"),
    ASSIGN_USERS_ADD_SUBGROUPS(73, false, "Assign / unassign users to groups or change groups hierarchy"),
    MANAGE_ROLES(74, false, "Manage roles (create, delete, change permissions)"),
    ADMINISTER_AGENT(75, false, "Administer build agent machines (e.g. reboot, view agent logs, etc.)"),
    VIEW_AUDIT_LOG(76, false, "View audit log"),
    REORDER_BUILD_QUEUE(34, false, "Reorder builds in queue"),
    VIEW_SERVER_ERRORS(80, false, "View server errors"),
    VIEW_USAGE_STATISTICS(81, false, "View usage statistics"),
    MANAGE_AGENT_POOLS(82, false, "Manage agent pools"),
    VIEW_USER_PROFILE(83, false, "View user profile"),
    VIEW_ALL_USERS(95, false, "View all registered users"),
    MANAGE_SERVER_INSTALLATION(96, false, "Manage server installation: view logs, restart, etc."),
    VIEW_SERVER_SETTINGS(99, false, "View server settings");

    private final BitSet myBitSet;
    private final boolean myProjectAssociationSupported;
    private final String myDescription;
    private final int myIndex;
    private static final Map<String, Permission> ALL_PERMISSIONS_MAP;
    private static final Map<Integer, Permission> PERMISSIONS_INDEX_MAP;

    private Permission(@NotNull int index, boolean projectAssociationSupported, String description) {
        if (description == null) {
            Permission.$$$reportNull$$$0(0);
        }
        this.myBitSet = new ReadOnlyBitSet(index);
        this.myProjectAssociationSupported = projectAssociationSupported;
        this.myDescription = description;
        this.myIndex = index;
    }

    public int getIndex() {
        return this.myIndex;
    }

    public BitSet getMask() {
        return this.myBitSet;
    }

    public boolean isProjectAssociationSupported() {
        return this.myProjectAssociationSupported;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public static Permission lookupPermission(String name) {
        return ALL_PERMISSIONS_MAP.get(name);
    }

    public static Permission lookupPermission(int index) {
        return PERMISSIONS_INDEX_MAP.get(index);
    }

    public String getName() {
        return this.name();
    }

    public String toString() {
        return this.name() + " (" + this.myDescription + ")";
    }

    static {
        ALL_PERMISSIONS_MAP = new HashMap<String, Permission>();
        PERMISSIONS_INDEX_MAP = new HashMap<Integer, Permission>();
        for (Permission p : Permission.values()) {
            ALL_PERMISSIONS_MAP.put(p.name(), p);
            PERMISSIONS_INDEX_MAP.put(p.getMask().length() - 1, p);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "jetbrains/buildServer/serverSide/auth/Permission", "<init>"));
    }
}

