/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide.auth;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jetbrains.buildServer.serverSide.auth.AuthorityHolder;
import jetbrains.buildServer.serverSide.auth.Permission;
import jetbrains.buildServer.serverSide.auth.Permissions;
import jetbrains.buildServer.serverSide.auth.PermissionsPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PermissionsHolder {
    private static Permissions ourProjectAssociatedPermissions = null;
    private Permissions myGlobalPermissions;
    private Map<String, Permissions> myProjectPermissions;
    private Permissions myProjectRelatedGlobalPermissions;

    public PermissionsHolder() {
        this.myGlobalPermissions = Permissions.NO_PERMISSIONS;
        this.myProjectPermissions = Collections.emptyMap();
        this.myProjectRelatedGlobalPermissions = Permissions.NO_PERMISSIONS;
    }

    @Deprecated
    public PermissionsHolder(@NotNull AuthorityHolder authorityHolder) {
        if (authorityHolder == null) {
            PermissionsHolder.$$$reportNull$$$0(0);
        }
        this.myGlobalPermissions = Permissions.NO_PERMISSIONS;
        this.myProjectPermissions = Collections.emptyMap();
        this.myProjectRelatedGlobalPermissions = Permissions.NO_PERMISSIONS;
        this.setPermissions(authorityHolder.getGlobalPermissions(), authorityHolder.getProjectsPermissions());
    }

    public void setPermissions(@NotNull Permissions globalPermissions, @NotNull Map<String, Permissions> projectPermissions) {
        if (globalPermissions == null) {
            PermissionsHolder.$$$reportNull$$$0(1);
        }
        if (projectPermissions == null) {
            PermissionsHolder.$$$reportNull$$$0(2);
        }
        BitSet globalPerms = new BitSet();
        globalPerms.or(globalPermissions.getMask());
        for (Permissions perms : projectPermissions.values()) {
            BitSet bitSet = new BitSet();
            bitSet.or(perms.getMask());
            bitSet.andNot(ourProjectAssociatedPermissions.getMask());
            globalPerms.or(bitSet);
        }
        this.myGlobalPermissions = PermissionsPool.getFromPool(globalPerms);
        BitSet projectRelatedGlobalPerms = new BitSet();
        projectRelatedGlobalPerms.or(globalPerms);
        projectRelatedGlobalPerms.and(ourProjectAssociatedPermissions.getMask());
        this.myProjectRelatedGlobalPermissions = PermissionsPool.getFromPool(projectRelatedGlobalPerms);
        HashMap<String, Permissions> actualProjectPermissions = new HashMap<String, Permissions>();
        for (Map.Entry<String, Permissions> prjEntry : projectPermissions.entrySet()) {
            BitSet prjPerms = new BitSet();
            prjPerms.or(prjEntry.getValue().getMask());
            prjPerms.or(projectRelatedGlobalPerms);
            actualProjectPermissions.put(prjEntry.getKey(), PermissionsPool.getFromPool(prjPerms));
        }
        this.myProjectPermissions = actualProjectPermissions;
    }

    public boolean isPermissionGrantedGlobally(@NotNull Permission permission) {
        if (permission == null) {
            PermissionsHolder.$$$reportNull$$$0(3);
        }
        return this.myGlobalPermissions.contains(permission);
    }

    public boolean isPermissionGrantedForProject(@NotNull String projectId, @NotNull Permission permission) {
        if (projectId == null) {
            PermissionsHolder.$$$reportNull$$$0(4);
        }
        if (permission == null) {
            PermissionsHolder.$$$reportNull$$$0(5);
        }
        return permission.isProjectAssociationSupported() && this.getPermissionsGrantedForProject(projectId).contains(permission);
    }

    public boolean isPermissionGrantedForAnyProject(@NotNull Permission permission) {
        if (permission == null) {
            PermissionsHolder.$$$reportNull$$$0(6);
        }
        if (this.myGlobalPermissions.contains(permission)) {
            return true;
        }
        for (Permissions perms : this.myProjectPermissions.values()) {
            if (!perms.contains(permission)) continue;
            return true;
        }
        return false;
    }

    public boolean isPermissionGrantedForAnyOfProjects(Collection<String> projectIds, Permission permission) {
        if (this.myGlobalPermissions.contains(permission)) {
            return true;
        }
        for (String projectId : projectIds) {
            if (!this.isPermissionGrantedForProject(projectId, permission)) continue;
            return true;
        }
        return false;
    }

    public boolean isPermissionGrantedForAllProjects(Collection<String> projectIds, @NotNull Permission permission) {
        if (permission == null) {
            PermissionsHolder.$$$reportNull$$$0(7);
        }
        if (projectIds.size() == 0) {
            return false;
        }
        for (String projectId : projectIds) {
            if (this.isPermissionGrantedForProject(projectId, permission)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Permissions getGlobalPermissions() {
        Permissions permissions = this.getPermissions(this.myGlobalPermissions);
        if (permissions == null) {
            PermissionsHolder.$$$reportNull$$$0(8);
        }
        return permissions;
    }

    @NotNull
    public Map<String, Permissions> getProjectsPermissions() {
        Map<String, Permissions> map = Collections.unmodifiableMap(this.myProjectPermissions);
        if (map == null) {
            PermissionsHolder.$$$reportNull$$$0(9);
        }
        return map;
    }

    @NotNull
    public Permissions getPermissionsGrantedForProject(@NotNull String projectId) {
        Permissions res;
        if (projectId == null) {
            PermissionsHolder.$$$reportNull$$$0(10);
        }
        if ((res = this.myProjectPermissions.get(projectId)) != null) {
            Permissions permissions = res;
            if (permissions == null) {
                PermissionsHolder.$$$reportNull$$$0(11);
            }
            return permissions;
        }
        Permissions permissions = this.myProjectRelatedGlobalPermissions;
        if (permissions == null) {
            PermissionsHolder.$$$reportNull$$$0(12);
        }
        return permissions;
    }

    @NotNull
    public Permissions getPermissionsGrantedForAllProjects(@NotNull Collection<String> projectIds) {
        Iterator<String> it;
        if (projectIds == null) {
            PermissionsHolder.$$$reportNull$$$0(13);
        }
        if (!(it = projectIds.iterator()).hasNext()) {
            Permissions permissions = new Permissions(new Permission[0]);
            if (permissions == null) {
                PermissionsHolder.$$$reportNull$$$0(14);
            }
            return permissions;
        }
        BitSet permissionsMask = new BitSet();
        permissionsMask.or(this.getPermissionsGrantedForProject(it.next()).getMask());
        while (it.hasNext()) {
            if (permissionsMask.isEmpty()) {
                Permissions permissions = new Permissions(new Permission[0]);
                if (permissions == null) {
                    PermissionsHolder.$$$reportNull$$$0(15);
                }
                return permissions;
            }
            permissionsMask.and(this.getPermissionsGrantedForProject(it.next()).getMask());
        }
        Permissions permissions = new Permissions(permissionsMask);
        if (permissions == null) {
            PermissionsHolder.$$$reportNull$$$0(16);
        }
        return permissions;
    }

    @NotNull
    public Permissions getPermissionsGrantedForAnyOfProjects(@NotNull Collection<String> projectIds) {
        Iterator<String> it;
        if (projectIds == null) {
            PermissionsHolder.$$$reportNull$$$0(17);
        }
        if (!(it = projectIds.iterator()).hasNext()) {
            Permissions permissions = new Permissions(new Permission[0]);
            if (permissions == null) {
                PermissionsHolder.$$$reportNull$$$0(18);
            }
            return permissions;
        }
        BitSet permissionsMask = new BitSet();
        while (it.hasNext()) {
            permissionsMask.or(this.getPermissionsGrantedForProject(it.next()).getMask());
        }
        Permissions permissions = new Permissions(permissionsMask);
        if (permissions == null) {
            PermissionsHolder.$$$reportNull$$$0(19);
        }
        return permissions;
    }

    @NotNull
    private Permissions getPermissions(@Nullable Permissions perms) {
        if (perms == null) {
            Permissions permissions = Permissions.NO_PERMISSIONS;
            if (permissions == null) {
                PermissionsHolder.$$$reportNull$$$0(20);
            }
            return permissions;
        }
        Permissions permissions = perms;
        if (permissions == null) {
            PermissionsHolder.$$$reportNull$$$0(21);
        }
        return permissions;
    }

    static {
        ArrayList<Permission> perms = new ArrayList<Permission>();
        for (Permission p : Permission.values()) {
            if (!p.isProjectAssociationSupported()) continue;
            perms.add(p);
        }
        ourProjectAssociatedPermissions = new Permissions(perms);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authorityHolder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalPermissions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPermissions";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permission";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectId";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/serverSide/auth/PermissionsHolder";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/serverSide/auth/PermissionsHolder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalPermissions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectsPermissions";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPermissionsGrantedForProject";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPermissionsGrantedForAllProjects";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPermissionsGrantedForAnyOfProjects";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPermissions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setPermissions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isPermissionGrantedGlobally";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isPermissionGrantedForProject";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isPermissionGrantedForAnyProject";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isPermissionGrantedForAllProjects";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPermissionsGrantedForProject";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPermissionsGrantedForAllProjects";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPermissionsGrantedForAnyOfProjects";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

