/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide.tracker;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jetbrains.buildServer.serverSide.tracker.EventSubscription;
import jetbrains.buildServer.serverSide.tracker.EventTracker;
import jetbrains.buildServer.serverSide.tracker.TrackerEventType;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SubscriptionsCollection {
    private final Set<EventSubscription> mySubscriptions;
    @NonNls
    private static final String PROJECT_EVENT_PREFIX = "p:";
    @NonNls
    private static final String BUILD_TYPE_EVENT_PREFIX = "b:";
    @NonNls
    private static final String USER_EVENT_PREFIX = "u:";
    @NonNls
    private static final String AGENT_EVENT_PREFIX = "a:";
    private final SubscriptionFactory mySubscriptionFactory;

    public SubscriptionsCollection() {
        this.mySubscriptions = new HashSet<EventSubscription>();
        this.mySubscriptionFactory = new SubscriptionFactory();
    }

    public SubscriptionsCollection(@NotNull String serializedSubscription) throws IllegalArgumentException {
        if (serializedSubscription == null) {
            SubscriptionsCollection.$$$reportNull$$$0(0);
        }
        this.mySubscriptions = new HashSet<EventSubscription>();
        this.mySubscriptionFactory = new SubscriptionFactory();
        for (String part : StringUtil.split((String)serializedSubscription, (boolean)true, (char[])new char[]{','})) {
            EventSubscription subs;
            if (part.length() == 0 || (subs = this.mySubscriptionFactory.deserializeSubscription(part)) == null) continue;
            this.mySubscriptions.add(subs);
        }
    }

    public void subscribeOnProjectEvent(@NotNull TrackerEventType event, @NotNull String projectId) {
        if (event == null) {
            SubscriptionsCollection.$$$reportNull$$$0(1);
        }
        if (projectId == null) {
            SubscriptionsCollection.$$$reportNull$$$0(2);
        }
        this.mySubscriptions.add(this.mySubscriptionFactory.createProjectSubscription(event, projectId));
    }

    public void subscribeOnBuildTypeEvent(@NotNull TrackerEventType event, @NotNull String buildTypeId) {
        if (event == null) {
            SubscriptionsCollection.$$$reportNull$$$0(3);
        }
        if (buildTypeId == null) {
            SubscriptionsCollection.$$$reportNull$$$0(4);
        }
        this.mySubscriptions.add(this.mySubscriptionFactory.createBuildTypeSubscription(event, buildTypeId));
    }

    public void subscribeOnUserEvent(@NotNull TrackerEventType event, long userId) {
        if (event == null) {
            SubscriptionsCollection.$$$reportNull$$$0(5);
        }
        this.mySubscriptions.add(this.mySubscriptionFactory.createUserSubscription(event, userId));
    }

    public void subscribeOnEvent(@NotNull TrackerEventType event) {
        if (event == null) {
            SubscriptionsCollection.$$$reportNull$$$0(6);
        }
        this.mySubscriptions.add(this.mySubscriptionFactory.createGlobalSubscription(event));
    }

    public String serialize() {
        StringBuilder builder = new StringBuilder();
        for (EventSubscription s : this.mySubscriptions) {
            builder.append(s.serialize()).append(',');
        }
        return builder.toString();
    }

    public Collection<EventSubscription> getSubscriptions() {
        return Collections.unmodifiableCollection(this.mySubscriptions);
    }

    public int getTotalNumberOfEvents(@NotNull EventTracker tracker) {
        if (tracker == null) {
            SubscriptionsCollection.$$$reportNull$$$0(7);
        }
        int result = 0;
        for (EventSubscription es : this.getSubscriptions()) {
            result += es.getNumberOfEvents(tracker);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializedSubscription";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildTypeId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/serverSide/tracker/SubscriptionsCollection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "subscribeOnProjectEvent";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "subscribeOnBuildTypeEvent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "subscribeOnUserEvent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "subscribeOnEvent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getTotalNumberOfEvents";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static abstract class BaseSubscription
    implements EventSubscription {
        private final TrackerEventType myEvent;

        protected BaseSubscription(TrackerEventType event) {
            this.myEvent = event;
        }

        @Override
        @NotNull
        public String serialize() {
            String string = this.myEvent.getShortCode() + ";" + this.serializeParameters();
            if (string == null) {
                BaseSubscription.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        protected abstract String serializeParameters();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BaseSubscription that = (BaseSubscription)o;
            return this.serialize().equals(that.serialize());
        }

        public int hashCode() {
            return this.serialize().hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/serverSide/tracker/SubscriptionsCollection$BaseSubscription", "serialize"));
        }
    }

    public static class SubscriptionFactory {
        public EventSubscription createProjectSubscription(final @NotNull TrackerEventType event, final @NotNull String projectId) {
            if (event == null) {
                SubscriptionFactory.$$$reportNull$$$0(0);
            }
            if (projectId == null) {
                SubscriptionFactory.$$$reportNull$$$0(1);
            }
            return new BaseSubscription(event){

                @Override
                public int getNumberOfEvents(@NotNull EventTracker tracker) {
                    if (tracker == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return tracker.getNumberOfProjectEvents(event, projectId);
                }

                @Override
                @NotNull
                protected String serializeParameters() {
                    String string = SubscriptionsCollection.PROJECT_EVENT_PREFIX + projectId;
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "tracker";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "jetbrains/buildServer/serverSide/tracker/SubscriptionsCollection$SubscriptionFactory$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "jetbrains/buildServer/serverSide/tracker/SubscriptionsCollection$SubscriptionFactory$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "serializeParameters";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getNumberOfEvents";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }

        public EventSubscription createBuildTypeSubscription(final @NotNull TrackerEventType event, final @NotNull String buildTypeId) {
            if (event == null) {
                SubscriptionFactory.$$$reportNull$$$0(2);
            }
            if (buildTypeId == null) {
                SubscriptionFactory.$$$reportNull$$$0(3);
            }
            return new BaseSubscription(event){

                @Override
                public int getNumberOfEvents(@NotNull EventTracker tracker) {
                    if (tracker == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return tracker.getNumberOfBuildTypeEvents(event, buildTypeId);
                }

                @Override
                @NotNull
                protected String serializeParameters() {
                    String string = SubscriptionsCollection.BUILD_TYPE_EVENT_PREFIX + buildTypeId;
                    if (string == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "tracker";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "jetbrains/buildServer/serverSide/tracker/SubscriptionsCollection$SubscriptionFactory$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "jetbrains/buildServer/serverSide/tracker/SubscriptionsCollection$SubscriptionFactory$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "serializeParameters";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getNumberOfEvents";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }

        public EventSubscription createUserSubscription(final @NotNull TrackerEventType event, final long userId) {
            if (event == null) {
                SubscriptionFactory.$$$reportNull$$$0(4);
            }
            return new BaseSubscription(event){

                @Override
                public int getNumberOfEvents(@NotNull EventTracker tracker) {
                    if (tracker == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return tracker.getNumberOfUserEvents(event, userId);
                }

                @Override
                @NotNull
                protected String serializeParameters() {
                    String string = SubscriptionsCollection.USER_EVENT_PREFIX + userId;
                    if (string == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "tracker";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "jetbrains/buildServer/serverSide/tracker/SubscriptionsCollection$SubscriptionFactory$3";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "jetbrains/buildServer/serverSide/tracker/SubscriptionsCollection$SubscriptionFactory$3";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "serializeParameters";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getNumberOfEvents";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }

        public EventSubscription createAgentSubscription(final @NotNull TrackerEventType event, final int agentId) {
            if (event == null) {
                SubscriptionFactory.$$$reportNull$$$0(5);
            }
            return new BaseSubscription(event){

                @Override
                public int getNumberOfEvents(@NotNull EventTracker tracker) {
                    if (tracker == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return tracker.getNumbedOfAgentEvents(event, agentId);
                }

                @Override
                @NotNull
                protected String serializeParameters() {
                    String string = SubscriptionsCollection.AGENT_EVENT_PREFIX + agentId;
                    if (string == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "tracker";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "jetbrains/buildServer/serverSide/tracker/SubscriptionsCollection$SubscriptionFactory$4";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "jetbrains/buildServer/serverSide/tracker/SubscriptionsCollection$SubscriptionFactory$4";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "serializeParameters";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getNumberOfEvents";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }

        public EventSubscription createGlobalSubscription(final @NotNull TrackerEventType event) {
            if (event == null) {
                SubscriptionFactory.$$$reportNull$$$0(6);
            }
            return new BaseSubscription(event){

                @Override
                public int getNumberOfEvents(@NotNull EventTracker tracker) {
                    if (tracker == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    return tracker.getNumberOfEvents(event);
                }

                @Override
                @NotNull
                protected String serializeParameters() {
                    if ("" == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    return "";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "tracker";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "jetbrains/buildServer/serverSide/tracker/SubscriptionsCollection$SubscriptionFactory$5";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "jetbrains/buildServer/serverSide/tracker/SubscriptionsCollection$SubscriptionFactory$5";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "serializeParameters";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getNumberOfEvents";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }

        private EventSubscription deserializeSubscription(@NotNull String serialized) {
            TrackerEventType eventType;
            List subParts;
            if (serialized == null) {
                SubscriptionFactory.$$$reportNull$$$0(7);
            }
            if ((subParts = StringUtil.split((String)serialized, (boolean)true, (char[])new char[]{';'})).size() == 0) {
                return null;
            }
            char eventCode = ((String)subParts.get(0)).charAt(0);
            try {
                eventType = TrackerEventType.findByCode(eventCode);
            }
            catch (Throwable e) {
                eventType = TrackerEventType.valueOf((String)subParts.get(0));
            }
            if (subParts.size() == 1) {
                return this.createGlobalSubscription(eventType);
            }
            String paramPart = (String)subParts.get(1);
            if (paramPart.startsWith(SubscriptionsCollection.PROJECT_EVENT_PREFIX)) {
                return this.createProjectSubscription(eventType, paramPart.substring(SubscriptionsCollection.PROJECT_EVENT_PREFIX.length()));
            }
            if (paramPart.startsWith(SubscriptionsCollection.BUILD_TYPE_EVENT_PREFIX)) {
                return this.createBuildTypeSubscription(eventType, paramPart.substring(SubscriptionsCollection.BUILD_TYPE_EVENT_PREFIX.length()));
            }
            if (paramPart.startsWith(SubscriptionsCollection.USER_EVENT_PREFIX)) {
                String userIdStr = paramPart.substring(SubscriptionsCollection.USER_EVENT_PREFIX.length());
                try {
                    return this.createUserSubscription(eventType, Long.parseLong(userIdStr));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            if (paramPart.startsWith(SubscriptionsCollection.AGENT_EVENT_PREFIX)) {
                String agentIdStr = paramPart.substring(SubscriptionsCollection.AGENT_EVENT_PREFIX.length());
                try {
                    return this.createAgentSubscription(eventType, Integer.parseInt(agentIdStr));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectId";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildTypeId";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serialized";
                    break;
                }
            }
            objectArray2[1] = "jetbrains/buildServer/serverSide/tracker/SubscriptionsCollection$SubscriptionFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createProjectSubscription";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createBuildTypeSubscription";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createUserSubscription";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createAgentSubscription";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createGlobalSubscription";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deserializeSubscription";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

