/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide.userChanges;

import java.util.List;
import jetbrains.buildServer.messages.Status;
import jetbrains.buildServer.serverSide.userChanges.PersonalChangeCommitDecision;
import jetbrains.buildServer.serverSide.userChanges.PreTestedCommitType;

public class PersonalChangeDescriptor {
    private final long myId;
    private final long myUserId;
    private final int myCommitType;
    private final Status myStatus;
    private final String myCommitDecision;

    public PersonalChangeDescriptor(long id, long userId, PreTestedCommitType commitType, Status status, PersonalChangeCommitDecision commitDecision) {
        this.myId = id;
        this.myUserId = userId;
        this.myCommitType = commitType.getId();
        this.myStatus = status;
        this.myCommitDecision = commitDecision.toString();
    }

    @Deprecated
    public PersonalChangeDescriptor(long id, long userId, PreTestedCommitType commitType, Status status, PersonalChangeCommitDecision commitDecision, List<Long> showNotificationsFor) {
        this(id, userId, commitType, status, commitDecision);
    }

    public PersonalChangeDescriptor(PersonalChangeDescriptor descriptor) {
        this.myId = descriptor.myId;
        this.myUserId = descriptor.myUserId;
        this.myCommitType = descriptor.myCommitType;
        this.myStatus = descriptor.myStatus;
        this.myCommitDecision = descriptor.myCommitDecision;
    }

    public long getId() {
        return this.myId;
    }

    public long getUserId() {
        return this.myUserId;
    }

    public PreTestedCommitType getCommitType() {
        return PreTestedCommitType.getById(this.myCommitType);
    }

    public Status getStatus() {
        return this.myStatus;
    }

    public PersonalChangeCommitDecision getPersonalChangeStatus() {
        return PersonalChangeCommitDecision.valueOf(this.myCommitDecision);
    }

    public String getCommitStatusText() {
        if (this.myStatus == Status.NORMAL) {
            return "Commit successful";
        }
        if (this.myStatus.isFailed()) {
            return "Commit failed";
        }
        if (this.myStatus == Status.WARNING) {
            return "Commit was rejected by user";
        }
        if (this.getPersonalChangeStatus() == PersonalChangeCommitDecision.DO_NOT_COMMIT) {
            return "Will not commit";
        }
        if (this.getPersonalChangeStatus() == PersonalChangeCommitDecision.COMMIT) {
            return "Will commit";
        }
        if (this.getPersonalChangeStatus() == PersonalChangeCommitDecision.TRIED_TO_COMMIT) {
            return "Tried to commit";
        }
        if (this.myCommitType == PreTestedCommitType.COMMIT_IF_SUCCESSFUL.getId()) {
            return "Will commit if successful";
        }
        if (this.myCommitType == PreTestedCommitType.COMMIT_IF_NO_NEW_FAILURES.getId()) {
            return "Will commit if no new failures";
        }
        return "N/A";
    }
}

