/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.tests;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import jetbrains.buildServer.tests.ParsePart;
import org.jetbrains.annotations.Nullable;

class TestNameParser {
    private final String myTestName;
    private final List<ParsePart> myParts = new ArrayList<ParsePart>(5);
    private final AtomicInteger myPrevPartStart = new AtomicInteger(0);

    public TestNameParser(String testName) {
        this.myTestName = testName;
    }

    @Nullable
    public String[] doParse() {
        if (this.myTestName.length() > 0 && !Character.isJavaIdentifierStart(this.myTestName.charAt(0))) {
            return null;
        }
        this.splitTestNameAndFillParts();
        if (this.myParts.size() < 2) {
            return null;
        }
        String[] testParts = this.parseMethodAndParameters();
        this.parseClassName(testParts);
        this.parsePackage(testParts);
        return testParts;
    }

    private String[] parseMethodAndParameters() {
        String[] testParts;
        ParsePart methodPart = this.extractLastPart();
        ParamsDetector paramsDetector = new ParamsDetector(methodPart.getPart());
        if (paramsDetector.hasParams()) {
            testParts = new String[4];
            testParts[3] = paramsDetector.getParams();
            testParts[2] = paramsDetector.getMethodName();
        } else {
            testParts = new String[3];
            String methodName = paramsDetector.getMethodName();
            testParts[2] = methodName != null ? methodName : this.myTestName.substring(methodPart.getStartIndex());
        }
        return testParts;
    }

    private void parseClassName(String[] testParts) {
        ParsePart classPart = this.extractLastPart();
        testParts[1] = classPart.getPart();
    }

    private void parsePackage(String[] testParts) {
        if (this.myParts.size() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (ParsePart part : this.myParts) {
            sb.append(part.getPart());
        }
        testParts[0] = sb.toString();
    }

    private ParsePart extractLastPart() {
        ParsePart methodPart = this.myParts.get(this.myParts.size() - 1);
        this.myPrevPartStart.set(methodPart.getStartIndex());
        this.myParts.remove(this.myParts.size() - 1);
        return methodPart;
    }

    private void splitTestNameAndFillParts() {
        int newOffset;
        for (int lastIdx = 0; (newOffset = this.findNextValidName(this.myTestName, lastIdx)) != lastIdx; ++lastIdx) {
            ParsePart parsePart;
            if (newOffset == this.myTestName.length()) {
                parsePart = new ParsePart(this.myTestName.substring(lastIdx, newOffset), lastIdx);
                this.myParts.add(parsePart);
                break;
            }
            int separatorLength = 0;
            boolean stopParsing = true;
            switch (this.myTestName.charAt(newOffset)) {
                case '.': {
                    separatorLength = 1;
                    stopParsing = false;
                    break;
                }
                case ':': {
                    if (newOffset + 1 < this.myTestName.length()) {
                        if (this.myTestName.charAt(newOffset + 1) == ':') {
                            separatorLength = 2;
                            stopParsing = false;
                            break;
                        }
                        if (this.myTestName.charAt(newOffset + 1) == '(' || this.myTestName.charAt(newOffset + 1) == '[') {
                            ++newOffset;
                            break;
                        }
                    }
                    separatorLength = 1;
                    stopParsing = false;
                }
            }
            int endIdx = stopParsing ? this.myTestName.length() : newOffset + separatorLength;
            parsePart = new ParsePart(this.myTestName.substring(lastIdx, endIdx), lastIdx);
            parsePart.setSeparatorLength(separatorLength);
            this.myParts.add(parsePart);
            if (separatorLength == 2) {
                ++newOffset;
            }
            if ((lastIdx = newOffset) == this.myTestName.length() || stopParsing) break;
        }
    }

    private int findNextValidName(String str, int baseOffset) {
        int inRoundBraces = 0;
        int inSquareBraces = 0;
        boolean inQuotes = false;
        int offset = baseOffset;
        block9: while (offset < str.length()) {
            char c = str.charAt(offset);
            switch (c) {
                default: {
                    ++offset;
                    continue block9;
                }
                case '(': {
                    if (!inQuotes) {
                        ++inRoundBraces;
                    }
                    ++offset;
                    continue block9;
                }
                case ')': {
                    if (inRoundBraces > 0 && !inQuotes) {
                        --inRoundBraces;
                    }
                    ++offset;
                    continue block9;
                }
                case '[': {
                    if (!inQuotes) {
                        ++inSquareBraces;
                    }
                    ++offset;
                    continue block9;
                }
                case ']': {
                    if (inSquareBraces > 0 && !inQuotes) {
                        --inSquareBraces;
                    }
                    ++offset;
                    continue block9;
                }
                case '\"': {
                    if (inQuotes) {
                        if (str.charAt(offset - 1) != '\\') {
                            inQuotes = false;
                        }
                    } else if (inRoundBraces > 0 || inSquareBraces > 0) {
                        inQuotes = true;
                    }
                    ++offset;
                    continue block9;
                }
                case '/': {
                    if (offset != baseOffset) break;
                    ++offset;
                    continue block9;
                }
                case '\t': 
                case ' ': 
                case '!': 
                case '#': 
                case '%': 
                case '&': 
                case '\'': 
                case '*': 
                case ',': 
                case '.': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '\\': 
                case '^': 
                case '`': 
                case '{': 
                case '|': 
                case '}': 
                case '~': 
            }
            if (inQuotes || inRoundBraces > 0 || inSquareBraces > 0) {
                ++offset;
                continue;
            }
            if (c == ':' && offset + 1 < str.length() && str.charAt(offset + 1) == '(') {
                ++offset;
                continue;
            }
            return offset;
        }
        return offset;
    }

    private static class ParamsDetector {
        private final String myMethodName;
        private final String myParams;

        public ParamsDetector(String method) {
            int methodEndIndex;
            String params;
            int paramIndex = this.checkForParameters(method);
            this.myParams = paramIndex >= 0 ? ((params = method.substring(paramIndex)).equals("()") ? null : params) : null;
            for (methodEndIndex = paramIndex; methodEndIndex > 0 && !Character.isUnicodeIdentifierPart(method.charAt(methodEndIndex - 1)); --methodEndIndex) {
            }
            this.myMethodName = methodEndIndex > 0 ? method.substring(0, methodEndIndex) : null;
        }

        private int checkForParameters(String method) {
            int openRoundBrace = method.indexOf(40);
            boolean closesWithRoundBrace = method.endsWith(")");
            int openSquareBrace = method.indexOf(91);
            boolean closesWithSquareBrace = method.endsWith("]");
            boolean closesWithBrace = closesWithRoundBrace || closesWithSquareBrace;
            int openBrace = Math.min(openRoundBrace, openSquareBrace);
            if (openBrace <= 0) {
                openBrace = Math.max(openRoundBrace, openSquareBrace);
            }
            if (closesWithBrace && openBrace <= 0) {
                return -1;
            }
            if (!closesWithBrace && openBrace >= 0) {
                return -1;
            }
            if (openBrace > 1 && method.charAt(openBrace - 1) == ' ') {
                return -1;
            }
            return openBrace;
        }

        public boolean hasParams() {
            return this.myParams != null;
        }

        public String getMethodName() {
            return this.myMethodName;
        }

        public String getParams() {
            return this.myParams;
        }
    }
}

