/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.tree.runningBuilds;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.Build;
import jetbrains.buildServer.BuildProject;
import jetbrains.buildServer.BuildType;
import jetbrains.buildServer.messages.Status;
import jetbrains.buildServer.serverProxy.ProxyFactoryListener;
import jetbrains.buildServer.tree.runningBuilds.RunningBuildInfo;
import org.jdom.Element;

public class RunningBuildsHolder
implements ProxyFactoryListener {
    private final Map<Long, RunningBuildInfo> myInfos = new HashMap<Long, RunningBuildInfo>();
    private final Collection<Long> myNewBuilds = new HashSet<Long>();

    public synchronized RunningBuildInfo getInfo(long id) {
        return this.myInfos.get(id);
    }

    public synchronized void updateFrom(List<Element> xmls) {
        for (Element xml : xmls) {
            String buildIdStr = xml.getAttributeValue("buildId");
            try {
                long buildId = Integer.parseInt(buildIdStr);
                if (!this.myInfos.containsKey(buildId)) continue;
                String successfulStr = xml.getAttributeValue("successful");
                String text = xml.getAttributeValue("text");
                try {
                    this.myInfos.put(buildId, new RunningBuildInfo(buildId, text, Boolean.parseBoolean(successfulStr) ? Status.NORMAL : Status.FAILURE));
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    @Override
    public void onProjectCreated(BuildProject project) {
    }

    @Override
    public void onConfigurationCreated(BuildType type) {
    }

    @Override
    public synchronized void onInstanceCreated(Build build) {
        try {
            this.myInfos.put(build.getBuildId(), RunningBuildsHolder.createInfo(build));
        }
        finally {
            this.myNewBuilds.add(build.getBuildId());
        }
    }

    private static RunningBuildInfo createInfo(Build build) {
        return new RunningBuildInfo(build.getBuildId(), build.getStatusDescriptor().getText(), build.getBuildStatus());
    }

    public synchronized void onBeforeUpdate() {
        this.myNewBuilds.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onAfterUpdate() {
        try {
            HashSet<Long> ids = new HashSet<Long>(this.myInfos.keySet());
            for (Long id : ids) {
                if (this.myNewBuilds.contains(id)) continue;
                this.myInfos.remove(id);
            }
        }
        finally {
            this.myNewBuilds.clear();
        }
    }
}

