/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.browser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.browser.Behaviour;
import jetbrains.buildServer.util.browser.Browser;
import jetbrains.buildServer.util.browser.BrowserException;
import jetbrains.buildServer.util.browser.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachingBrowser
implements Browser {
    private final Browser mySrcBrowser;
    private final Element myRoot;
    private final Map<String, CachingElement> myCachedElements;

    public CachingBrowser(@NotNull Browser srcBrowser) {
        if (srcBrowser == null) {
            CachingBrowser.$$$reportNull$$$0(0);
        }
        this.myCachedElements = new HashMap<String, CachingElement>();
        this.mySrcBrowser = srcBrowser;
        this.myRoot = this.createCachingElement(this.mySrcBrowser.getRoot());
    }

    @Override
    @NotNull
    public Element getRoot() throws BrowserException {
        Element element = this.myRoot;
        if (element == null) {
            CachingBrowser.$$$reportNull$$$0(1);
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Element getElement(@NotNull String path) throws BrowserException {
        Element elemByPath;
        if (path == null) {
            CachingBrowser.$$$reportNull$$$0(2);
        }
        String key = this.createKey(path);
        Map<String, CachingElement> map = this.myCachedElements;
        synchronized (map) {
            Element cached = this.myCachedElements.get(key);
            if (cached != null) {
                return cached;
            }
        }
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash != -1) {
            Iterable<Element> children;
            Element cachedParent;
            String prefix = path.substring(0, lastSlash);
            String name = path.substring(lastSlash + 1);
            Map<String, CachingElement> map2 = this.myCachedElements;
            synchronized (map2) {
                cachedParent = this.myCachedElements.get(prefix);
            }
            if (cachedParent != null && !cachedParent.isLeaf() && (children = cachedParent.getChildren()) != null) {
                for (Element e : children) {
                    if (!e.getName().equals(name)) continue;
                    return e;
                }
            }
        }
        if ((elemByPath = this.mySrcBrowser.getElement(path)) != null) {
            return this.createCachingElement(elemByPath);
        }
        return null;
    }

    private String createKey(String path) {
        String res = FileUtil.toSystemIndependentName((String)path);
        if (res.startsWith("./")) {
            res = res.substring(2);
        }
        return res;
    }

    @Override
    @NotNull
    public Behaviour getBehaviour() {
        Behaviour behaviour = this.mySrcBrowser.getBehaviour();
        if (behaviour == null) {
            CachingBrowser.$$$reportNull$$$0(3);
        }
        return behaviour;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private CachingElement createCachingElement(@NotNull Element elem) {
        if (elem == null) {
            CachingBrowser.$$$reportNull$$$0(4);
        }
        Map<String, CachingElement> map = this.myCachedElements;
        // MONITORENTER : map
        String key = this.createKey(elem.getFullName());
        CachingElement cached = this.myCachedElements.get(key);
        if (cached != null) {
            CachingElement cachingElement = cached;
            // MONITOREXIT : map
            if (cachingElement != null) return cachingElement;
            CachingBrowser.$$$reportNull$$$0(5);
            return cachingElement;
        }
        cached = new CachingElement(elem);
        this.myCachedElements.put(key, cached);
        CachingElement cachingElement = cached;
        // MONITOREXIT : map
        if (cachingElement != null) return cachingElement;
        CachingBrowser.$$$reportNull$$$0(6);
        return cachingElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcBrowser";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/browser/CachingBrowser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/browser/CachingBrowser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBehaviour";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createCachingElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCachingElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CachingElement
    implements Element {
        private final Object myChildrenLock;
        private final Element mySrcElem;
        private List<Element> myCachedChildren;

        private CachingElement(Element srcElem) {
            if (srcElem == null) {
                CachingElement.$$$reportNull$$$0(0);
            }
            this.myChildrenLock = new Object();
            this.mySrcElem = srcElem;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.mySrcElem.getName();
            if (string == null) {
                CachingElement.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFullName() {
            String string = this.mySrcElem.getFullName();
            if (string == null) {
                CachingElement.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public boolean isLeaf() {
            return this.mySrcElem.isLeaf();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public Iterable<Element> getChildren() throws BrowserException {
            if (this.isLeaf()) {
                return null;
            }
            Object object = this.myChildrenLock;
            synchronized (object) {
                if (this.myCachedChildren == null) {
                    ArrayList<Element> childrenList = new ArrayList<Element>();
                    Iterable<Element> children = this.mySrcElem.getChildren();
                    if (children != null) {
                        for (Element elem : children) {
                            childrenList.add(CachingBrowser.this.createCachingElement(elem));
                        }
                        this.myCachedChildren = childrenList;
                    }
                }
                return Collections.unmodifiableCollection(this.myCachedChildren);
            }
        }

        @Override
        public boolean isContentAvailable() {
            return this.mySrcElem.isContentAvailable();
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IllegalStateException, IOException, BrowserException {
            InputStream inputStream = this.mySrcElem.getInputStream();
            if (inputStream == null) {
                CachingElement.$$$reportNull$$$0(3);
            }
            return inputStream;
        }

        @Override
        public long getSize() throws IllegalStateException {
            return this.mySrcElem.getSize();
        }

        @Override
        @NotNull
        public Browser getBrowser() {
            CachingBrowser cachingBrowser = CachingBrowser.this;
            if (cachingBrowser == null) {
                CachingElement.$$$reportNull$$$0(4);
            }
            return cachingBrowser;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "srcElem";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/util/browser/CachingBrowser$CachingElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/util/browser/CachingBrowser$CachingElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFullName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInputStream";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBrowser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

