/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.browser;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.browser.Behaviour;
import jetbrains.buildServer.util.browser.Browser;
import jetbrains.buildServer.util.browser.BrowserException;
import jetbrains.buildServer.util.browser.Element;
import jetbrains.buildServer.util.impl.FileAware;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSystemBrowser
implements Browser {
    private final Element myRoot;
    private final File myRootFile;
    private static final String FILE_READ_BUFFER_SIZE_PROP = "teamcity.fileIO.readBufferSize";

    public FileSystemBrowser(@NotNull File root) {
        if (root == null) {
            FileSystemBrowser.$$$reportNull$$$0(0);
        }
        this.myRootFile = root;
        this.myRoot = FileSystemBrowser.createElement(this, this.myRootFile, this.myRootFile);
    }

    public FileSystemBrowser(@NotNull String rootPath) {
        if (rootPath == null) {
            FileSystemBrowser.$$$reportNull$$$0(1);
        }
        this(new File(rootPath));
    }

    @Override
    @NotNull
    public Element getRoot() {
        Element element = this.myRoot;
        if (element == null) {
            FileSystemBrowser.$$$reportNull$$$0(2);
        }
        return element;
    }

    @Override
    @Nullable
    public Element getElement(@NotNull String path) {
        File file;
        if (path == null) {
            FileSystemBrowser.$$$reportNull$$$0(3);
        }
        if (!(file = new File(this.myRootFile.getAbsoluteFile(), path)).exists()) {
            return null;
        }
        if (!FileUtil.isAncestor((File)this.myRootFile.getAbsoluteFile(), (File)file, (boolean)false)) {
            return null;
        }
        return FileSystemBrowser.createElement(this, file, this.myRootFile);
    }

    @Override
    @NotNull
    public Behaviour getBehaviour() {
        Behaviour behaviour = Behaviour.DEFAULT_BEHAVIOUR;
        if (behaviour == null) {
            FileSystemBrowser.$$$reportNull$$$0(4);
        }
        return behaviour;
    }

    @NotNull
    private static Element createElement(@NotNull Browser browser, @NotNull File file, @NotNull File root) {
        if (browser == null) {
            FileSystemBrowser.$$$reportNull$$$0(5);
        }
        if (file == null) {
            FileSystemBrowser.$$$reportNull$$$0(6);
        }
        if (root == null) {
            FileSystemBrowser.$$$reportNull$$$0(7);
        }
        FileElement fileElement = file.isDirectory() ? new DirectoryElement(browser, file, root) : new FileElement(browser, file, root);
        if (fileElement == null) {
            FileSystemBrowser.$$$reportNull$$$0(8);
        }
        return fileElement;
    }

    public static int fileReadBufferSize(@NotNull File file) {
        if (file == null) {
            FileSystemBrowser.$$$reportNull$$$0(9);
        }
        int defaultSize = TeamCityProperties.getInteger((String)FILE_READ_BUFFER_SIZE_PROP, (int)65535);
        long fileSize = file.length();
        if (fileSize <= 8192L) {
            return 8192;
        }
        return fileSize > (long)defaultSize ? defaultSize : (int)fileSize;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/browser/FileSystemBrowser";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/browser/FileSystemBrowser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBehaviour";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fileReadBufferSize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DirectoryElement
    extends FileElement {
        public DirectoryElement(@NotNull Browser browser, @NotNull File file, @NotNull File root) {
            if (browser == null) {
                DirectoryElement.$$$reportNull$$$0(0);
            }
            if (file == null) {
                DirectoryElement.$$$reportNull$$$0(1);
            }
            if (root == null) {
                DirectoryElement.$$$reportNull$$$0(2);
            }
            super(browser, file, root);
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public Iterable<Element> getChildren() throws BrowserException {
            try {
                File[] files = this.getFile().listFiles();
                if (files == null || files.length == 0) {
                    return Collections.emptyList();
                }
                Element[] elements = new Element[files.length];
                for (int i = 0; i < files.length; ++i) {
                    elements[i] = FileSystemBrowser.createElement(this.getBrowser(), files[i], this.getRoot());
                }
                Arrays.sort(elements, new Comparator<Element>(){

                    @Override
                    public int compare(Element o1, Element o2) {
                        boolean isDir2;
                        boolean isDir1 = !o1.isContentAvailable();
                        boolean bl = isDir2 = !o2.isContentAvailable();
                        if (isDir1 && !isDir2) {
                            return -1;
                        }
                        if (!isDir1 && isDir2) {
                            return 1;
                        }
                        return o1.getName().compareToIgnoreCase(o2.getName());
                    }
                });
                return Arrays.asList(elements);
            }
            catch (Exception e) {
                throw new BrowserException(e.getMessage(), e);
            }
        }

        @Override
        public boolean isContentAvailable() {
            return false;
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IllegalStateException, IOException {
            throw new IllegalStateException("Content is not available for a directory");
        }

        @Override
        public long getSize() throws IllegalStateException {
            return -1L;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "browser";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
            }
            objectArray[1] = "jetbrains/buildServer/util/browser/FileSystemBrowser$DirectoryElement";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class FileElement
    implements Element {
        @NotNull
        private final File myFile;
        @NotNull
        private final File myRoot;
        @NotNull
        private final Browser myBrowser;

        public FileElement(@NotNull Browser browser, @NotNull File file, @NotNull File root) {
            if (browser == null) {
                FileElement.$$$reportNull$$$0(0);
            }
            if (file == null) {
                FileElement.$$$reportNull$$$0(1);
            }
            if (root == null) {
                FileElement.$$$reportNull$$$0(2);
            }
            this.myBrowser = browser;
            this.myRoot = root;
            this.myFile = file;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myFile.getName();
            if (string == null) {
                FileElement.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFullName() {
            String path;
            if (this.myRoot.equals(this.myFile)) {
                if ("" == null) {
                    FileElement.$$$reportNull$$$0(4);
                }
                return "";
            }
            String rootPath = this.myRoot.getAbsolutePath();
            String filePath = this.myFile.getAbsolutePath();
            if (filePath.startsWith(rootPath) && (path = filePath.substring(rootPath.length())).length() > 0 && (path.charAt(0) == '/' || path.charAt(0) == '\\')) {
                String string = FileUtil.toSystemIndependentName((String)path.substring(1));
                if (string == null) {
                    FileElement.$$$reportNull$$$0(5);
                }
                return string;
            }
            String string = FileUtil.toSystemIndependentName((String)this.myFile.getAbsolutePath());
            if (string == null) {
                FileElement.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public Iterable<Element> getChildren() {
            return null;
        }

        @NotNull
        public File getFile() {
            File file = this.myFile;
            if (file == null) {
                FileElement.$$$reportNull$$$0(7);
            }
            return file;
        }

        @Override
        public boolean isContentAvailable() {
            return true;
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IllegalStateException, IOException {
            ArchiveAwareBufferedInputStream archiveAwareBufferedInputStream = new ArchiveAwareBufferedInputStream(this.myFile);
            if (archiveAwareBufferedInputStream == null) {
                FileElement.$$$reportNull$$$0(8);
            }
            return archiveAwareBufferedInputStream;
        }

        @Override
        public long getSize() throws IllegalStateException {
            return this.myFile.length();
        }

        @Override
        @NotNull
        public Browser getBrowser() {
            Browser browser = this.myBrowser;
            if (browser == null) {
                FileElement.$$$reportNull$$$0(9);
            }
            return browser;
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object obj) {
            return obj instanceof FileElement && ((FileElement)obj).getFullName().equals(this.getFullName());
        }

        public int hashCode() {
            return this.getFullName().hashCode();
        }

        @NotNull
        File getRoot() {
            File file = this.myRoot;
            if (file == null) {
                FileElement.$$$reportNull$$$0(10);
            }
            return file;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "browser";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/util/browser/FileSystemBrowser$FileElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/util/browser/FileSystemBrowser$FileElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFullName";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInputStream";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBrowser";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class ArchiveAwareBufferedInputStream
        extends BufferedInputStream
        implements FileAware {
            private final File myFile;

            public ArchiveAwareBufferedInputStream(File file) throws FileNotFoundException {
                super(new FileInputStream(file), FileSystemBrowser.fileReadBufferSize(file));
                this.myFile = file;
            }

            @NotNull
            public File getFile() {
                File file = this.myFile;
                if (file == null) {
                    ArchiveAwareBufferedInputStream.$$$reportNull$$$0(0);
                }
                return file;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/browser/FileSystemBrowser$FileElement$ArchiveAwareBufferedInputStream", "getFile"));
            }
        }
    }
}

