/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.graph;

import gnu.trove.set.hash.TLongHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jetbrains.buildServer.util.ItemProcessor;
import jetbrains.buildServer.util.filters.Filter;
import jetbrains.buildServer.util.graph.BFSVisitor;
import jetbrains.buildServer.util.graph.DAG;
import jetbrains.buildServer.util.graph.DAGIterator;
import jetbrains.buildServer.util.graph.DFSVisitor;
import jetbrains.buildServer.util.graph.DFSVisitorAdapter;
import jetbrains.buildServer.util.graph.DepthFirstSearch;
import jetbrains.buildServer.util.graph.Edge;
import jetbrains.buildServer.util.graph.GreaterOrEqualsThan;
import jetbrains.buildServer.util.graph.ModificationDAGIterator;
import jetbrains.buildServer.util.graph.ModificationDagBFS;
import jetbrains.buildServer.util.graph.ModificationDagDFS;
import jetbrains.buildServer.util.graph.VcsDAGs;
import jetbrains.buildServer.util.graph.VisitedNodesCollector;
import org.jetbrains.annotations.NotNull;

public abstract class BaseModificationDAG
extends DAG<Long> {
    @Override
    @NotNull
    public DAGIterator<Long> iterator() {
        ModificationDAGIterator modificationDAGIterator = new ModificationDAGIterator((DAG<Long>)this, this.getNodesWithoutChildren());
        if (modificationDAGIterator == null) {
            BaseModificationDAG.$$$reportNull$$$0(0);
        }
        return modificationDAGIterator;
    }

    @Override
    @NotNull
    public DAGIterator<Long> iterator(@NotNull Long startNode) {
        if (startNode == null) {
            BaseModificationDAG.$$$reportNull$$$0(1);
        }
        ModificationDAGIterator modificationDAGIterator = new ModificationDAGIterator((DAG<Long>)this, startNode);
        if (modificationDAGIterator == null) {
            BaseModificationDAG.$$$reportNull$$$0(2);
        }
        return modificationDAGIterator;
    }

    @Override
    @NotNull
    public DAGIterator<Long> iterator(@NotNull Collection<Long> startNodes) {
        if (startNodes == null) {
            BaseModificationDAG.$$$reportNull$$$0(3);
        }
        ModificationDAGIterator modificationDAGIterator = new ModificationDAGIterator((DAG<Long>)this, startNodes);
        if (modificationDAGIterator == null) {
            BaseModificationDAG.$$$reportNull$$$0(4);
        }
        return modificationDAGIterator;
    }

    @Override
    public DAG<Long> filter(@NotNull Filter<Long> filter, boolean includeAcceptedNodeParents, boolean extrapolateEdges) {
        if (filter == null) {
            BaseModificationDAG.$$$reportNull$$$0(5);
        }
        ArrayList<Edge<Long>> edges = new ArrayList<Edge<Long>>();
        for (Long node : this.getAllNodes()) {
            if (!filter.accept((Object)node)) continue;
            if (includeAcceptedNodeParents) {
                edges.addAll(this.getEdgesToParents(node));
                continue;
            }
            edges.addAll(this.getAcceptedEdges(node, filter, extrapolateEdges));
        }
        return VcsDAGs.createFromEdges(edges);
    }

    @NotNull
    private List<Edge<Long>> getEdgesToParents(@NotNull Long node) {
        if (node == null) {
            BaseModificationDAG.$$$reportNull$$$0(6);
        }
        ArrayList<Edge<Long>> edges = new ArrayList<Edge<Long>>();
        for (Long parent : this.getParents(node)) {
            edges.add(Edge.createEdge(node, parent));
        }
        if (edges.isEmpty()) {
            edges.add(Edge.createEdge(node, null));
        }
        ArrayList<Edge<Long>> arrayList = edges;
        if (arrayList == null) {
            BaseModificationDAG.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    private List<Edge<Long>> getAcceptedEdges(@NotNull Long node, @NotNull Filter<Long> filter, boolean extrapolateEdges) {
        if (node == null) {
            BaseModificationDAG.$$$reportNull$$$0(8);
        }
        if (filter == null) {
            BaseModificationDAG.$$$reportNull$$$0(9);
        }
        ArrayList<Edge<Long>> acceptedEdges = new ArrayList<Edge<Long>>();
        for (Long parent : this.getParents(node)) {
            if (filter.accept((Object)parent)) {
                acceptedEdges.add(Edge.createEdge(node, parent));
                continue;
            }
            if (!extrapolateEdges) continue;
            List<Long> newParents = this.getAcceptedParents(parent, filter);
            for (Long p : newParents) {
                acceptedEdges.add(Edge.createEdge(node, p));
            }
        }
        if (acceptedEdges.isEmpty()) {
            acceptedEdges.add(Edge.createEdge(node, null));
        }
        ArrayList<Edge<Long>> arrayList = acceptedEdges;
        if (arrayList == null) {
            BaseModificationDAG.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    private List<Long> getAcceptedParents(@NotNull Long node, @NotNull Filter<Long> filter) {
        if (node == null) {
            BaseModificationDAG.$$$reportNull$$$0(11);
        }
        if (filter == null) {
            BaseModificationDAG.$$$reportNull$$$0(12);
        }
        boolean newParentFound = false;
        ArrayList<Long> newParents = new ArrayList<Long>();
        do {
            DAGIterator<Long> iter = this.iterator(node);
            iter.markUninteresting(newParents);
            Long acceptedParent = null;
            do {
                if (filter.accept((Object)(acceptedParent = (Long)iter.next()))) continue;
                acceptedParent = null;
            } while (iter.hasNext() && acceptedParent == null);
            if (acceptedParent != null) {
                newParents.add(acceptedParent);
                newParentFound = true;
                continue;
            }
            newParentFound = false;
        } while (newParentFound);
        ArrayList<Long> arrayList = newParents;
        if (arrayList == null) {
            BaseModificationDAG.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    protected List<Long> toposortFrom(@NotNull Collection<Long> tips) {
        if (tips == null) {
            BaseModificationDAG.$$$reportNull$$$0(14);
        }
        final HashSet visitedNodes = new HashSet();
        final ArrayList<Long> result = new ArrayList<Long>();
        for (Long tip : tips) {
            this.getDepthFirstSearch(tip, (DFSVisitor<Long>)new DFSVisitorAdapter<Long>(){

                @Override
                public boolean discover(@NotNull Long node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return !visitedNodes.contains(node);
                }

                @Override
                public void finish(@NotNull Long node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (visitedNodes.add(node)) {
                        result.add(node);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "node";
                    objectArray2[1] = "jetbrains/buildServer/util/graph/BaseModificationDAG$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "discover";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "finish";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }).run();
        }
        ArrayList<Long> arrayList = result;
        if (arrayList == null) {
            BaseModificationDAG.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    private List<Long> getCommonAncestors(Long v1, List<Long> vs) {
        final TLongHashSet reachable = new TLongHashSet();
        VisitedNodesCollector collector = new VisitedNodesCollector(reachable);
        final ArrayList<ModificationDagDFS> searches = new ArrayList<ModificationDagDFS>();
        for (Long v : vs) {
            searches.add(this.getDepthFirstSearch(v, (DFSVisitor<Long>)collector));
        }
        final ArrayList<Long> result = new ArrayList<Long>();
        this.getDepthFirstSearch(v1, (DFSVisitor<Long>)new DFSVisitorAdapter<Long>(){

            @Override
            public boolean discover(@NotNull Long node) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (DepthFirstSearch dfs : searches) {
                    dfs.runWhile(new GreaterOrEqualsThan(node));
                }
                if (reachable.contains(node.longValue())) {
                    result.add(node);
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "jetbrains/buildServer/util/graph/BaseModificationDAG$2", "discover"));
            }
        }).run();
        ArrayList<Long> arrayList = result;
        if (arrayList == null) {
            BaseModificationDAG.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @Override
    public void breadthFirstSearch(@NotNull Long start, @NotNull BFSVisitor<Long> visitor) {
        if (start == null) {
            BaseModificationDAG.$$$reportNull$$$0(17);
        }
        if (visitor == null) {
            BaseModificationDAG.$$$reportNull$$$0(18);
        }
        this.ensureContainsNode(start);
        new ModificationDagBFS((DAG<Long>)this, start, visitor, true).run();
    }

    @Override
    public void breadthFirstSearch(@NotNull Set<Long> starts, @NotNull BFSVisitor<Long> visitor) {
        if (starts == null) {
            BaseModificationDAG.$$$reportNull$$$0(19);
        }
        if (visitor == null) {
            BaseModificationDAG.$$$reportNull$$$0(20);
        }
        for (Long start : starts) {
            this.ensureContainsNode(start);
        }
        new ModificationDagBFS((DAG<Long>)this, starts, visitor, true).run();
    }

    @Override
    public void reverseBreadthFirstSearch(@NotNull Long start, @NotNull BFSVisitor<Long> visitor) {
        if (start == null) {
            BaseModificationDAG.$$$reportNull$$$0(21);
        }
        if (visitor == null) {
            BaseModificationDAG.$$$reportNull$$$0(22);
        }
        this.ensureContainsNode(start);
        new ModificationDagBFS((DAG<Long>)this, start, visitor, false).run();
    }

    @Override
    public void reverseBreadthFirstSearch(@NotNull Set<Long> starts, @NotNull BFSVisitor<Long> visitor) {
        if (starts == null) {
            BaseModificationDAG.$$$reportNull$$$0(23);
        }
        if (visitor == null) {
            BaseModificationDAG.$$$reportNull$$$0(24);
        }
        for (Long start : starts) {
            this.ensureContainsNode(start);
        }
        new ModificationDagBFS((DAG<Long>)this, starts, visitor, false).run();
    }

    public ModificationDagDFS getDepthFirstSearch(@NotNull Long start, @NotNull DFSVisitor<Long> visitor) {
        if (start == null) {
            BaseModificationDAG.$$$reportNull$$$0(25);
        }
        if (visitor == null) {
            BaseModificationDAG.$$$reportNull$$$0(26);
        }
        this.ensureContainsNode(start);
        return new ModificationDagDFS(this, start, visitor, true);
    }

    @Override
    public DepthFirstSearch<Long> getReverseDepthFirstSearch(@NotNull Long start, @NotNull DFSVisitor<Long> visitor) {
        if (start == null) {
            BaseModificationDAG.$$$reportNull$$$0(27);
        }
        if (visitor == null) {
            BaseModificationDAG.$$$reportNull$$$0(28);
        }
        this.ensureContainsNode(start);
        return new ModificationDagDFS(this, start, visitor, false);
    }

    @Override
    @NotNull
    public List<Long> getCommonAncestors(@NotNull List<Long> nodes) {
        if (nodes == null) {
            BaseModificationDAG.$$$reportNull$$$0(29);
        }
        for (Long n : nodes) {
            this.ensureContainsNode(n);
        }
        if (nodes.size() == 1) {
            List<Long> list = Collections.singletonList(nodes.get(0));
            if (list == null) {
                BaseModificationDAG.$$$reportNull$$$0(30);
            }
            return list;
        }
        List<Long> list = this.getCommonAncestors(nodes.get(0), nodes.subList(1, nodes.size()));
        if (list == null) {
            BaseModificationDAG.$$$reportNull$$$0(31);
        }
        return list;
    }

    @Override
    @NotNull
    public List<Long> getNodesWithoutChildren() {
        final ArrayList<Long> result = new ArrayList<Long>();
        this.processNodesWithoutChildren(new ItemProcessor<Long>(){

            public boolean processItem(Long item) {
                result.add(item);
                return true;
            }
        });
        ArrayList<Long> arrayList = result;
        if (arrayList == null) {
            BaseModificationDAG.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    public int tailSize() {
        int size = 0;
        DAG tail = this.getTail();
        while (!tail.isEmpty()) {
            ++size;
            tail = tail.getTail();
        }
        return size;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/graph/BaseModificationDAG";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startNodes";
                break;
            }
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tips";
                break;
            }
            case 17: 
            case 21: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "starts";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/graph/BaseModificationDAG";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgesToParents";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptedEdges";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptedParents";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "toposortFrom";
                break;
            }
            case 16: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonAncestors";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodesWithoutChildren";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "iterator";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEdgesToParents";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAcceptedEdges";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAcceptedParents";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "toposortFrom";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "breadthFirstSearch";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "reverseBreadthFirstSearch";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getDepthFirstSearch";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getReverseDepthFirstSearch";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getCommonAncestors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

