/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.graph;

import gnu.trove.TLongHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import jetbrains.buildServer.util.graph.BFSVisitor;
import jetbrains.buildServer.util.graph.DAG;
import org.jetbrains.annotations.NotNull;

public class ChildrenFirstSearch {
    private final TreeSet<Long> myNodesToVisit;
    private final TLongHashSet myVisitedNodes;
    private final DAG<Long> myDag;
    private final Set<Long> myStarts;
    private final BFSVisitor<Long> myCallback;

    ChildrenFirstSearch(@NotNull DAG<Long> dag, @NotNull Set<Long> starts, @NotNull BFSVisitor<Long> callback) {
        if (dag == null) {
            ChildrenFirstSearch.$$$reportNull$$$0(0);
        }
        if (starts == null) {
            ChildrenFirstSearch.$$$reportNull$$$0(1);
        }
        if (callback == null) {
            ChildrenFirstSearch.$$$reportNull$$$0(2);
        }
        this.myNodesToVisit = new TreeSet();
        this.myVisitedNodes = new TLongHashSet();
        this.myDag = dag;
        this.myStarts = starts;
        this.myCallback = callback;
    }

    public void run() {
        for (Long start : this.myStarts) {
            this.enqueue(start);
        }
        this.visit();
    }

    private void visit() {
        while (!this.isEmpty()) {
            Long node = this.dequeue();
            if (!this.myCallback.discover(node)) continue;
            for (Long n : this.getNeighbours(node)) {
                if (!this.myVisitedNodes.add(n.longValue())) continue;
                this.enqueue(n);
            }
        }
        this.myCallback.searchFinished();
    }

    private List<Long> getNeighbours(@NotNull Long node) {
        if (node == null) {
            ChildrenFirstSearch.$$$reportNull$$$0(3);
        }
        return this.myDag.getParents(node);
    }

    private boolean isEmpty() {
        return this.myNodesToVisit.isEmpty();
    }

    private void enqueue(Long v) {
        this.myNodesToVisit.add(v);
    }

    private Long dequeue() {
        return this.myNodesToVisit.pollLast();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "starts";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/util/graph/ChildrenFirstSearch";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getNeighbours";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

