/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.graph;

import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.buildServer.util.ItemProcessor;
import jetbrains.buildServer.util.filters.Filter;
import jetbrains.buildServer.util.graph.BFS;
import jetbrains.buildServer.util.graph.BFSVisitor;
import jetbrains.buildServer.util.graph.DAG;
import jetbrains.buildServer.util.graph.DAGs;
import jetbrains.buildServer.util.graph.DFS;
import jetbrains.buildServer.util.graph.DFSVisitor;
import jetbrains.buildServer.util.graph.DFSVisitorAdapter;
import jetbrains.buildServer.util.graph.DepthFirstSearch;
import jetbrains.buildServer.util.graph.Edge;
import jetbrains.buildServer.util.graph.GenericDAG;
import jetbrains.buildServer.util.graph.Vertex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DAGImpl<T>
extends GenericDAG<T> {
    private final Map<T, Pair<Vertex<T>, List<Vertex<T>>>> myAdjacentMap;
    private final Map<T, List<T>> myChildrenMap;
    private final List<T> mySelfNodesWithNullParents;
    private final GenericDAG<T> myTail;

    DAGImpl(@NotNull GenericDAG<T> tail, Collection<? extends Pair<T, T>> edges) {
        if (tail == null) {
            DAGImpl.$$$reportNull$$$0(0);
        }
        this.myAdjacentMap = new HashMap<T, Pair<Vertex<T>, List<Vertex<T>>>>();
        this.myChildrenMap = new HashMap<T, List<T>>();
        this.mySelfNodesWithNullParents = new ArrayList<T>();
        this.myTail = tail;
        for (Pair<T, T> edge : edges) {
            this.addEdge(edge);
        }
    }

    private void addEdge(@NotNull Pair<T, T> edge) {
        if (edge == null) {
            DAGImpl.$$$reportNull$$$0(1);
        }
        Vertex<Object> childVertex = this.addVertex(edge.first);
        Vertex<Object> parentVertex = edge.second != null ? this.addVertex(edge.second) : null;
        this.addEdge(childVertex, parentVertex);
    }

    private Vertex<T> addVertex(@NotNull T value) {
        Vertex<T> existing;
        if (value == null) {
            DAGImpl.$$$reportNull$$$0(2);
        }
        if ((existing = this.findVertex(value)) != null) {
            return existing;
        }
        Vertex<T> v = new Vertex<T>(this, value);
        ArrayList adjList = new ArrayList(2);
        this.myAdjacentMap.put(value, Pair.create(v, adjList));
        this.myChildrenMap.put(value, new ArrayList(2));
        return v;
    }

    private void addEdge(@NotNull Vertex<T> child, @Nullable Vertex<T> parent) {
        if (child == null) {
            DAGImpl.$$$reportNull$$$0(3);
        }
        if (parent != null) {
            List<Vertex<T>> adjList = child.getParents();
            if (!adjList.contains(parent)) {
                adjList.add(parent);
                this.addChild(parent.getValue(), child.getValue());
            }
        } else {
            this.mySelfNodesWithNullParents.add(child.getValue());
        }
    }

    private void addChild(@NotNull T parent, @NotNull T child) {
        List<T> children;
        if (parent == null) {
            DAGImpl.$$$reportNull$$$0(4);
        }
        if (child == null) {
            DAGImpl.$$$reportNull$$$0(5);
        }
        if ((children = this.myChildrenMap.get(parent)) == null) {
            children = new ArrayList<T>(2);
            this.myChildrenMap.put(parent, children);
        }
        if (!children.contains(child)) {
            children.add(child);
        }
    }

    @Override
    @NotNull
    public List<T> toposort() {
        if (this.myAdjacentMap.isEmpty()) {
            List list = this.myTail.toposort();
            if (list == null) {
                DAGImpl.$$$reportNull$$$0(6);
            }
            return list;
        }
        Collection tips = this.getVerticesWithoutChildren();
        if (tips.isEmpty() && !this.isEmpty()) {
            for (Pair<Vertex<T>, List<Vertex<T>>> p : this.myAdjacentMap.values()) {
                tips.add(p.first);
            }
        }
        List<T> result = this.toposortFrom(tips);
        this.checkCycles(result);
        List<T> list = result;
        if (list == null) {
            DAGImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @NotNull
    public List<T> getCommonAncestors(@NotNull List<T> nodes) {
        List<Vertex<T>> verteces;
        if (nodes == null) {
            DAGImpl.$$$reportNull$$$0(8);
        }
        if ((verteces = this.getVerteces(nodes)).size() == 1) {
            List<T> list = Collections.singletonList(verteces.get(0).getValue());
            if (list == null) {
                DAGImpl.$$$reportNull$$$0(9);
            }
            return list;
        }
        List<T> list = this.getCommonAncestors(verteces.get(0), verteces.subList(1, verteces.size()));
        if (list == null) {
            DAGImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    @NotNull
    public List<T> getParents(@NotNull T node) {
        Vertex<T> v;
        if (node == null) {
            DAGImpl.$$$reportNull$$$0(11);
        }
        if ((v = this.findVertex(node)) == null) {
            throw new IllegalArgumentException("Cannot find a vertex for value: " + node);
        }
        List<T> list = this.getParents(v);
        if (list == null) {
            DAGImpl.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Override
    @Nullable
    protected List<T> getSelfParents(@NotNull T node) {
        Pair<Vertex<T>, List<Vertex<T>>> p;
        if (node == null) {
            DAGImpl.$$$reportNull$$$0(13);
        }
        if ((p = this.myAdjacentMap.get(node)) != null) {
            return this.getParents(node);
        }
        return null;
    }

    @Override
    protected void fillSelfChildren(@NotNull T node, @NotNull List<T> accumulator) {
        List<T> myChildren;
        if (node == null) {
            DAGImpl.$$$reportNull$$$0(14);
        }
        if (accumulator == null) {
            DAGImpl.$$$reportNull$$$0(15);
        }
        if ((myChildren = this.myChildrenMap.get(node)) != null) {
            accumulator.addAll(myChildren);
        }
    }

    @Override
    public boolean containsNode(@NotNull T node) {
        if (node == null) {
            DAGImpl.$$$reportNull$$$0(16);
        }
        return this.findVertex(node) != null;
    }

    @Override
    @NotNull
    public List<T> getNodesWithoutChildren() {
        List<T> list = this.toValues(this.getVerticesWithoutChildren());
        if (list == null) {
            DAGImpl.$$$reportNull$$$0(17);
        }
        return list;
    }

    @Override
    protected void processNodesWithoutChildren(@NotNull ItemProcessor<T> nodesProcessor) {
        if (nodesProcessor == null) {
            DAGImpl.$$$reportNull$$$0(18);
        }
        for (Vertex v : this.getVerticesWithoutChildren()) {
            if (nodesProcessor.processItem(v.getValue())) continue;
            return;
        }
    }

    @Override
    @NotNull
    protected List<Vertex<T>> getVerticesWithoutChildren() {
        ArrayList<Vertex<T>> result = new ArrayList<Vertex<T>>();
        Collection<Vertex<T>> tailVerticesWithoutChildren = this.myTail.getVerticesWithoutChildren();
        for (Vertex<T> vertex : tailVerticesWithoutChildren) {
            List<T> children = this.myChildrenMap.get(vertex.getValue());
            if (children != null) continue;
            result.add(vertex);
        }
        for (Map.Entry entry : this.myChildrenMap.entrySet()) {
            Object node = entry.getKey();
            List children = (List)entry.getValue();
            if (!children.isEmpty()) continue;
            result.add(this.findVertex(node));
        }
        ArrayList<Vertex<T>> arrayList = result;
        if (arrayList == null) {
            DAGImpl.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<T> getNodesWithoutParents() {
        ArrayList result = new ArrayList();
        this.fillSelfNodesWithoutParents(result);
        result.addAll(this.myTail.getNodesWithoutParents());
        ArrayList arrayList = result;
        if (arrayList == null) {
            DAGImpl.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    private void fillSelfNodesWithoutParents(@NotNull Collection<T> result) {
        if (result == null) {
            DAGImpl.$$$reportNull$$$0(21);
        }
        for (Map.Entry<T, Pair<Vertex<T>, List<Vertex<T>>>> entry : this.myAdjacentMap.entrySet()) {
            List parents = (List)entry.getValue().second;
            if (parents != null && !parents.isEmpty()) continue;
            result.add(entry.getKey());
        }
    }

    @Override
    void fillNodesWithMissingParents(@NotNull Collection<T> result) {
        if (result == null) {
            DAGImpl.$$$reportNull$$$0(22);
        }
        this.fillSelfNodesWithoutParents(result);
        result.addAll(this.mySelfNodesWithNullParents);
        this.myTail.fillNodesWithMissingParents(result);
    }

    @Override
    public DAG<T> filter(@NotNull Filter<T> filter, boolean includeAcceptedNodeParents, boolean extrapolateEdges) {
        if (filter == null) {
            DAGImpl.$$$reportNull$$$0(23);
        }
        ArrayList<Edge<T>> edges = new ArrayList<Edge<T>>();
        for (T node : this.getAllNodes()) {
            if (!filter.accept(node)) continue;
            Vertex<T> v = this.findVertex(node);
            if (v == null) {
                throw new IllegalStateException("Cannot find vertex for node " + node);
            }
            if (includeAcceptedNodeParents) {
                edges.addAll(v.getEdgesToParents());
                continue;
            }
            edges.addAll(this.getAcceptedEdges(v, filter, extrapolateEdges));
        }
        return DAGs.createFromEdges(edges);
    }

    private List<Edge<T>> getAcceptedEdges(@NotNull Vertex<T> vertex, @NotNull Filter<T> filter, boolean extrapolateEdges) {
        if (vertex == null) {
            DAGImpl.$$$reportNull$$$0(24);
        }
        if (filter == null) {
            DAGImpl.$$$reportNull$$$0(25);
        }
        T node = vertex.getValue();
        ArrayList<Edge<T>> acceptedEdges = new ArrayList<Edge<T>>();
        for (Vertex<T> parent : vertex.getParents()) {
            T parentNode = parent.getValue();
            if (filter.accept(parentNode)) {
                acceptedEdges.add(Edge.createEdge(node, parentNode));
                continue;
            }
            if (!extrapolateEdges) continue;
            List<T> newParents = this.getAcceptedParents(parentNode, filter);
            for (T p : newParents) {
                acceptedEdges.add(Edge.createEdge(node, p));
            }
        }
        if (acceptedEdges.isEmpty()) {
            acceptedEdges.add(Edge.createEdge(node, null));
        }
        return acceptedEdges;
    }

    /*
     * Exception decompiling
     */
    private List<T> getAcceptedParents(@NotNull T node, @NotNull Filter<T> filter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.getBindingFor(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "res" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.getGtbNullFiltered(GenericInferer.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.inferGenericObjectInfoFromCalls(GenericInferer.java:139)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:484)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<T> toValues(@NotNull Collection<Vertex<T>> vertices) {
        if (vertices == null) {
            DAGImpl.$$$reportNull$$$0(28);
        }
        ArrayList<T> result = new ArrayList<T>();
        for (Vertex<T> v : vertices) {
            result.add(v.getValue());
        }
        return result;
    }

    @Override
    private List<T> getParents(@NotNull Vertex<T> vertex) {
        if (vertex == null) {
            DAGImpl.$$$reportNull$$$0(29);
        }
        return this.toValues(vertex.getParents());
    }

    @Override
    public void breadthFirstSearch(@NotNull T start, @NotNull BFSVisitor<T> visitor) {
        Vertex<T> v;
        if (start == null) {
            DAGImpl.$$$reportNull$$$0(30);
        }
        if (visitor == null) {
            DAGImpl.$$$reportNull$$$0(31);
        }
        if ((v = this.findVertex(start)) == null) {
            throw new IllegalArgumentException("Cannot find a vertex for value: " + start);
        }
        new BFS<T>(v, visitor, true).run();
    }

    @Override
    public void breadthFirstSearch(@NotNull Set<T> starts, @NotNull BFSVisitor<T> visitor) {
        if (starts == null) {
            DAGImpl.$$$reportNull$$$0(32);
        }
        if (visitor == null) {
            DAGImpl.$$$reportNull$$$0(33);
        }
        Set<Vertex<T>> startVertices = this.getVertices(starts);
        new BFS<T>(startVertices, visitor, true).run();
    }

    @NotNull
    private Set<Vertex<T>> getVertices(@NotNull Set<T> starts) {
        if (starts == null) {
            DAGImpl.$$$reportNull$$$0(34);
        }
        HashSet<Vertex<T>> startVertices = new HashSet<Vertex<T>>();
        for (T start : starts) {
            Vertex<T> v = this.findVertex(start);
            if (v == null) {
                throw new IllegalArgumentException("Cannot find a vertex for value: " + start);
            }
            startVertices.add(v);
        }
        HashSet<Vertex<T>> hashSet = startVertices;
        if (hashSet == null) {
            DAGImpl.$$$reportNull$$$0(35);
        }
        return hashSet;
    }

    @Override
    public void reverseBreadthFirstSearch(@NotNull T start, @NotNull BFSVisitor<T> visitor) {
        Vertex<T> v;
        if (start == null) {
            DAGImpl.$$$reportNull$$$0(36);
        }
        if (visitor == null) {
            DAGImpl.$$$reportNull$$$0(37);
        }
        if ((v = this.findVertex(start)) == null) {
            throw new IllegalArgumentException("Cannot find a vertex for value: " + start);
        }
        new BFS<T>(v, visitor, false).run();
    }

    @Override
    public void reverseBreadthFirstSearch(@NotNull Set<T> starts, @NotNull BFSVisitor<T> visitor) {
        if (starts == null) {
            DAGImpl.$$$reportNull$$$0(38);
        }
        if (visitor == null) {
            DAGImpl.$$$reportNull$$$0(39);
        }
        Set<Vertex<T>> startVertices = this.getVertices(starts);
        new BFS<T>(startVertices, visitor, false).run();
    }

    @Override
    public DepthFirstSearch<T> getDepthFirstSearch(@NotNull T start, @NotNull DFSVisitor<T> visitor) {
        Vertex<T> v;
        if (start == null) {
            DAGImpl.$$$reportNull$$$0(40);
        }
        if (visitor == null) {
            DAGImpl.$$$reportNull$$$0(41);
        }
        if ((v = this.findVertex(start)) == null) {
            throw new IllegalArgumentException("Cannot find a vertex for value: " + start);
        }
        return this.depthFirstSearch(v, visitor);
    }

    @Override
    public DepthFirstSearch<T> getReverseDepthFirstSearch(@NotNull T start, @NotNull DFSVisitor<T> visitor) {
        Vertex<T> v;
        if (start == null) {
            DAGImpl.$$$reportNull$$$0(42);
        }
        if (visitor == null) {
            DAGImpl.$$$reportNull$$$0(43);
        }
        if ((v = this.findVertex(start)) == null) {
            throw new IllegalArgumentException("Cannot find a vertex for value: " + start);
        }
        return new DFS<T>(v, visitor, false);
    }

    private DepthFirstSearch<T> depthFirstSearch(@NotNull Vertex<T> start, @NotNull DFSVisitor<T> visitor) {
        if (start == null) {
            DAGImpl.$$$reportNull$$$0(44);
        }
        if (visitor == null) {
            DAGImpl.$$$reportNull$$$0(45);
        }
        return new DFS<T>(start, visitor, true);
    }

    @Override
    public int size() {
        return this.selfSize() + this.myTail.size();
    }

    @Override
    protected int selfSize() {
        return this.myAdjacentMap.size();
    }

    @Override
    @NotNull
    protected Collection<Pair<T, T>> getInitialEdges() {
        ArrayList<Pair<T, T>> initialEdges = new ArrayList<Pair<T, T>>();
        for (Map.Entry<T, Pair<Vertex<T>, List<Vertex<T>>>> entry : this.myAdjacentMap.entrySet()) {
            T child = entry.getKey();
            List parents = (List)entry.getValue().second;
            if (parents.isEmpty()) {
                initialEdges.add(Pair.create(child, null));
                continue;
            }
            for (Vertex parentVertex : parents) {
                initialEdges.add(Pair.create(child, parentVertex.getValue()));
            }
            if (!this.mySelfNodesWithNullParents.contains(child)) continue;
            initialEdges.add(Pair.create(child, null));
        }
        ArrayList<Pair<T, T>> arrayList = initialEdges;
        if (arrayList == null) {
            DAGImpl.$$$reportNull$$$0(46);
        }
        return arrayList;
    }

    @Override
    @NotNull
    List<Vertex<T>> getAdjList(@NotNull Vertex<T> vertex) {
        Pair<Vertex<T>, List<Vertex<T>>> p;
        if (vertex == null) {
            DAGImpl.$$$reportNull$$$0(47);
        }
        if ((p = this.myAdjacentMap.get(vertex.getValue())) == null) {
            throw new IllegalArgumentException("Foreign vertex " + vertex);
        }
        List list = (List)p.second;
        if (list == null) {
            DAGImpl.$$$reportNull$$$0(48);
        }
        return list;
    }

    @Override
    @NotNull
    List<Vertex<T>> getChildrenList(@NotNull Vertex<T> vertex) {
        if (vertex == null) {
            DAGImpl.$$$reportNull$$$0(49);
        }
        List<T> children = this.getChildren(vertex.getValue());
        ArrayList<Vertex<T>> childVertices = new ArrayList<Vertex<T>>();
        for (T child : children) {
            Vertex<T> v = this.findVertex(child);
            if (v == null) continue;
            childVertices.add(v);
        }
        ArrayList<Vertex<T>> arrayList = childVertices;
        if (arrayList == null) {
            DAGImpl.$$$reportNull$$$0(50);
        }
        return arrayList;
    }

    @NotNull
    private List<T> toposortFrom(@NotNull Collection<Vertex<T>> tips) {
        if (tips == null) {
            DAGImpl.$$$reportNull$$$0(51);
        }
        final HashSet visitedNodes = new HashSet();
        final ArrayList result = new ArrayList();
        for (Vertex<T> tip : tips) {
            this.depthFirstSearch(tip, (DFSVisitor<T>)new DFSVisitorAdapter<T>(){

                @Override
                public boolean discover(@NotNull T node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return !visitedNodes.contains(node);
                }

                @Override
                public void finish(@NotNull T node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (visitedNodes.add(node)) {
                        result.add(node);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "node";
                    objectArray2[1] = "jetbrains/buildServer/util/graph/DAGImpl$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "discover";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "finish";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }).run();
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            DAGImpl.$$$reportNull$$$0(52);
        }
        return arrayList;
    }

    private List<Vertex<T>> getVerteces(List<T> values) {
        ArrayList<Vertex<T>> result = new ArrayList<Vertex<T>>();
        for (T v : values) {
            Vertex<T> vertex = this.findVertex(v);
            if (vertex != null) {
                result.add(vertex);
                continue;
            }
            throw new IllegalArgumentException("Cannot find a vertex for value: " + v);
        }
        return result;
    }

    @Override
    @Nullable
    protected Vertex<T> findVertex(@NotNull T value) {
        Pair<Vertex<T>, List<Vertex<T>>> p;
        if (value == null) {
            DAGImpl.$$$reportNull$$$0(53);
        }
        if ((p = this.myAdjacentMap.get(value)) != null) {
            return (Vertex)p.first;
        }
        return this.myTail.findVertex(value);
    }

    @NotNull
    private List<T> getCommonAncestors(Vertex<T> v1, List<Vertex<T>> vs) {
        final HashSet visitedNodes = new HashSet();
        for (Vertex<T> v : vs) {
            this.markAllReachableNodes(v, visitedNodes);
        }
        final ArrayList result = new ArrayList();
        this.depthFirstSearch(v1, (DFSVisitor<T>)new DFSVisitorAdapter<T>(){

            @Override
            public void finish(@NotNull T node) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (visitedNodes.contains(node)) {
                    result.add(node);
                }
            }

            @Override
            public boolean discover(@NotNull T node) {
                if (node == null) {
                    2.$$$reportNull$$$0(1);
                }
                return !visitedNodes.contains(node);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "jetbrains/buildServer/util/graph/DAGImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "finish";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "discover";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).run();
        ArrayList arrayList = result;
        if (arrayList == null) {
            DAGImpl.$$$reportNull$$$0(54);
        }
        return arrayList;
    }

    private void markAllReachableNodes(Vertex<T> start, final @NotNull Set<T> visitedNodes) {
        if (visitedNodes == null) {
            DAGImpl.$$$reportNull$$$0(55);
        }
        this.depthFirstSearch(start, (DFSVisitor<T>)new DFSVisitorAdapter<T>(){

            @Override
            public boolean discover(@NotNull T node) {
                if (node == null) {
                    3.$$$reportNull$$$0(0);
                }
                return visitedNodes.add(node);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "jetbrains/buildServer/util/graph/DAGImpl$3", "discover"));
            }
        }).run();
    }

    @Override
    @NotNull
    protected DAG<T> getTail() {
        GenericDAG<T> genericDAG = this.myTail;
        if (genericDAG == null) {
            DAGImpl.$$$reportNull$$$0(56);
        }
        return genericDAG;
    }

    @Override
    @NotNull
    public Set<T> getAllNodes() {
        HashSet allNodes = new HashSet(this.size());
        allNodes.addAll(this.myAdjacentMap.keySet());
        allNodes.addAll(this.myTail.getAllNodes());
        HashSet hashSet = allNodes;
        if (hashSet == null) {
            DAGImpl.$$$reportNull$$$0(57);
        }
        return hashSet;
    }

    public String toString() {
        return "DAGImpl{myAdjacentMap size=" + this.myAdjacentMap.size() + ", myChildrenMap size=" + this.myChildrenMap.size() + ", mySelfNodesWithNullParents size=" + this.mySelfNodesWithNullParents.size() + ", myTail=" + this.myTail.toString() + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 20: 
            case 35: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 57: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 20: 
            case 35: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tail";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
            case 2: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 20: 
            case 35: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/graph/DAGImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accumulator";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesProcessor";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 24: 
            case 29: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vertex";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vertices";
                break;
            }
            case 30: 
            case 36: 
            case 40: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 31: 
            case 33: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 32: 
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "starts";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tips";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/graph/DAGImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toposort";
                break;
            }
            case 9: 
            case 10: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonAncestors";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getParents";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodesWithoutChildren";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getVerticesWithoutChildren";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodesWithoutParents";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getVertices";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialEdges";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdjList";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenList";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "toposortFrom";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getTail";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addEdge";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addVertex";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 20: 
            case 35: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 57: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCommonAncestors";
                break;
            }
            case 11: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getParents";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSelfParents";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fillSelfChildren";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "containsNode";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processNodesWithoutChildren";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "fillSelfNodesWithoutParents";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "fillNodesWithMissingParents";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getAcceptedEdges";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getAcceptedParents";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "toValues";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "breadthFirstSearch";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getVertices";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "reverseBreadthFirstSearch";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getDepthFirstSearch";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getReverseDepthFirstSearch";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "depthFirstSearch";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getAdjList";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenList";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "toposortFrom";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "findVertex";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "markAllReachableNodes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 20: 
            case 35: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 57: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

