/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jetbrains.buildServer.util.graph.DAG;
import jetbrains.buildServer.util.graph.DAGIterator;
import jetbrains.buildServer.util.graph.DFSVisitorAdapter;
import org.jetbrains.annotations.NotNull;

class DAGIteratorImpl<T>
extends DAGIterator<T> {
    private final DAG<T> myGraph;
    private Collection<T> myStartNodes;
    private Collection<T> myUninterestingNodes;
    private boolean myInitialized;
    private Iterator<T> myDelegate;
    private final Set<T> myVisitedVertices;

    DAGIteratorImpl(@NotNull DAG<T> graph) {
        if (graph == null) {
            DAGIteratorImpl.$$$reportNull$$$0(0);
        }
        this.myInitialized = false;
        this.myVisitedVertices = new HashSet<T>();
        this.myGraph = graph;
    }

    DAGIteratorImpl(@NotNull DAG<T> graph, @NotNull T startNode) {
        if (graph == null) {
            DAGIteratorImpl.$$$reportNull$$$0(1);
        }
        if (startNode == null) {
            DAGIteratorImpl.$$$reportNull$$$0(2);
        }
        this(graph);
        this.markStart(startNode);
    }

    DAGIteratorImpl(@NotNull DAG<T> graph, @NotNull Collection<T> startNodes) {
        if (graph == null) {
            DAGIteratorImpl.$$$reportNull$$$0(3);
        }
        if (startNodes == null) {
            DAGIteratorImpl.$$$reportNull$$$0(4);
        }
        this(graph);
        this.markStart(startNodes);
    }

    @Override
    public void markStart(@NotNull T node) {
        if (node == null) {
            DAGIteratorImpl.$$$reportNull$$$0(5);
        }
        this.markStart((Collection<T>)Collections.singletonList(node));
    }

    @Override
    public void markStart(@NotNull Collection<T> nodes) {
        if (nodes == null) {
            DAGIteratorImpl.$$$reportNull$$$0(6);
        }
        this.myStartNodes = nodes;
    }

    @Override
    public void markUninteresting(@NotNull T node) {
        if (node == null) {
            DAGIteratorImpl.$$$reportNull$$$0(7);
        }
        this.markUninteresting((Collection<T>)Collections.singletonList(node));
    }

    @Override
    public void markUninteresting(@NotNull Collection<T> nodes) {
        if (nodes == null) {
            DAGIteratorImpl.$$$reportNull$$$0(8);
        }
        this.myUninterestingNodes = nodes;
    }

    @Override
    public boolean hasNext() {
        if (!this.myInitialized) {
            this.initialize();
        }
        return this.myDelegate.hasNext();
    }

    @Override
    public T next() {
        if (!this.myInitialized) {
            this.initialize();
        }
        return this.myDelegate.next();
    }

    private void initialize() {
        this.doMarkUninteresting();
        List<T> reachableNodes = this.getReachableNodes();
        this.myDelegate = reachableNodes.iterator();
        this.myInitialized = true;
    }

    private void doMarkUninteresting() {
        if (this.myUninterestingNodes != null) {
            for (T node : this.myUninterestingNodes) {
                this.myGraph.depthFirstSearch(node, new DFSVisitorAdapter<T>(){

                    @Override
                    public boolean discover(@NotNull T node) {
                        if (node == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        DAGIteratorImpl.this.markAsVisited(node);
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "jetbrains/buildServer/util/graph/DAGIteratorImpl$1", "discover"));
                    }
                });
            }
        }
    }

    private void markAsVisited(@NotNull T node) {
        if (node == null) {
            DAGIteratorImpl.$$$reportNull$$$0(9);
        }
        this.myVisitedVertices.add(node);
    }

    private boolean isVisited(@NotNull T node) {
        if (node == null) {
            DAGIteratorImpl.$$$reportNull$$$0(10);
        }
        return this.myVisitedVertices.contains(node);
    }

    private List<T> getReachableNodes() {
        final ArrayList result = new ArrayList();
        for (T start : this.myStartNodes) {
            this.myGraph.depthFirstSearch(start, new DFSVisitorAdapter<T>(){

                @Override
                public boolean discover(@NotNull T node) {
                    if (node == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (DAGIteratorImpl.this.isVisited(node)) {
                        return false;
                    }
                    result.add(node);
                    DAGIteratorImpl.this.markAsVisited(node);
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "jetbrains/buildServer/util/graph/DAGIteratorImpl$2", "discover"));
                }
            });
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startNodes";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/util/graph/DAGIteratorImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "markStart";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "markUninteresting";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "markAsVisited";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isVisited";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

